/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.DtmfSender;
import org.qnwebrtc.FrameEncryptorImpl;
import org.qnwebrtc.JniCommon;
import org.qnwebrtc.MediaStreamTrack;
import org.qnwebrtc.RtpParameters;

public class RtpSender {
    private long nativeRtpSender;
    @Nullable
    private MediaStreamTrack cachedTrack;
    private boolean ownsTrack = true;
    @Nullable
    private final DtmfSender dtmfSender;

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    public RtpSender(long nativeRtpSender) {
        void var1_1;
        this.nativeRtpSender = nativeRtpSender;
        long l2 = RtpSender.nativeGetTrack(nativeRtpSender);
        this.cachedTrack = MediaStreamTrack.createMediaStreamTrack(l2);
        long l3 = RtpSender.nativeGetDtmfSender((long)var1_1);
        this.dtmfSender = l3 != 0L ? new DtmfSender(l3) : null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setTrack(@Nullable MediaStreamTrack track, boolean takeOwnership) {
        void var2_2;
        void var1_1;
        this.checkRtpSenderExists();
        if (!RtpSender.nativeSetTrack(this.nativeRtpSender, track == null ? 0L : track.getNativeMediaStreamTrack())) {
            return false;
        }
        if (this.cachedTrack != null && this.ownsTrack) {
            this.cachedTrack.dispose();
        }
        this.cachedTrack = var1_1;
        this.ownsTrack = var2_2;
        return true;
    }

    @Nullable
    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setParameters(RtpParameters parameters) {
        void var1_1;
        this.checkRtpSenderExists();
        return RtpSender.nativeSetParameters(this.nativeRtpSender, (RtpParameters)var1_1);
    }

    public RtpParameters getParameters() {
        this.checkRtpSenderExists();
        return RtpSender.nativeGetParameters(this.nativeRtpSender);
    }

    public String id() {
        this.checkRtpSenderExists();
        return RtpSender.nativeGetId(this.nativeRtpSender);
    }

    @Nullable
    public DtmfSender dtmf() {
        return this.dtmfSender;
    }

    /*
     * WARNING - void declaration
     */
    public void setFrameEncryptor(FrameEncryptorImpl frameEncryptor) {
        void var1_1;
        this.checkRtpSenderExists();
        FrameEncryptorImpl frameEncryptorImpl = frameEncryptor;
        frameEncryptorImpl.setNativeFrameEncryptor(RtpSender.nativeWrapFrameEncryptor(frameEncryptorImpl.getObserver()));
        RtpSender.nativeSetFrameEncryptor(this.nativeRtpSender, var1_1.getNativeFrameEncryptor());
    }

    public void dispose() {
        this.checkRtpSenderExists();
        if (this.dtmfSender != null) {
            this.dtmfSender.dispose();
        }
        if (this.cachedTrack != null && this.ownsTrack) {
            this.cachedTrack.dispose();
        }
        JniCommon.nativeReleaseRef(this.nativeRtpSender);
        this.nativeRtpSender = 0L;
    }

    long getNativeRtpSender() {
        this.checkRtpSenderExists();
        return this.nativeRtpSender;
    }

    private void checkRtpSenderExists() {
        if (this.nativeRtpSender == 0L) {
            throw new IllegalStateException("RtpSender has been disposed.");
        }
    }

    private static native boolean nativeSetTrack(long var0, long var2);

    private static native long nativeGetTrack(long var0);

    private static native long nativeGetDtmfSender(long var0);

    private static native boolean nativeSetParameters(long var0, RtpParameters var2);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native String nativeGetId(long var0);

    private static native void nativeSetFrameEncryptor(long var0, long var2);

    private static native long nativeWrapFrameEncryptor(FrameEncryptorImpl.EncryptorObserver var0);
}

