/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.JniCommon;
import org.qnwebrtc.MediaStreamTrack;
import org.qnwebrtc.RtpParameters;
import org.qnwebrtc.RtpReceiver;
import org.qnwebrtc.RtpSender;

public class RtpTransceiver {
    private long nativeRtpTransceiver;
    private RtpSender cachedSender;
    private RtpReceiver cachedReceiver;

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    protected RtpTransceiver(long nativeRtpTransceiver) {
        void var1_1;
        this.nativeRtpTransceiver = nativeRtpTransceiver;
        this.cachedSender = RtpTransceiver.nativeGetSender(nativeRtpTransceiver);
        this.cachedReceiver = RtpTransceiver.nativeGetReceiver((long)var1_1);
    }

    public MediaStreamTrack.MediaType getMediaType() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeGetMediaType(this.nativeRtpTransceiver);
    }

    public String getMid() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeGetMid(this.nativeRtpTransceiver);
    }

    public RtpSender getSender() {
        return this.cachedSender;
    }

    public RtpReceiver getReceiver() {
        return this.cachedReceiver;
    }

    public boolean isStopped() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeStopped(this.nativeRtpTransceiver);
    }

    public RtpTransceiverDirection getDirection() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeDirection(this.nativeRtpTransceiver);
    }

    public RtpTransceiverDirection getCurrentDirection() {
        this.checkRtpTransceiverExists();
        return RtpTransceiver.nativeCurrentDirection(this.nativeRtpTransceiver);
    }

    /*
     * WARNING - void declaration
     */
    public void setDirection(RtpTransceiverDirection rtpTransceiverDirection) {
        void var1_1;
        this.checkRtpTransceiverExists();
        RtpTransceiver.nativeSetDirection(this.nativeRtpTransceiver, (RtpTransceiverDirection)var1_1);
    }

    public void stop() {
        this.checkRtpTransceiverExists();
        RtpTransceiver.nativeStop(this.nativeRtpTransceiver);
    }

    @CalledByNative
    public void dispose() {
        this.checkRtpTransceiverExists();
        this.cachedSender.dispose();
        this.cachedReceiver.dispose();
        JniCommon.nativeReleaseRef(this.nativeRtpTransceiver);
        this.nativeRtpTransceiver = 0L;
    }

    private void checkRtpTransceiverExists() {
        if (this.nativeRtpTransceiver == 0L) {
            throw new IllegalStateException("RtpTransceiver has been disposed.");
        }
    }

    private static native MediaStreamTrack.MediaType nativeGetMediaType(long var0);

    private static native String nativeGetMid(long var0);

    private static native RtpSender nativeGetSender(long var0);

    private static native RtpReceiver nativeGetReceiver(long var0);

    private static native boolean nativeStopped(long var0);

    private static native RtpTransceiverDirection nativeDirection(long var0);

    private static native RtpTransceiverDirection nativeCurrentDirection(long var0);

    private static native void nativeStop(long var0);

    private static native void nativeSetDirection(long var0, RtpTransceiverDirection var2);

    public static final class RtpTransceiverInit {
        private final RtpTransceiverDirection direction;
        private final List<String> streamIds;
        private final List<RtpParameters.Encoding> sendEncodings;

        public RtpTransceiverInit() {
            this(RtpTransceiverDirection.SEND_RECV);
        }

        /*
         * WARNING - void declaration
         */
        public RtpTransceiverInit(RtpTransceiverDirection direction) {
            this((RtpTransceiverDirection)var1_1, Collections.emptyList(), Collections.emptyList());
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public RtpTransceiverInit(RtpTransceiverDirection direction, List<String> streamIds) {
            this((RtpTransceiverDirection)var1_1, (List<String>)var2_2, Collections.emptyList());
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public RtpTransceiverInit(RtpTransceiverDirection direction, List<String> streamIds, List<RtpParameters.Encoding> sendEncodings) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.direction = var1_1;
            this.streamIds = new ArrayList<String>((Collection<String>)var2_2);
            this.sendEncodings = new ArrayList<RtpParameters.Encoding>((Collection<RtpParameters.Encoding>)var3_3);
        }

        @CalledByNative(value="RtpTransceiverInit")
        final int getDirectionNativeIndex() {
            return this.direction.getNativeIndex();
        }

        @CalledByNative(value="RtpTransceiverInit")
        final List<String> getStreamIds() {
            return new ArrayList<String>(this.streamIds);
        }

        @CalledByNative(value="RtpTransceiverInit")
        final List<RtpParameters.Encoding> getSendEncodings() {
            return new ArrayList<RtpParameters.Encoding>(this.sendEncodings);
        }
    }

    public static enum RtpTransceiverDirection {
        SEND_RECV(0),
        SEND_ONLY(1),
        RECV_ONLY(2),
        INACTIVE(3);

        private final int nativeIndex;

        /*
         * WARNING - void declaration
         */
        private RtpTransceiverDirection(int nativeIndex) {
            void var3_3;
            this.nativeIndex = var3_3;
        }

        @CalledByNative(value="RtpTransceiverDirection")
        final int getNativeIndex() {
            return this.nativeIndex;
        }

        @CalledByNative(value="RtpTransceiverDirection")
        static RtpTransceiverDirection fromNativeIndex(int nativeIndex) {
            int n;
            for (RtpTransceiverDirection rtpTransceiverDirection : RtpTransceiverDirection.values()) {
                if (rtpTransceiverDirection.getNativeIndex() != nativeIndex) continue;
                return rtpTransceiverDirection;
            }
            throw new IllegalArgumentException("Uknown native RtpTransceiverDirection type".concat(String.valueOf(n)));
        }
    }
}

