/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import org.qnwebrtc.LibH264Decoder;
import org.qnwebrtc.LibH265Decoder;
import org.qnwebrtc.LibvpxVp8Decoder;
import org.qnwebrtc.LibvpxVp9Decoder;
import org.qnwebrtc.VideoCodecInfo;
import org.qnwebrtc.VideoDecoder;
import org.qnwebrtc.VideoDecoderFactory;

public class SoftwareVideoDecoderFactory
implements VideoDecoderFactory {
    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    @Nullable
    public VideoDecoder createDecoder(String codecType) {
        void var1_1;
        return this.createDecoder(new VideoCodecInfo((String)var1_1, new HashMap<String, String>()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        void var1_1;
        if (codecType.getName().equalsIgnoreCase("H264")) {
            return new LibH264Decoder();
        }
        if (codecType.getName().equalsIgnoreCase("H265")) {
            return new LibH265Decoder();
        }
        if (codecType.getName().equalsIgnoreCase("VP8") && LibvpxVp8Decoder.nativeIsSupported()) {
            return new LibvpxVp8Decoder();
        }
        if (var1_1.getName().equalsIgnoreCase("VP9") && LibvpxVp9Decoder.nativeIsSupported()) {
            return new LibvpxVp9Decoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoDecoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
        arrayList.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (LibvpxVp9Decoder.nativeIsSupported()) {
            arrayList.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        if (LibH264Decoder.nativeIsSupported()) {
            arrayList.add(new VideoCodecInfo("H264", new HashMap<String, String>()));
        }
        if (LibH265Decoder.nativeIsSupported()) {
            arrayList.add(new VideoCodecInfo("H265", new HashMap<String, String>()));
        }
        ArrayList<VideoCodecInfo> arrayList2 = arrayList;
        return arrayList2.toArray(new VideoCodecInfo[arrayList2.size()]);
    }
}

