/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import org.qnwebrtc.H264Utils;
import org.qnwebrtc.LibH264Encoder;
import org.qnwebrtc.LibH265Encoder;
import org.qnwebrtc.LibvpxVp8Encoder;
import org.qnwebrtc.LibvpxVp9Encoder;
import org.qnwebrtc.VideoCodecInfo;
import org.qnwebrtc.VideoEncoder;
import org.qnwebrtc.VideoEncoderFactory;

public class SoftwareVideoEncoderFactory
implements VideoEncoderFactory {
    private final boolean enableH264HighProfile;

    /*
     * WARNING - void declaration
     */
    public SoftwareVideoEncoderFactory(boolean enableH264HighProfile) {
        void var1_1;
        this.enableH264HighProfile = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info) {
        void var1_1;
        if (info.name.equalsIgnoreCase("H264") && LibH264Encoder.nativeIsSupported()) {
            return new LibH264Encoder(info);
        }
        if (info.name.equalsIgnoreCase("H265") && LibH265Encoder.nativeIsSupported()) {
            return new LibH265Encoder();
        }
        if (info.name.equalsIgnoreCase("VP8") && LibvpxVp8Encoder.nativeIsSupported()) {
            return new LibvpxVp8Encoder();
        }
        if (var1_1.name.equalsIgnoreCase("VP9") && LibvpxVp9Encoder.nativeIsSupported()) {
            return new LibvpxVp9Encoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return this.supportedCodecs();
    }

    VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
        arrayList.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (LibvpxVp9Encoder.nativeIsSupported()) {
            arrayList.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        if (LibH264Encoder.nativeIsSupported()) {
            if (this.enableH264HighProfile) {
                arrayList.add(new VideoCodecInfo("H264", H264Utils.getDefaultH264Params(true)));
            }
            arrayList.add(new VideoCodecInfo("H264", H264Utils.getDefaultH264Params(false)));
        }
        if (LibH265Encoder.nativeIsSupported()) {
            arrayList.add(new VideoCodecInfo("H265", new HashMap<String, String>()));
        }
        ArrayList<VideoCodecInfo> arrayList2 = arrayList;
        return arrayList2.toArray(new VideoCodecInfo[arrayList2.size()]);
    }
}

