/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.view.SurfaceHolder;
import java.util.concurrent.CountDownLatch;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.EglRenderer;
import org.qnwebrtc.Logging;
import org.qnwebrtc.RendererCommon;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.VideoFrame;

public class SurfaceEglRenderer
extends EglRenderer
implements SurfaceHolder.Callback {
    private static final String TAG = "SurfaceEglRenderer";
    private RendererCommon.RendererEvents rendererEvents;
    private final Object layoutLock = new Object();
    private boolean isRenderingPaused;
    private boolean isFirstFrameRendered;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private int frameRotation;

    /*
     * WARNING - void declaration
     */
    public SurfaceEglRenderer(String name) {
        super((String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        void var3_4;
        void var1_1;
        Object object;
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = object;
        object = this.layoutLock;
        synchronized (object) {
            this.isFirstFrameRendered = false;
            this.rotatedFrameWidth = 0;
            this.rotatedFrameHeight = 0;
            this.frameRotation = 0;
        }
        super.init((EglBase.Context)var1_1, (int[])var3_4, drawer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.init((EglBase.Context)var1_1, null, (int[])var2_2, (RendererCommon.GlDrawer)var3_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setFpsReduction(float fps) {
        void var1_1;
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = fps == 0.0f;
        }
        super.setFpsReduction((float)var1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableFpsReduction() {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = false;
        }
        super.disableFpsReduction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseVideo() {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = true;
        }
        super.pauseVideo();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFrame(VideoFrame frame) {
        void var1_1;
        this.updateFrameDimensionsAndReportEvents(frame);
        super.onFrame((VideoFrame)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void surfaceCreated(SurfaceHolder holder) {
        void var1_1;
        ThreadUtils.checkIsOnMainThread();
        this.createEglSurface(var1_1.getSurface());
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        ThreadUtils.checkIsOnMainThread();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.releaseEglSurface(countDownLatch::countDown);
        ThreadUtils.awaitUninterruptibly(countDownLatch);
    }

    /*
     * WARNING - void declaration
     */
    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        void var3_3;
        void var2_2;
        ThreadUtils.checkIsOnMainThread();
        this.logD("surfaceChanged: format: " + (int)var2_2 + " size: " + (int)var3_3 + "x" + height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateFrameDimensionsAndReportEvents(VideoFrame frame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.isRenderingPaused) {
                return;
            }
            if (!this.isFirstFrameRendered) {
                this.isFirstFrameRendered = true;
                this.logD("Reporting first rendered frame.");
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFirstFrameRendered();
                }
            }
            if (this.rotatedFrameWidth != frame.getRotatedWidth() || this.rotatedFrameHeight != frame.getRotatedHeight() || this.frameRotation != frame.getRotation()) {
                void var1_1;
                this.logD("Reporting frame resolution changed to " + frame.getBuffer().getWidth() + "x" + frame.getBuffer().getHeight() + " with rotation " + frame.getRotation());
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation());
                }
                this.rotatedFrameWidth = frame.getRotatedWidth();
                this.rotatedFrameHeight = frame.getRotatedHeight();
                this.frameRotation = var1_1.getRotation();
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logD(String string) {
        void var1_1;
        Logging.d(TAG, this.name + ": " + (String)var1_1);
    }
}

