/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.EglRenderer;
import org.qnwebrtc.GlRectDrawer;
import org.qnwebrtc.Logging;
import org.qnwebrtc.RendererCommon;
import org.qnwebrtc.SurfaceEglRenderer;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoSink;

public class SurfaceViewRenderer
extends SurfaceView
implements SurfaceHolder.Callback,
RendererCommon.RendererEvents,
VideoSink {
    private static final String TAG = "SurfaceViewRenderer";
    private final String resourceName;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
    private final SurfaceEglRenderer eglRenderer;
    private RendererCommon.RendererEvents rendererEvents;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private boolean enableFixedSize;
    private int surfaceWidth;
    private int surfaceHeight;

    /*
     * WARNING - void declaration
     */
    public SurfaceViewRenderer(Context context) {
        super((Context)var1_1);
        void var1_1;
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    /*
     * WARNING - void declaration
     */
    public SurfaceViewRenderer(Context context, AttributeSet attrs) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var2_2;
        void var1_1;
        this.resourceName = this.getResourceName();
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    /*
     * WARNING - void declaration
     */
    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents) {
        void var2_2;
        void var1_1;
        this.init((EglBase.Context)var1_1, (RendererCommon.RendererEvents)var2_2, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    /*
     * WARNING - void declaration
     */
    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        void var3_3;
        void var1_1;
        void var2_2;
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = var2_2;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init((EglBase.Context)var1_1, this, (int[])var3_3, drawer);
    }

    public void release() {
        this.eglRenderer.release();
    }

    /*
     * WARNING - void declaration
     */
    protected void postToRenderThread(Runnable runnable) {
        void var1_1;
        this.eglRenderer.postToRenderThread((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addFrameListener(EglRenderer.FrameListener listener, float scale, RendererCommon.GlDrawer drawerParam) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.eglRenderer.addFrameListener((EglRenderer.FrameListener)var1_1, (float)var2_2, (RendererCommon.GlDrawer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addFrameListener(EglRenderer.FrameListener listener, float scale) {
        void var2_2;
        void var1_1;
        this.eglRenderer.addFrameListener((EglRenderer.FrameListener)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void removeFrameListener(EglRenderer.FrameListener listener) {
        void var1_1;
        this.eglRenderer.removeFrameListener((EglRenderer.FrameListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableHardwareScaler(boolean enabled) {
        void var1_1;
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = var1_1;
        this.updateSurfaceSize();
    }

    /*
     * WARNING - void declaration
     */
    public void setMirror(boolean mirror) {
        void var1_1;
        this.eglRenderer.setMirror((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setFrameStretch(boolean stretch) {
        void var1_1;
        this.eglRenderer.setRenderScale(var1_1 == false);
    }

    /*
     * WARNING - void declaration
     */
    public void setScalingType(RendererCommon.ScalingType scalingType) {
        void var1_1;
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType((RendererCommon.ScalingType)var1_1);
        this.requestLayout();
    }

    /*
     * WARNING - void declaration
     */
    public void setScalingType(RendererCommon.ScalingType scalingTypeMatchOrientation, RendererCommon.ScalingType scalingTypeMismatchOrientation) {
        void var2_2;
        void var1_1;
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType((RendererCommon.ScalingType)var1_1, (RendererCommon.ScalingType)var2_2);
        this.requestLayout();
    }

    /*
     * WARNING - void declaration
     */
    public void setFpsReduction(float fps) {
        void var1_1;
        this.eglRenderer.setFpsReduction((float)var1_1);
    }

    public void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    public void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFrame(VideoFrame frame) {
        void var1_1;
        this.eglRenderer.onFrame((VideoFrame)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void onMeasure(int widthSpec, int heightSpec) {
        void var2_3;
        void var1_1;
        ThreadUtils.checkIsOnMainThread();
        Point point = this.videoLayoutMeasure.measure((int)var1_1, (int)var2_3, this.rotatedFrameWidth, this.rotatedFrameHeight);
        this.setMeasuredDimension(point.x, point.y);
        this.logD("onMeasure(). New size: " + point.x + "x" + point.y);
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        void var3_3;
        void var2_2;
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setLayoutAspectRatio((float)(right - var2_2) / (float)(bottom - var3_3));
        this.updateSurfaceSize();
    }

    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
            int n;
            int n2;
            float f2 = (float)this.getWidth() / (float)this.getHeight();
            if ((float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight > f2) {
                n2 = (int)((float)this.rotatedFrameHeight * f2);
                n = this.rotatedFrameHeight;
            } else {
                n2 = this.rotatedFrameWidth;
                n = (int)((float)this.rotatedFrameWidth / f2);
            }
            n2 = Math.min(this.getWidth(), n2);
            n = Math.min(this.getHeight(), n);
            this.logD("updateSurfaceSize. Layout size: " + this.getWidth() + "x" + this.getHeight() + ", frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + n2 + "x" + n + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
            if (n2 != this.surfaceWidth || n != this.surfaceHeight) {
                this.surfaceWidth = n2;
                this.surfaceHeight = n;
                this.getHolder().setFixedSize(n2, n);
            }
            return;
        }
        SurfaceViewRenderer surfaceViewRenderer = this;
        surfaceViewRenderer.surfaceHeight = 0;
        surfaceViewRenderer.surfaceWidth = 0;
        this.getHolder().setSizeFromLayout();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        ThreadUtils.checkIsOnMainThread();
        SurfaceViewRenderer surfaceViewRenderer = this;
        surfaceViewRenderer.surfaceHeight = 0;
        surfaceViewRenderer.surfaceWidth = 0;
        this.updateSurfaceSize();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId());
        }
        catch (Resources.NotFoundException notFoundException) {
            return "";
        }
    }

    public void clearImage() {
        this.eglRenderer.clearImage();
    }

    @Override
    public void onFirstFrameRendered() {
        if (this.rendererEvents != null) {
            this.rendererEvents.onFirstFrameRendered();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (this.rendererEvents != null) {
            this.rendererEvents.onFrameResolutionChanged(videoWidth, videoHeight, rotation);
        }
        int n = rotation == 0 || rotation == 180 ? videoWidth : videoHeight;
        var1_1 = rotation == 0 || var3_3 == 180 ? var2_2 : var1_1;
        SurfaceViewRenderer surfaceViewRenderer = this;
        surfaceViewRenderer.postOrRun(() -> surfaceViewRenderer.lambda$onFrameResolutionChanged$0(n, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void postOrRun(Runnable r) {
        void var1_1;
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            r.run();
            return;
        }
        this.post((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void logD(String string) {
        void var1_1;
        Logging.d(TAG, this.resourceName + ": " + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$onFrameResolutionChanged$0(int rotatedWidth, int rotatedHeight) {
        void var2_2;
        void var1_1;
        this.rotatedFrameWidth = var1_1;
        this.rotatedFrameHeight = var2_2;
        this.updateSurfaceSize();
        this.requestLayout();
    }
}

