/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.graphics.Matrix;
import android.os.Handler;
import android.support.annotation.Nullable;
import org.qnwebrtc.RefCountDelegate;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.YuvConverter;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private final int unscaledWidth;
    private final int unscaledHeight;
    private final int width;
    private final int height;
    private VideoFrame.TextureBuffer.Type type;
    private int id;
    private final Matrix transformMatrix;
    private final Handler toI420Handler;
    private final YuvConverter yuvConverter;
    private final RefCountDelegate refCountDelegate;

    /*
     * WARNING - void declaration
     */
    public TextureBufferImpl(int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, Handler toI420Handler, YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.unscaledWidth = width;
        this.unscaledHeight = height;
        this.width = var1_1;
        this.height = var2_2;
        this.type = var3_3;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    /*
     * WARNING - void declaration
     */
    private TextureBufferImpl(int unscaledWidth, int unscaledHeight, int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, Handler toI420Handler, YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.unscaledWidth = var1_1;
        this.unscaledHeight = var2_2;
        this.width = var3_3;
        this.height = height;
        this.type = type;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setTextureId(int texId) {
        void var1_1;
        this.id = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setType(VideoFrame.TextureBuffer.Type type) {
        void var1_1;
        this.type = var1_1;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, () -> this.yuvConverter.convert(this));
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        void var3_3;
        void var1_1;
        int n;
        Matrix matrix = new Matrix();
        n = this.height - (n + cropHeight);
        matrix.preTranslate((float)var1_1 / (float)this.width, (float)n / (float)this.height);
        matrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        return this.applyTransformMatrix(matrix, Math.round((float)(this.unscaledWidth * var3_3) / (float)this.width), Math.round((float)(this.unscaledHeight * cropHeight) / (float)this.height), scaleWidth, scaleHeight);
    }

    public int getUnscaledWidth() {
        return this.unscaledWidth;
    }

    public int getUnscaledHeight() {
        return this.unscaledHeight;
    }

    public Handler getToI420Handler() {
        return this.toI420Handler;
    }

    public YuvConverter getYuvConverter() {
        return this.yuvConverter;
    }

    /*
     * WARNING - void declaration
     */
    public TextureBufferImpl applyTransformMatrix(Matrix transformMatrix, int newWidth, int newHeight) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.applyTransformMatrix((Matrix)var1_1, newWidth, newHeight, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private TextureBufferImpl applyTransformMatrix(Matrix transformMatrix, int unscaledWidth, int unscaledHeight, int scaledWidth, int scaledHeight) {
        void var3_3;
        void var2_2;
        void var1_1;
        Matrix matrix = new Matrix(this.transformMatrix);
        matrix.preConcat((Matrix)var1_1);
        this.retain();
        return new TextureBufferImpl((int)var2_2, (int)var3_3, scaledWidth, scaledHeight, this.type, this.id, matrix, this.toI420Handler, this.yuvConverter, this::release);
    }
}

