/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    public static void checkIsOnMainThread() {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new IllegalStateException("Not on main thread!");
        }
    }

    public static void executeUninterruptibly(BlockingOperation operation) {
        boolean bl = false;
        while (true) {
            try {
                operation.run();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean joinUninterruptibly(Thread thread, long timeoutMs) {
        Thread thread2;
        long l2 = SystemClock.elapsedRealtime();
        long l3 = timeoutMs;
        boolean bl = false;
        while (l3 > 0L) {
            try {
                thread.join(l3);
                break;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                long l4 = SystemClock.elapsedRealtime() - l2;
                l3 = timeoutMs - l4;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return !thread2.isAlive();
    }

    public static void joinUninterruptibly(Thread thread) {
        Thread thread2;
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                thread2.join();
            }
        });
    }

    public static void awaitUninterruptibly(CountDownLatch latch) {
        CountDownLatch countDownLatch;
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                countDownLatch.await();
            }
        });
    }

    public static boolean awaitUninterruptibly(CountDownLatch barrier, long timeoutMs) {
        long l2 = SystemClock.elapsedRealtime();
        long l3 = timeoutMs;
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            try {
                bl2 = barrier.await(l3, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                long l4;
                bl = true;
                if ((l3 = timeoutMs - (l4 = SystemClock.elapsedRealtime() - l2)) > 0L) continue;
            }
            break;
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    public static <V> V invokeAtFrontUninterruptibly(Handler handler, Callable<V> callable) {
        void var1_1;
        RuntimeException runtimeException;
        if (handler.getLooper().getThread() == Thread.currentThread()) {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        class Result {
            public V value;

            Result() {
            }
        }
        final Result result = new Result();
        class CaughtException {
            Exception e;

            CaughtException() {
            }
        }
        CaughtException caughtException = new CaughtException();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        runtimeException.post(new Runnable((Callable)var1_1, caughtException, countDownLatch){
            final /* synthetic */ Callable val$callable;
            final /* synthetic */ CaughtException val$caughtException;
            final /* synthetic */ CountDownLatch val$barrier;
            {
                this.val$callable = callable;
                this.val$caughtException = caughtException;
                this.val$barrier = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    result.value = this.val$callable.call();
                }
                catch (Exception exception) {
                    this.val$caughtException.e = exception;
                }
                this.val$barrier.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        if (caughtException.e != null) {
            runtimeException = new RuntimeException(caughtException.e);
            runtimeException.setStackTrace(ThreadUtils.concatStackTraces(caughtException.e.getStackTrace(), runtimeException.getStackTrace()));
            throw runtimeException;
        }
        return result.value;
    }

    /*
     * WARNING - void declaration
     */
    public static void invokeAtFrontUninterruptibly(Handler handler, Runnable runner) {
        void var1_1;
        ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Void>((Runnable)var1_1){
            final /* synthetic */ Runnable val$runner;
            {
                this.val$runner = runnable;
            }

            @Override
            public Void call() {
                this.val$runner.run();
                return null;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    static StackTraceElement[] concatStackTraces(StackTraceElement[] inner, StackTraceElement[] outer) {
        void var1_1;
        StackTraceElement[] stackTraceElementArray;
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[inner.length + outer.length];
        System.arraycopy(inner, 0, stackTraceElementArray2, 0, inner.length);
        System.arraycopy(outer, 0, stackTraceElementArray2, stackTraceElementArray.length, ((void)var1_1).length);
        return stackTraceElementArray2;
    }

    public static interface BlockingOperation {
        public void run() throws InterruptedException;
    }

    public static class ThreadChecker {
        @Nullable
        private Thread thread = Thread.currentThread();

        public void checkIsOnValidThread() {
            if (this.thread == null) {
                this.thread = Thread.currentThread();
            }
            if (Thread.currentThread() != this.thread) {
                throw new IllegalStateException("Wrong thread");
            }
        }

        /*
         * WARNING - void declaration
         */
        public void checkIsOnValidThread(String message) {
            if (this.thread == null) {
                this.thread = Thread.currentThread();
            }
            if (Thread.currentThread() != this.thread) {
                void var1_1;
                boolean bl = message != null && !message.isEmpty();
                throw new IllegalStateException(bl ? "Wrong thread, ".concat(String.valueOf(var1_1)) : "Wrong thread");
            }
        }

        public void detachThread() {
            this.thread = null;
        }
    }
}

