/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.graphics.Matrix;
import java.nio.ByteBuffer;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.RefCounted;

public class VideoFrame
implements RefCounted {
    private final Buffer buffer;
    private final int rotation;
    private final long timestampNs;
    private boolean isForCallback;

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    public VideoFrame(Buffer buffer, int rotation, long timestampNs) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (buffer == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.buffer = var1_1;
        this.rotation = var2_2;
        this.timestampNs = var3_3;
    }

    @CalledByNative
    public Buffer getBuffer() {
        return this.buffer;
    }

    @CalledByNative
    public int getRotation() {
        return this.rotation;
    }

    @CalledByNative
    public long getTimestampNs() {
        return this.timestampNs;
    }

    public int getRotatedWidth() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getWidth();
        }
        return this.buffer.getHeight();
    }

    public int getRotatedHeight() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getHeight();
        }
        return this.buffer.getWidth();
    }

    public boolean isForCallback() {
        return this.isForCallback;
    }

    /*
     * WARNING - void declaration
     */
    public void setIsForCallback(boolean isForCallback) {
        void var1_1;
        this.isForCallback = var1_1;
    }

    @Override
    public void retain() {
        this.buffer.retain();
    }

    @Override
    @CalledByNative
    public void release() {
        this.buffer.release();
    }

    public static interface TextureBuffer
    extends Buffer {
        public Type getType();

        public int getTextureId();

        public void setTextureId(int var1);

        public void setType(Type var1);

        public Matrix getTransformMatrix();

        public static enum Type {
            OES(36197),
            RGB(3553);

            private final int glTarget;

            /*
             * WARNING - void declaration
             */
            private Type(int glTarget) {
                void var3_3;
                this.glTarget = var3_3;
            }

            public final int getGlTarget() {
                return this.glTarget;
            }
        }
    }

    public static interface I420Buffer
    extends Buffer {
        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataY();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataU();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataV();

        @CalledByNative(value="I420Buffer")
        public int getStrideY();

        @CalledByNative(value="I420Buffer")
        public int getStrideU();

        @CalledByNative(value="I420Buffer")
        public int getStrideV();
    }

    public static interface Buffer
    extends RefCounted {
        @CalledByNative(value="Buffer")
        public int getWidth();

        @CalledByNative(value="Buffer")
        public int getHeight();

        @CalledByNative(value="Buffer")
        public I420Buffer toI420();

        @Override
        @CalledByNative(value="Buffer")
        public void retain();

        @Override
        @CalledByNative(value="Buffer")
        public void release();

        @CalledByNative(value="Buffer")
        public Buffer cropAndScale(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

