/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.GLES20;
import android.support.annotation.Nullable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.qnwebrtc.GlUtil;
import org.qnwebrtc.Logging;
import org.qnwebrtc.RendererCommon;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.YuvHelper;

public class VideoFrameDrawer {
    public static final String TAG = "VideoFrameDrawer";
    static final float[] srcPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private final float[] dstPoints = new float[6];
    private final Point renderSize = new Point();
    private int renderWidth;
    private int renderHeight;
    private final YuvUploader yuvUploader = new YuvUploader();
    @Nullable
    private VideoFrame lastI420Frame;
    private final Matrix renderMatrix = new Matrix();

    /*
     * WARNING - void declaration
     */
    public static void drawTexture(RendererCommon.GlDrawer drawer, VideoFrame.TextureBuffer buffer, Matrix renderMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        float[] fArray;
        Matrix matrix = new Matrix(buffer.getTransformMatrix());
        matrix.preConcat((Matrix)fArray);
        fArray = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(matrix);
        switch (buffer.getType()) {
            case OES: {
                drawer.drawOes(buffer.getTextureId(), fArray, frameWidth, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight);
                return;
            }
            case RGB: {
                void var3_3;
                void var1_1;
                RendererCommon.GlDrawer glDrawer;
                glDrawer.drawRgb(var1_1.getTextureId(), fArray, (int)var3_3, frameHeight, viewportX, viewportY, viewportWidth, viewportHeight);
                return;
            }
        }
        throw new RuntimeException("Unknown texture type.");
    }

    /*
     * WARNING - void declaration
     */
    private static int distance(float x0, float y0, float x1, float y1) {
        void var1_1;
        void var3_3;
        float f2;
        return (int)Math.round(Math.hypot(x1 - f2, (double)(var3_3 - var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private void calculateTransformedRenderSize(int frameWidth, int frameHeight, @Nullable Matrix renderMatrix) {
        void var3_3;
        if (renderMatrix == null) {
            this.renderWidth = frameWidth;
            this.renderHeight = frameHeight;
            return;
        }
        var3_3.mapPoints(this.dstPoints, srcPoints);
        for (int i2 = 0; i2 < 3; ++i2) {
            int n = i2 * 2 + 0;
            this.dstPoints[n] = this.dstPoints[n] * (float)frameWidth;
            int n2 = i2 * 2 + 1;
            this.dstPoints[n2] = this.dstPoints[n2] * (float)frameHeight;
        }
        this.renderWidth = VideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[2], this.dstPoints[3]);
        this.renderHeight = VideoFrameDrawer.distance(this.dstPoints[0], this.dstPoints[1], this.dstPoints[4], this.dstPoints[5]);
    }

    /*
     * WARNING - void declaration
     */
    public void drawFrame(VideoFrame frame, RendererCommon.GlDrawer drawer) {
        void var2_2;
        void var1_1;
        this.drawFrame((VideoFrame)var1_1, (RendererCommon.GlDrawer)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void drawFrame(VideoFrame frame, RendererCommon.GlDrawer drawer, Matrix additionalRenderMatrix) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.drawFrame(frame, (RendererCommon.GlDrawer)var2_2, (Matrix)var3_3, 0, 0, frame.getRotatedWidth(), var1_1.getRotatedHeight());
    }

    /*
     * WARNING - void declaration
     */
    public void drawFrame(VideoFrame frame, RendererCommon.GlDrawer drawer, @Nullable Matrix additionalRenderMatrix, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        void var2_2;
        int n = frame.getRotatedWidth();
        int n2 = frame.getRotatedHeight();
        this.calculateTransformedRenderSize(n, n2, additionalRenderMatrix);
        if (this.renderWidth <= 0 || this.renderHeight <= 0) {
            Logging.w(TAG, "Illegal frame size: " + this.renderWidth + "x" + this.renderHeight);
            return;
        }
        n = frame.getBuffer() instanceof VideoFrame.TextureBuffer;
        this.renderMatrix.reset();
        this.renderMatrix.preTranslate(0.5f, 0.5f);
        if (n == 0) {
            this.renderMatrix.preScale(1.0f, -1.0f);
        }
        this.renderMatrix.preRotate((float)frame.getRotation());
        this.renderMatrix.preTranslate(-0.5f, -0.5f);
        if (additionalRenderMatrix != null) {
            void var3_3;
            this.renderMatrix.preConcat((Matrix)var3_3);
        }
        if (n != 0) {
            this.lastI420Frame = null;
            VideoFrameDrawer.drawTexture(drawer, (VideoFrame.TextureBuffer)frame.getBuffer(), this.renderMatrix, this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight);
            return;
        }
        if (frame != this.lastI420Frame) {
            VideoFrame.I420Buffer i420Buffer;
            this.lastI420Frame = frame;
            i420Buffer = ((VideoFrame)((Object)i420Buffer)).getBuffer().toI420();
            this.yuvUploader.uploadFromBuffer(i420Buffer);
            i420Buffer.release();
        }
        var2_2.drawYuv(this.yuvUploader.getYuvTextures(), RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, viewportX, viewportY, viewportWidth, viewportHeight);
    }

    /*
     * WARNING - void declaration
     */
    public VideoFrame.Buffer prepareBufferForViewportSize(VideoFrame.Buffer buffer, int width, int height) {
        void var1_1;
        buffer.retain();
        return var1_1;
    }

    public void release() {
        this.yuvUploader.release();
        this.lastI420Frame = null;
    }

    static class YuvUploader {
        @Nullable
        private ByteBuffer copyBuffer;
        @Nullable
        private int[] yuvTextures;

        private YuvUploader() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public int[] uploadYuvData(int width, int height, int[] strides, ByteBuffer[] planes) {
            int n;
            void var2_3;
            void var1_1;
            int[] nArray = new int[]{width, width / 2, var1_1 / 2};
            int[] nArray2 = new int[]{height, height / 2, var2_3 / 2};
            int n2 = 0;
            for (n = 0; n < 3; ++n) {
                if (strides[n] <= nArray[n]) continue;
                n2 = Math.max(n2, nArray[n] * nArray2[n]);
            }
            if (n2 > 0 && (this.copyBuffer == null || this.copyBuffer.capacity() < n2)) {
                this.copyBuffer = ByteBuffer.allocateDirect(n2);
            }
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (n = 0; n < 3; ++n) {
                    this.yuvTextures[n] = GlUtil.generateTexture(3553);
                }
            }
            for (n = 0; n < 3; ++n) {
                ByteBuffer byteBuffer;
                GLES20.glActiveTexture((int)(33984 + n));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[n]);
                if (strides[n] == nArray[n]) {
                    byteBuffer = planes[n];
                } else {
                    YuvHelper.copyPlane(planes[n], strides[n], this.copyBuffer, nArray[n], nArray[n], nArray2[n]);
                    byteBuffer = this.copyBuffer;
                }
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)nArray[n], (int)nArray2[n], (int)0, (int)6409, (int)5121, (Buffer)byteBuffer);
            }
            return this.yuvTextures;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public int[] uploadFromBuffer(VideoFrame.I420Buffer buffer) {
            void var1_1;
            int[] nArray = new int[]{buffer.getStrideY(), buffer.getStrideU(), buffer.getStrideV()};
            ByteBuffer[] byteBufferArray = new ByteBuffer[]{buffer.getDataY(), buffer.getDataU(), buffer.getDataV()};
            return this.uploadYuvData(buffer.getWidth(), var1_1.getHeight(), nArray, byteBufferArray);
        }

        @Nullable
        public int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public void release() {
            this.copyBuffer = null;
            if (this.yuvTextures != null) {
                GLES20.glDeleteTextures((int)3, (int[])this.yuvTextures, (int)0);
                this.yuvTextures = null;
            }
        }
    }
}

