/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import org.qnwebrtc.CapturerObserver;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoSink;

public interface VideoProcessor
extends CapturerObserver {
    /*
     * WARNING - void declaration
     */
    default public void onFrameCaptured(VideoFrame frame, FrameAdaptationParameters parameters) {
        void var2_2;
        VideoFrame videoFrame = VideoProcessor.applyFrameAdaptationParameters(frame, (FrameAdaptationParameters)var2_2);
        if (videoFrame != null) {
            this.onFrameCaptured(videoFrame);
            videoFrame.release();
        }
    }

    public void setSink(@Nullable VideoSink var1);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static VideoFrame applyFrameAdaptationParameters(VideoFrame frame, FrameAdaptationParameters parameters) {
        void var1_1;
        VideoFrame videoFrame;
        if (parameters.drop) {
            return null;
        }
        VideoFrame.Buffer buffer = frame.getBuffer().cropAndScale(parameters.cropX, parameters.cropY, parameters.cropWidth, parameters.cropHeight, parameters.scaleWidth, parameters.scaleHeight);
        return new VideoFrame(buffer, videoFrame.getRotation(), var1_1.timestampNs);
    }

    public static class FrameAdaptationParameters {
        public final int cropX;
        public final int cropY;
        public final int cropWidth;
        public final int cropHeight;
        public final int scaleWidth;
        public final int scaleHeight;
        public final long timestampNs;
        public final boolean drop;

        /*
         * WARNING - void declaration
         */
        public FrameAdaptationParameters(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, long timestampNs, boolean drop) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.cropX = var1_1;
            this.cropY = var2_2;
            this.cropWidth = var3_3;
            this.cropHeight = cropHeight;
            this.scaleWidth = scaleWidth;
            this.scaleHeight = scaleHeight;
            this.timestampNs = timestampNs;
            this.drop = drop;
        }
    }
}

