/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import org.qnwebrtc.CapturerObserver;
import org.qnwebrtc.MediaSource;
import org.qnwebrtc.NativeAndroidVideoTrackSource;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoProcessor;

public class VideoSource
extends MediaSource {
    private final NativeAndroidVideoTrackSource nativeAndroidVideoTrackSource;
    private final Object videoProcessorLock = new Object();
    @Nullable
    private VideoProcessor videoProcessor;
    private boolean isCapturerRunning;
    private final CapturerObserver capturerObserver = new CapturerObserver(this){
        final /* synthetic */ VideoSource this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void onCapturerStarted(boolean success) {
            this.this$0.nativeAndroidVideoTrackSource.setState(success);
            Object object = this.this$0.videoProcessorLock;
            synchronized (object) {
                VideoSource.access$202(this.this$0, success);
                if (this.this$0.videoProcessor != null) {
                    void var1_1;
                    this.this$0.videoProcessor.onCapturerStarted((boolean)var1_1);
                }
                return;
            }
        }

        @Override
        public void onCapturerStoppedInCapturerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCapturerStopped() {
            this.this$0.nativeAndroidVideoTrackSource.setState(false);
            Object object = this.this$0.videoProcessorLock;
            synchronized (object) {
                VideoSource.access$202(this.this$0, false);
                if (this.this$0.videoProcessor != null) {
                    this.this$0.videoProcessor.onCapturerStopped();
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void onFrameCaptured(VideoFrame frame) {
            void var1_1;
            VideoProcessor.FrameAdaptationParameters frameAdaptationParameters = this.this$0.nativeAndroidVideoTrackSource.adaptFrame(frame);
            Object object = this.this$0.videoProcessorLock;
            synchronized (object) {
                if (this.this$0.videoProcessor != null) {
                    this.this$0.videoProcessor.onFrameCaptured(frame, frameAdaptationParameters);
                    return;
                }
            }
            object = VideoProcessor.applyFrameAdaptationParameters((VideoFrame)var1_1, frameAdaptationParameters);
            if (object != null) {
                this.this$0.nativeAndroidVideoTrackSource.onFrameCaptured((VideoFrame)object);
                ((VideoFrame)object).release();
            }
        }
    };

    /*
     * WARNING - void declaration
     */
    public VideoSource(long nativeSource) {
        super(nativeSource);
        void var1_1;
        this.nativeAndroidVideoTrackSource = new NativeAndroidVideoTrackSource((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void adaptOutputFormat(int width, int height, int fps) {
        void var3_3;
        void var2_2;
        int n;
        int n2 = Math.max(width, height);
        int n3 = n = Math.min(n, (int)var2_2);
        this.adaptOutputFormat(n2, n3, n3, n2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void adaptOutputFormat(int landscapeWidth, int landscapeHeight, int portraitWidth, int portraitHeight, int fps) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.adaptOutputFormat(new AspectRatio(landscapeWidth, landscapeHeight), (Integer)((int)(var1_1 * var2_2)), new AspectRatio(portraitWidth, portraitHeight), (Integer)((int)(var3_3 * portraitHeight)), (Integer)fps);
    }

    /*
     * WARNING - void declaration
     */
    public void adaptOutputFormat(AspectRatio targetLandscapeAspectRatio, @Nullable Integer maxLandscapePixelCount, AspectRatio targetPortraitAspectRatio, @Nullable Integer maxPortraitPixelCount, @Nullable Integer maxFps) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.nativeAndroidVideoTrackSource.adaptOutputFormat((AspectRatio)var1_1, (Integer)var2_2, (AspectRatio)var3_3, maxPortraitPixelCount, maxFps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setVideoProcessor(@Nullable VideoProcessor newVideoProcessor) {
        Object object = this.videoProcessorLock;
        synchronized (object) {
            if (this.videoProcessor != null) {
                this.videoProcessor.setSink(null);
                if (this.isCapturerRunning) {
                    this.videoProcessor.onCapturerStopped();
                }
            }
            this.videoProcessor = newVideoProcessor;
            if (newVideoProcessor != null) {
                newVideoProcessor.setSink(this.nativeAndroidVideoTrackSource::onFrameCaptured);
                if (this.isCapturerRunning) {
                    void var1_1;
                    var1_1.onCapturerStarted(true);
                }
            }
            return;
        }
    }

    public CapturerObserver getCapturerObserver() {
        return this.capturerObserver;
    }

    long getNativeVideoTrackSource() {
        return this.getNativeMediaSource();
    }

    @Override
    public void dispose() {
        this.setVideoProcessor(null);
        super.dispose();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$202(VideoSource x0, boolean x1) {
        void var1_1;
        x0.isCapturerRunning = var1_1;
        return x0.isCapturerRunning;
    }

    public static class AspectRatio {
        public static final AspectRatio UNDEFINED = new AspectRatio(0, 0);
        public final int width;
        public final int height;

        /*
         * WARNING - void declaration
         */
        public AspectRatio(int width, int height) {
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
        }
    }
}

