/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import java.util.IdentityHashMap;
import org.qnwebrtc.MediaStreamTrack;
import org.qnwebrtc.VideoSink;

public class VideoTrack
extends MediaStreamTrack {
    private final IdentityHashMap<VideoSink, Long> sinks = new IdentityHashMap();

    /*
     * WARNING - void declaration
     */
    public VideoTrack(long nativeTrack) {
        super((long)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addSink(VideoSink sink) {
        if (sink == null) {
            throw new IllegalArgumentException("The VideoSink is not allowed to be null");
        }
        if (!this.sinks.containsKey(sink)) {
            void var1_1;
            long l2 = VideoTrack.nativeWrapSink(sink);
            this.sinks.put((VideoSink)var1_1, l2);
            VideoTrack.nativeAddSink(this.getNativeMediaStreamTrack(), l2);
        }
    }

    public void removeSink(VideoSink sink) {
        Long l2;
        if ((l2 = this.sinks.remove(l2)) != null) {
            VideoTrack.nativeRemoveSink(this.getNativeMediaStreamTrack(), l2);
            VideoTrack.nativeFreeSink(l2);
        }
    }

    @Override
    public void dispose() {
        for (long l2 : this.sinks.values()) {
            VideoTrack.nativeRemoveSink(this.getNativeMediaStreamTrack(), l2);
            VideoTrack.nativeFreeSink(l2);
        }
        this.sinks.clear();
        super.dispose();
    }

    long getNativeVideoTrack() {
        return this.getNativeMediaStreamTrack();
    }

    private static native void nativeAddSink(long var0, long var2);

    private static native void nativeRemoveSink(long var0, long var2);

    private static native long nativeWrapSink(VideoSink var0);

    private static native void nativeFreeSink(long var0);
}

