/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc.audio;

import android.content.Context;
import android.media.AudioManager;
import java.nio.ByteBuffer;
import org.qnwebrtc.JniCommon;
import org.qnwebrtc.Logging;
import org.qnwebrtc.audio.AudioDeviceModule;
import org.qnwebrtc.audio.WebRtcAudioEffects;
import org.qnwebrtc.audio.WebRtcAudioManager;
import org.qnwebrtc.audio.WebRtcAudioRecord;
import org.qnwebrtc.audio.WebRtcAudioTrack;
import org.qnwebrtc.audio.WebRtcOpenSLESPlayer;

public class JavaAudioDeviceModule
implements AudioDeviceModule {
    private static final String TAG = "JavaAudioDeviceModule";
    private final Context context;
    private final AudioManager audioManager;
    private final WebRtcAudioRecord audioInput;
    private final WebRtcAudioTrack audioOutput;
    private final WebRtcOpenSLESPlayer audioLowLatencyOutput;
    private int inputSampleRate;
    private final int outputSampleRate;
    private boolean useStereoInput;
    private final boolean useStereoOutput;
    private final Object nativeLock = new Object();
    private long nativeAudioDeviceModule;

    public static Builder builder(Context context) {
        Context context2;
        return new Builder(context2);
    }

    public static boolean isBuiltInAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.isAcousticEchoCancelerSupported();
    }

    public static boolean isBuiltInNoiseSuppressorSupported() {
        return WebRtcAudioEffects.isNoiseSuppressorSupported();
    }

    /*
     * WARNING - void declaration
     */
    private JavaAudioDeviceModule(Context context, AudioManager audioManager, WebRtcAudioRecord audioInput, WebRtcAudioTrack audioOutput, WebRtcOpenSLESPlayer audioLowLatencyOutput, int inputSampleRate, int outputSampleRate, boolean useStereoInput, boolean useStereoOutput) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.context = var1_1;
        this.audioManager = var2_2;
        this.audioInput = var3_3;
        this.audioOutput = audioOutput;
        this.audioLowLatencyOutput = audioLowLatencyOutput;
        this.inputSampleRate = inputSampleRate;
        this.outputSampleRate = outputSampleRate;
        this.useStereoInput = useStereoInput;
        this.useStereoOutput = useStereoOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNativeAudioDeviceModulePointer() {
        Object object = this.nativeLock;
        synchronized (object) {
            if (this.nativeAudioDeviceModule == 0L) {
                this.nativeAudioDeviceModule = JavaAudioDeviceModule.nativeCreateAudioDeviceModule(this.context, this.audioManager, this.audioInput, this.audioOutput, this.audioLowLatencyOutput, this.inputSampleRate, this.outputSampleRate, this.useStereoInput, this.useStereoOutput);
            }
            return this.nativeAudioDeviceModule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.nativeLock;
        synchronized (object) {
            if (this.nativeAudioDeviceModule != 0L) {
                JniCommon.nativeReleaseRef(this.nativeAudioDeviceModule);
                this.nativeAudioDeviceModule = 0L;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSpeakerMute(boolean mute) {
        Logging.d(TAG, "setSpeakerMute: ".concat(String.valueOf(mute)));
        if (this.audioOutput != null) {
            this.audioOutput.setSpeakerMute(mute);
        }
        if (this.audioLowLatencyOutput != null) {
            void var1_1;
            this.audioLowLatencyOutput.setSpeakerMute((boolean)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAudioTrackEventListener(AudioTrackEventListener listener) {
        if (this.audioOutput != null) {
            this.audioOutput.setAudioTrackEventListener(listener);
        }
        if (this.audioLowLatencyOutput != null) {
            void var1_1;
            this.audioLowLatencyOutput.setAudioTrackEventListener((AudioTrackEventListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPlayDataCallback(AudioDataCallback callback) {
        if (this.audioOutput != null) {
            this.audioOutput.setPlayDataCallback(callback);
        }
        if (this.audioLowLatencyOutput != null) {
            void var1_1;
            this.audioLowLatencyOutput.setPlayDataCallback((AudioDataCallback)var1_1);
        }
    }

    public int getInputSamplerate() {
        return this.inputSampleRate;
    }

    public int getOutputSamplerate() {
        return this.outputSampleRate;
    }

    public boolean isUseInputStereo() {
        return this.useStereoInput;
    }

    public boolean isUseOutputStereo() {
        return this.useStereoOutput;
    }

    public int getAudioFormat() {
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    public void setUseCommunicationMode(boolean useCommunicationMode) {
        if (this.audioInput != null) {
            this.audioInput.setAudioSource(useCommunicationMode ? 7 : 1);
        }
        if (this.audioOutput != null) {
            void var1_1;
            this.audioOutput.setUseCommunicationMode((boolean)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAudioRecordEventListener(AudioRecordEventListener listener) {
        void var1_1;
        this.audioInput.setAudioRecordEventListener((AudioRecordEventListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAudioSourceCallback(AudioSourceCallback callback) {
        void var1_1;
        this.audioInput.setAudioSourceCallback((AudioSourceCallback)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMicrophoneAudioSourceCallback(AudioSourceCallback callback) {
        void var1_1;
        this.audioInput.setMicrophoneAudioSourceCallback((AudioSourceCallback)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setInputAudioParams(int sampleRate, int channels) {
        if (this.audioInput != null && this.audioInput.setAudioParams(sampleRate, channels)) {
            void var2_2;
            void var1_1;
            this.inputSampleRate = var1_1;
            this.useStereoInput = var2_2 == 2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void enableExternalAudioRecord(boolean useExternal) {
        if (this.audioInput != null) {
            void var1_1;
            this.audioInput.setExternalAudioInputEnabled((boolean)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void inputExternalAudioFrame(byte[] audioData) {
        if (this.audioInput != null) {
            void var1_1;
            this.audioInput.inputExternalAudioFrame((byte[])var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMicrophoneMute(boolean mute) {
        void var1_1;
        Logging.d(TAG, "setMicrophoneMute: ".concat(String.valueOf(mute)));
        this.audioInput.setMicrophoneMute((boolean)var1_1);
    }

    private static native long nativeCreateAudioDeviceModule(Context var0, AudioManager var1, WebRtcAudioRecord var2, WebRtcAudioTrack var3, WebRtcOpenSLESPlayer var4, int var5, int var6, boolean var7, boolean var8);

    public static interface AudioTrackErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(AudioTrackStartErrorCode var1, String var2);

        public void onWebRtcAudioTrackError(String var1);
    }

    public static enum AudioTrackStartErrorCode {
        AUDIO_TRACK_START_EXCEPTION,
        AUDIO_TRACK_START_STATE_MISMATCH;

    }

    public static interface AudioDataCallback {
        public void onAudioDataAvailable(ByteBuffer var1, int var2, int var3, int var4, int var5, long var6);
    }

    public static interface AudioSourceCallback {
        public void onAudioSourceAvailable(ByteBuffer var1, int var2, long var3);
    }

    public static interface SamplesReadyCallback {
        public void onWebRtcAudioRecordSamplesReady(AudioSamples var1);
    }

    public static class AudioSamples {
        private final int audioFormat;
        private final int channelCount;
        private final int sampleRate;
        private final byte[] data;

        /*
         * WARNING - void declaration
         */
        public AudioSamples(int audioFormat, int channelCount, int sampleRate, byte[] data) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.audioFormat = var1_1;
            this.channelCount = var2_2;
            this.sampleRate = var3_3;
            this.data = data;
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static interface AudioTrackEventListener {
        public void onWebRtcAudioTrackInitDone();

        public void onWebRtcAudioTrackReleased();
    }

    public static interface AudioRecordEventListener {
        public void onWebRtcAudioRecordInitDone();

        public void onWebRtcAudioRecordReleased();
    }

    public static interface AudioRecordErrorCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);
    }

    public static enum AudioRecordStartErrorCode {
        AUDIO_RECORD_START_EXCEPTION,
        AUDIO_RECORD_START_STATE_MISMATCH;

    }

    public static class Builder {
        private final Context context;
        private final AudioManager audioManager;
        private int inputSampleRate;
        private int outputSampleRate;
        private int audioSource = 7;
        private int audioFormat = 2;
        private AudioTrackEventListener audioTrackEventListener;
        private AudioTrackErrorCallback audioTrackErrorCallback;
        private AudioRecordEventListener audioRecordEventListener;
        private AudioRecordErrorCallback audioRecordErrorCallback;
        private SamplesReadyCallback samplesReadyCallback;
        private boolean useHardwareAcousticEchoCanceler = JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported();
        private boolean useHardwareNoiseSuppressor = JavaAudioDeviceModule.isBuiltInNoiseSuppressorSupported();
        private boolean useStereoInput;
        private boolean useStereoOutput;
        private boolean useLowLatencyOutput;
        private boolean useCommunicationMode = true;

        /*
         * WARNING - void declaration
         */
        private Builder(Context context) {
            void var1_1;
            this.context = context;
            this.audioManager = (AudioManager)var1_1.getSystemService("audio");
            this.inputSampleRate = WebRtcAudioManager.getSampleRate(this.audioManager);
            this.outputSampleRate = WebRtcAudioManager.getSampleRate(this.audioManager);
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSampleRate(int sampleRate) {
            void var1_1;
            Logging.d(JavaAudioDeviceModule.TAG, "Input/Output sample rate overridden to: ".concat(String.valueOf(sampleRate)));
            this.inputSampleRate = sampleRate;
            this.outputSampleRate = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setInputSampleRate(int inputSampleRate) {
            void var1_1;
            Logging.d(JavaAudioDeviceModule.TAG, "Input sample rate overridden to: ".concat(String.valueOf(inputSampleRate)));
            this.inputSampleRate = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setOutputSampleRate(int outputSampleRate) {
            void var1_1;
            Logging.d(JavaAudioDeviceModule.TAG, "Output sample rate overridden to: ".concat(String.valueOf(outputSampleRate)));
            this.outputSampleRate = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAudioSource(int audioSource) {
            void var1_1;
            this.audioSource = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAudioFormat(int audioFormat) {
            void var1_1;
            this.audioFormat = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAudioTrackEventListener(AudioTrackEventListener listener) {
            void var1_1;
            this.audioTrackEventListener = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAudioTrackErrorCallback(AudioTrackErrorCallback audioTrackErrorCallback) {
            void var1_1;
            this.audioTrackErrorCallback = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAudioRecordEventListener(AudioRecordEventListener listener) {
            void var1_1;
            this.audioRecordEventListener = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAudioRecordErrorCallback(AudioRecordErrorCallback audioRecordErrorCallback) {
            void var1_1;
            this.audioRecordErrorCallback = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSamplesReadyCallback(SamplesReadyCallback samplesReadyCallback) {
            void var1_1;
            this.samplesReadyCallback = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUseHardwareNoiseSuppressor(boolean useHardwareNoiseSuppressor) {
            void var1_1;
            if (useHardwareNoiseSuppressor && !JavaAudioDeviceModule.isBuiltInNoiseSuppressorSupported()) {
                Logging.e(JavaAudioDeviceModule.TAG, "HW NS not supported");
                useHardwareNoiseSuppressor = false;
            }
            this.useHardwareNoiseSuppressor = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUseHardwareAcousticEchoCanceler(boolean useHardwareAcousticEchoCanceler) {
            void var1_1;
            if (useHardwareAcousticEchoCanceler && !JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported()) {
                Logging.e(JavaAudioDeviceModule.TAG, "HW AEC not supported");
                useHardwareAcousticEchoCanceler = false;
            }
            this.useHardwareAcousticEchoCanceler = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUseStereoInput(boolean useStereoInput) {
            void var1_1;
            this.useStereoInput = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUseCommunicationMode(boolean useCommunicationMode) {
            void var1_1;
            this.useCommunicationMode = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUseStereoOutput(boolean useStereoOutput) {
            void var1_1;
            this.useStereoOutput = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setUseLowLatencyOutput(boolean useLowLatencyOutput) {
            void var1_1;
            Logging.i(JavaAudioDeviceModule.TAG, "setUseLowLatencyOutput : ".concat(String.valueOf(useLowLatencyOutput)));
            this.useLowLatencyOutput = var1_1;
            return this;
        }

        public AudioDeviceModule createAudioDeviceModule() {
            Logging.d(JavaAudioDeviceModule.TAG, "createAudioDeviceModule");
            if (this.useHardwareNoiseSuppressor) {
                Logging.d(JavaAudioDeviceModule.TAG, "HW NS will be used.");
            } else {
                if (JavaAudioDeviceModule.isBuiltInNoiseSuppressorSupported()) {
                    Logging.d(JavaAudioDeviceModule.TAG, "Overriding default behavior; now using WebRTC NS!");
                }
                Logging.d(JavaAudioDeviceModule.TAG, "HW NS will not be used.");
            }
            if (this.useHardwareAcousticEchoCanceler) {
                Logging.d(JavaAudioDeviceModule.TAG, "HW AEC will be used.");
            } else {
                if (JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported()) {
                    Logging.d(JavaAudioDeviceModule.TAG, "Overriding default behavior; now using WebRTC AEC!");
                }
                Logging.d(JavaAudioDeviceModule.TAG, "HW AEC will not be used.");
            }
            WebRtcAudioRecord webRtcAudioRecord = new WebRtcAudioRecord(this.context, this.audioManager, this.audioSource, this.audioFormat, this.audioRecordErrorCallback, this.samplesReadyCallback, this.useHardwareAcousticEchoCanceler, this.useHardwareNoiseSuppressor);
            webRtcAudioRecord.setAudioRecordEventListener(this.audioRecordEventListener);
            WebRtcAudioTrack webRtcAudioTrack = null;
            WebRtcOpenSLESPlayer webRtcOpenSLESPlayer = null;
            if (!this.useLowLatencyOutput) {
                webRtcAudioTrack = new WebRtcAudioTrack(this.context, this.audioManager, this.useCommunicationMode, this.audioTrackErrorCallback);
                webRtcAudioTrack.setAudioTrackEventListener(this.audioTrackEventListener);
            } else {
                webRtcOpenSLESPlayer = new WebRtcOpenSLESPlayer(this.audioTrackErrorCallback);
                webRtcOpenSLESPlayer.setAudioTrackEventListener(this.audioTrackEventListener);
            }
            return new JavaAudioDeviceModule(this.context, this.audioManager, webRtcAudioRecord, webRtcAudioTrack, webRtcOpenSLESPlayer, this.inputSampleRate, this.outputSampleRate, this.useStereoInput, this.useStereoOutput);
        }
    }
}

