/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc.audio;

import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.UUID;
import org.qnwebrtc.Logging;
import org.qnwebrtc.audio.WebRtcAudioUtils;

class WebRtcAudioEffects {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioEffectsExternal";
    private static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    private static final UUID AOSP_NOISE_SUPPRESSOR = UUID.fromString("c06c8400-8e06-11e0-9cb6-0002a5d5c51b");
    @Nullable
    private static AudioEffect.Descriptor[] cachedEffects;
    @Nullable
    private AcousticEchoCanceler aec;
    @Nullable
    private NoiseSuppressor ns;
    private boolean shouldEnableAec;
    private boolean shouldEnableNs;

    public static boolean isAcousticEchoCancelerSupported() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_AEC, AOSP_ACOUSTIC_ECHO_CANCELER);
    }

    public static boolean isNoiseSuppressorSupported() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_NS, AOSP_NOISE_SUPPRESSOR);
    }

    public WebRtcAudioEffects() {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
    }

    /*
     * WARNING - void declaration
     */
    public boolean setAEC(boolean enable) {
        void var1_1;
        Logging.d(TAG, "setAEC(" + enable + ")");
        if (!WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            Logging.w(TAG, "Platform AEC is not supported");
            this.shouldEnableAec = false;
            return false;
        }
        if (this.aec != null && enable != this.shouldEnableAec) {
            Logging.e(TAG, "Platform AEC state can't be modified while recording");
            return false;
        }
        this.shouldEnableAec = var1_1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setNS(boolean enable) {
        void var1_1;
        Logging.d(TAG, "setNS(" + enable + ")");
        if (!WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            Logging.w(TAG, "Platform NS is not supported");
            this.shouldEnableNs = false;
            return false;
        }
        if (this.ns != null && enable != this.shouldEnableNs) {
            Logging.e(TAG, "Platform NS state can't be modified while recording");
            return false;
        }
        this.shouldEnableNs = var1_1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void enable(int audioSession) {
        boolean bl;
        boolean bl2;
        Logging.d(TAG, "enable(audioSession=" + audioSession + ")");
        WebRtcAudioEffects.assertTrue(this.aec == null);
        WebRtcAudioEffects.assertTrue(this.ns == null);
        if (WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            this.aec = AcousticEchoCanceler.create((int)audioSession);
            if (this.aec != null) {
                bl2 = this.aec.getEnabled();
                boolean bl3 = bl = this.shouldEnableAec && WebRtcAudioEffects.isAcousticEchoCancelerSupported();
                if (this.aec.setEnabled(bl) != 0) {
                    Logging.e(TAG, "Failed to set the AcousticEchoCanceler state");
                }
                Logging.d(TAG, "AcousticEchoCanceler: was " + (bl2 ? "enabled" : "disabled") + ", enable: " + bl + ", is now: " + (this.aec.getEnabled() ? "enabled" : "disabled"));
            } else {
                Logging.e(TAG, "Failed to create the AcousticEchoCanceler instance");
            }
        }
        if (WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            void var1_1;
            this.ns = NoiseSuppressor.create((int)var1_1);
            if (this.ns != null) {
                bl2 = this.ns.getEnabled();
                boolean bl4 = bl = this.shouldEnableNs && WebRtcAudioEffects.isNoiseSuppressorSupported();
                if (this.ns.setEnabled(bl) != 0) {
                    Logging.e(TAG, "Failed to set the NoiseSuppressor state");
                }
                Logging.d(TAG, "NoiseSuppressor: was " + (bl2 ? "enabled" : "disabled") + ", enable: " + bl + ", is now: " + (this.ns.getEnabled() ? "enabled" : "disabled"));
                return;
            }
            Logging.e(TAG, "Failed to create the NoiseSuppressor instance");
        }
    }

    public void release() {
        Logging.d(TAG, "release");
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        if (this.ns != null) {
            this.ns.release();
            this.ns = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean effectTypeIsVoIP(UUID type) {
        void var1_1;
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return AudioEffect.EFFECT_TYPE_AEC.equals(type) && WebRtcAudioEffects.isAcousticEchoCancelerSupported() || AudioEffect.EFFECT_TYPE_NS.equals(var1_1) && WebRtcAudioEffects.isNoiseSuppressorSupported();
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    @Nullable
    private static AudioEffect.Descriptor[] getAvailableEffects() {
        if (cachedEffects != null) {
            return cachedEffects;
        }
        cachedEffects = AudioEffect.queryEffects();
        return cachedEffects;
    }

    private static boolean isEffectTypeAvailable(UUID effectType, UUID blackListedUuid) {
        AudioEffect.Descriptor[] descriptorArray = WebRtcAudioEffects.getAvailableEffects();
        if (descriptorArray == null) {
            return false;
        }
        for (AudioEffect.Descriptor descriptor : descriptorArray) {
            if (!descriptor.type.equals(effectType)) continue;
            return !descriptor.uuid.equals(blackListedUuid);
        }
        return false;
    }
}

