/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.Logging;
import org.qnwebrtc.audio.WebRtcAudioUtils;

class WebRtcAudioManager {
    private static final String TAG = "WebRtcAudioManagerExternal";
    private static final int DEFAULT_SAMPLE_RATE_HZ = 16000;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int DEFAULT_FRAME_PER_BUFFER = 256;

    WebRtcAudioManager() {
    }

    @CalledByNative
    static AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    static int getOutputBufferSize(Context context, AudioManager audioManager, int sampleRate, int numberOfOutputChannels) {
        void var3_3;
        void var2_2;
        if (WebRtcAudioManager.isLowLatencyOutputSupported(context)) {
            void var1_1;
            return WebRtcAudioManager.getLowLatencyFramesPerBuffer((AudioManager)var1_1);
        }
        return WebRtcAudioManager.getMinOutputFrameSize((int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    static int getInputBufferSize(Context context, AudioManager audioManager, int sampleRate, int numberOfInputChannels) {
        void var3_3;
        void var2_2;
        if (WebRtcAudioManager.isLowLatencyInputSupported(context)) {
            void var1_1;
            return WebRtcAudioManager.getLowLatencyFramesPerBuffer((AudioManager)var1_1);
        }
        return WebRtcAudioManager.getMinInputFrameSize((int)var2_2, (int)var3_3);
    }

    private static boolean isLowLatencyOutputSupported(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    private static boolean isLowLatencyInputSupported(Context context) {
        Context context2;
        return Build.VERSION.SDK_INT >= 21 && WebRtcAudioManager.isLowLatencyOutputSupported(context2);
    }

    @CalledByNative
    static int getSampleRate(AudioManager audioManager) {
        AudioManager audioManager2;
        if (WebRtcAudioUtils.runningOnEmulator()) {
            Logging.d(TAG, "Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        int n = WebRtcAudioManager.getSampleRateForApiLevel(audioManager2);
        Logging.d(TAG, "Sample rate is set to " + n + " Hz");
        return n;
    }

    private static int getSampleRateForApiLevel(AudioManager audioManager) {
        Object object;
        if (Build.VERSION.SDK_INT < 17) {
            return 16000;
        }
        if ((object = object.getProperty("android.media.property.OUTPUT_SAMPLE_RATE")) == null) {
            return 16000;
        }
        return Integer.parseInt((String)object);
    }

    private static int getLowLatencyFramesPerBuffer(AudioManager audioManager) {
        Object object;
        if (Build.VERSION.SDK_INT < 17) {
            return 256;
        }
        if ((object = object.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER")) == null) {
            return 256;
        }
        return Integer.parseInt((String)object);
    }

    private static int getMinOutputFrameSize(int sampleRateInHz, int numChannels) {
        int n;
        int n2;
        int n3 = numChannels * 2;
        n2 = n2 == 1 ? 4 : 12;
        return AudioTrack.getMinBufferSize((int)n, (int)n2, (int)2) / n3;
    }

    private static int getMinInputFrameSize(int sampleRateInHz, int numChannels) {
        int n;
        int n2;
        int n3 = numChannels * 2;
        n2 = n2 == 1 ? 16 : 12;
        return AudioRecord.getMinBufferSize((int)n, (int)n2, (int)2) / n3;
    }
}

