/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc.audio;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.Logging;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.audio.JavaAudioDeviceModule;
import org.qnwebrtc.audio.VolumeLogger;
import org.qnwebrtc.audio.WebRtcAudioUtils;

class WebRtcAudioTrack {
    private static final String TAG = "WebRtcAudioTrackExternal";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final long AUDIO_TRACK_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_USAGE = WebRtcAudioTrack.getDefaultUsageAttribute();
    private long nativeAudioTrack;
    private final Context context;
    private final AudioManager audioManager;
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioTrack audioTrack;
    @Nullable
    private AudioTrackThread audioThread;
    private final VolumeLogger volumeLogger;
    private volatile boolean speakerMute;
    private byte[] emptyBytes;
    @Nullable
    private final JavaAudioDeviceModule.AudioTrackErrorCallback errorCallback;
    private volatile boolean useCommunicationMode = true;
    private int playSampleRate;
    private int playChannels;
    @Nullable
    private JavaAudioDeviceModule.AudioTrackEventListener trackEventListener;
    @Nullable
    private JavaAudioDeviceModule.AudioDataCallback trackPlayDataCallback;

    private static int getDefaultUsageAttribute() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    WebRtcAudioTrack(Context context, AudioManager audioManager) {
        this((Context)var1_1, (AudioManager)var2_2, true, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    WebRtcAudioTrack(Context context, AudioManager audioManager, @Nullable JavaAudioDeviceModule.AudioTrackErrorCallback errorCallback) {
        this((Context)var1_1, (AudioManager)var2_2, true, (JavaAudioDeviceModule.AudioTrackErrorCallback)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    WebRtcAudioTrack(Context context, AudioManager audioManager, boolean useCommunicationMode, @Nullable JavaAudioDeviceModule.AudioTrackErrorCallback errorCallback) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.threadChecker.detachThread();
        this.context = var1_1;
        this.audioManager = audioManager;
        this.useCommunicationMode = var3_3;
        this.errorCallback = errorCallback;
        this.volumeLogger = new VolumeLogger((AudioManager)var2_2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setUseCommunicationMode(boolean useCommunicationMode) {
        WebRtcAudioTrack webRtcAudioTrack = this;
        synchronized (webRtcAudioTrack) {
            void var1_1;
            if (this.useCommunicationMode == useCommunicationMode) {
                Logging.d(TAG, "Communication mode is already " + (useCommunicationMode ? "on" : "off"));
                return;
            }
            this.useCommunicationMode = var1_1;
            if (this.audioTrack == null && this.audioThread == null) {
                Logging.w(TAG, "AudioTrack is not initialized!");
                return;
            }
            if (this.audioThread != null) {
                this.stopPlayoutInternal();
                WebRtcAudioTrack webRtcAudioTrack2 = this;
                webRtcAudioTrack2.initPlayoutInternal(webRtcAudioTrack2.playSampleRate, this.playChannels);
                this.startPlayoutInternal();
            } else {
                this.releaseAudioResources();
                WebRtcAudioTrack webRtcAudioTrack3 = this;
                webRtcAudioTrack3.initPlayoutInternal(webRtcAudioTrack3.playSampleRate, this.playChannels);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAudioTrackEventListener(JavaAudioDeviceModule.AudioTrackEventListener listener) {
        void var1_1;
        Logging.d(TAG, "Set audio track event listener: ".concat(String.valueOf(listener)));
        this.trackEventListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setPlayDataCallback(JavaAudioDeviceModule.AudioDataCallback callback) {
        void var1_1;
        Logging.d(TAG, "Set play data callback: ".concat(String.valueOf(callback)));
        this.trackPlayDataCallback = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    public void setNativeAudioTrack(long nativeAudioTrack) {
        void var1_1;
        this.nativeAudioTrack = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @CalledByNative
    private boolean initPlayout(int sampleRate, int channels) {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "initPlayout(sampleRate=" + sampleRate + ", channels=" + channels + ")");
        int n = channels * 2;
        this.byteBuffer = ByteBuffer.allocateDirect(n * (sampleRate / 100));
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.playSampleRate = sampleRate;
        this.playChannels = channels;
        WebRtcAudioTrack.nativeCacheDirectBufferAddress(this.nativeAudioTrack, this.byteBuffer);
        WebRtcAudioTrack webRtcAudioTrack = this;
        synchronized (webRtcAudioTrack) {
            void var2_3;
            void var1_1;
            if (!this.initPlayoutInternal((int)var1_1, (int)var2_3)) {
                return false;
            }
        }
        if (this.trackEventListener != null) {
            this.trackEventListener.onWebRtcAudioTrackInitDone();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean startPlayout() {
        this.threadChecker.checkIsOnValidThread();
        this.volumeLogger.start();
        Logging.d(TAG, "startPlayout");
        WebRtcAudioTrack webRtcAudioTrack = this;
        synchronized (webRtcAudioTrack) {
            return this.startPlayoutInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean stopPlayout() {
        this.threadChecker.checkIsOnValidThread();
        this.volumeLogger.stop();
        Logging.d(TAG, "stopPlayout");
        WebRtcAudioTrack webRtcAudioTrack = this;
        synchronized (webRtcAudioTrack) {
            this.stopPlayoutInternal();
        }
        if (this.trackEventListener != null) {
            this.trackEventListener.onWebRtcAudioTrackReleased();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean initPlayoutInternal(int sampleRate, int channels) {
        int n;
        Logging.d(TAG, "initPlayoutInternal sampleRate = " + sampleRate + " channels = " + channels);
        n = this.channelCountToConfiguration(n);
        int n2 = AudioTrack.getMinBufferSize((int)sampleRate, (int)n, (int)2);
        Logging.d(TAG, "AudioTrack.getMinBufferSize: ".concat(String.valueOf(n2)));
        if (n2 < this.byteBuffer.capacity()) {
            this.reportWebRtcAudioTrackInitError("AudioTrack.getMinBufferSize returns an invalid value.");
            return false;
        }
        if (this.audioTrack != null) {
            this.reportWebRtcAudioTrackInitError("Conflict with existing AudioTrack.");
            return false;
        }
        try {
            void var1_1;
            this.audioTrack = Build.VERSION.SDK_INT >= 21 ? WebRtcAudioTrack.createAudioTrackOnLollipopOrHigher(sampleRate, n, n2, this.useCommunicationMode) : WebRtcAudioTrack.createAudioTrackOnLowerThanLollipop((int)var1_1, n, n2, this.useCommunicationMode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.reportWebRtcAudioTrackInitError(illegalArgumentException.getMessage());
            this.releaseAudioResources();
            return false;
        }
        if (this.audioTrack == null || this.audioTrack.getState() != 1) {
            this.reportWebRtcAudioTrackInitError("Initialization of audio track failed.");
            this.releaseAudioResources();
            return false;
        }
        this.logMainParameters();
        this.logMainParametersExtended();
        return true;
    }

    private boolean startPlayoutInternal() {
        Logging.d(TAG, "startPlayoutInternal");
        if (this.audioTrack == null) {
            Logging.w(TAG, "AudioTrack is not initialized");
            return false;
        }
        if (this.audioThread != null) {
            Logging.w(TAG, "AudioTrack is already started");
            return true;
        }
        try {
            this.audioTrack.play();
        }
        catch (IllegalStateException illegalStateException) {
            this.reportWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode.AUDIO_TRACK_START_EXCEPTION, "AudioTrack.play failed: " + illegalStateException.getMessage());
            this.releaseAudioResources();
            return false;
        }
        if (this.audioTrack.getPlayState() != 3) {
            this.reportWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode.AUDIO_TRACK_START_STATE_MISMATCH, "AudioTrack.play failed - incorrect state :" + this.audioTrack.getPlayState());
            this.releaseAudioResources();
            return false;
        }
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    private void stopPlayoutInternal() {
        Logging.d(TAG, "stopPlayoutInternal");
        if (this.audioThread == null) {
            Logging.w(TAG, "AudioTrack is already stopped");
            return;
        }
        this.logUnderrunCount();
        this.audioThread.stopThread();
        Logging.d(TAG, "Stopping the AudioTrackThread...");
        this.audioThread.interrupt();
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioTrackThread timed out.");
            WebRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        }
        Logging.d(TAG, "AudioTrackThread has now been stopped.");
        this.audioThread = null;
        this.releaseAudioResources();
    }

    @CalledByNative
    private int getStreamMaxVolume() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamMaxVolume");
        return this.audioManager.getStreamMaxVolume(0);
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    private boolean setStreamVolume(int volume) {
        void var1_1;
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "setStreamVolume(" + volume + ")");
        if (this.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, (int)var1_1, 0);
        return true;
    }

    private boolean isVolumeFixed() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    @CalledByNative
    private int getStreamVolume() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamVolume");
        return this.audioManager.getStreamVolume(0);
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioTrack: session ID: " + this.audioTrack.getAudioSessionId() + ", channels: " + this.audioTrack.getChannelCount() + ", sample rate: " + this.audioTrack.getSampleRate() + ", stream type: " + this.audioTrack.getStreamType() + ", max gain: " + AudioTrack.getMaxVolume());
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=21)
    private static AudioTrack createAudioTrackOnLollipopOrHigher(int sampleRateInHz, int channelConfig, int bufferSizeInBytes, boolean useCommunicationMode) {
        void var2_2;
        void var1_1;
        int n;
        void var3_3;
        Logging.d(TAG, "createAudioTrackOnLollipopOrHigher");
        int n2 = AudioTrack.getNativeOutputSampleRate((int)0);
        Logging.d(TAG, "nativeOutputSampleRate: ".concat(String.valueOf(n2)));
        if (sampleRateInHz != n2) {
            Logging.w(TAG, "Unable to use fast mode since requested sample rate is not native");
        }
        return new AudioTrack(new AudioAttributes.Builder().setUsage(useCommunicationMode ? DEFAULT_USAGE : 1).setContentType(var3_3 != false ? 1 : 2).build(), new AudioFormat.Builder().setEncoding(2).setSampleRate(n).setChannelMask((int)var1_1).build(), (int)var2_2, 1, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static AudioTrack createAudioTrackOnLowerThanLollipop(int sampleRateInHz, int channelConfig, int bufferSizeInBytes, boolean useCommunicationMode) {
        void var2_2;
        void var1_1;
        int n;
        void var3_3;
        return new AudioTrack(var3_3 != false ? 0 : 3, n, (int)var1_1, 2, (int)var2_2, 1);
    }

    private void logBufferSizeInFrames() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioTrack: buffer size in frames: " + this.audioTrack.getBufferSizeInFrames());
        }
    }

    private void logBufferCapacityInFrames() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, "AudioTrack: buffer capacity in frames: " + this.audioTrack.getBufferCapacityInFrames());
        }
    }

    private void logMainParametersExtended() {
        this.logBufferSizeInFrames();
        this.logBufferCapacityInFrames();
    }

    private void logUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, "underrun count: " + this.audioTrack.getUnderrunCount());
        }
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        if (channels == 1) {
            return 4;
        }
        return 12;
    }

    private static native void nativeCacheDirectBufferAddress(long var0, ByteBuffer var2);

    private static native void nativeGetPlayoutData(long var0, int var2);

    /*
     * WARNING - void declaration
     */
    public void setSpeakerMute(boolean mute) {
        void var1_1;
        Logging.w(TAG, "setSpeakerMute(" + mute + ")");
        this.speakerMute = var1_1;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportWebRtcAudioTrackInitError(String errorMessage) {
        Logging.e(TAG, "Init playout error: ".concat(String.valueOf(errorMessage)));
        WebRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        if (this.errorCallback != null) {
            void var1_1;
            this.errorCallback.onWebRtcAudioTrackInitError((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, String errorMessage) {
        Logging.e(TAG, "Start playout error: " + (Object)((Object)errorCode) + ". " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        if (this.errorCallback != null) {
            void var2_2;
            void var1_1;
            this.errorCallback.onWebRtcAudioTrackStartError((JavaAudioDeviceModule.AudioTrackStartErrorCode)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportWebRtcAudioTrackError(String errorMessage) {
        Logging.e(TAG, "Run-time playback error: ".concat(String.valueOf(errorMessage)));
        WebRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        if (this.errorCallback != null) {
            void var1_1;
            this.errorCallback.onWebRtcAudioTrackError((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(long x0, int x1) {
        void var2_1;
        WebRtcAudioTrack.nativeGetPlayoutData(x0, (int)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1000(WebRtcAudioTrack x0, String x1) {
        void var1_1;
        x0.reportWebRtcAudioTrackError((String)var1_1);
    }

    class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        /*
         * WARNING - void declaration
         */
        public AudioTrackThread(String name) {
            void var2_2;
            super((String)var2_2);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioTrack.TAG, "AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            int n = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                WebRtcAudioTrack.access$400(WebRtcAudioTrack.this.nativeAudioTrack, n);
                WebRtcAudioTrack.assertTrue(n <= WebRtcAudioTrack.this.byteBuffer.remaining());
                if (WebRtcAudioTrack.this.trackPlayDataCallback != null) {
                    WebRtcAudioTrack.this.trackPlayDataCallback.onAudioDataAvailable(WebRtcAudioTrack.this.byteBuffer, n, 16, WebRtcAudioTrack.this.playSampleRate, WebRtcAudioTrack.this.playChannels, System.nanoTime());
                }
                if (WebRtcAudioTrack.this.speakerMute) {
                    WebRtcAudioTrack.this.byteBuffer.clear();
                    WebRtcAudioTrack.this.byteBuffer.put(WebRtcAudioTrack.this.emptyBytes);
                    WebRtcAudioTrack.this.byteBuffer.position(0);
                }
                AudioTrackThread audioTrackThread = this;
                int n2 = audioTrackThread.writeBytes(audioTrackThread.WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, n);
                if (n2 != n) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.write played invalid number of bytes: ".concat(String.valueOf(n2)));
                    if (n2 < 0) {
                        this.keepAlive = false;
                        WebRtcAudioTrack.access$1000(WebRtcAudioTrack.this, "AudioTrack.write failed: ".concat(String.valueOf(n2)));
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            if (WebRtcAudioTrack.this.audioTrack != null) {
                Logging.d(WebRtcAudioTrack.TAG, "Calling AudioTrack.stop...");
                try {
                    WebRtcAudioTrack.this.audioTrack.stop();
                    Logging.d(WebRtcAudioTrack.TAG, "AudioTrack.stop is done.");
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.stop failed: " + illegalStateException.getMessage());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private int writeBytes(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (Build.VERSION.SDK_INT >= 21) {
                return audioTrack.write(byteBuffer, sizeInBytes, 0);
            }
            return var1_1.write(byteBuffer.array(), var2_2.arrayOffset(), (int)var3_3);
        }

        public void stopThread() {
            Logging.d(WebRtcAudioTrack.TAG, "stopThread");
            this.keepAlive = false;
        }
    }
}

