/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc.audio;

import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import java.util.Arrays;
import org.qnwebrtc.Logging;

final class WebRtcAudioUtils {
    private static final String TAG = "WebRtcAudioUtilsExternal";

    WebRtcAudioUtils() {
    }

    public static String getThreadInfo() {
        return "@[name=" + Thread.currentThread().getName() + ", id=" + Thread.currentThread().getId() + "]";
    }

    public static boolean runningOnEmulator() {
        return Build.HARDWARE.equals("goldfish") && Build.BRAND.startsWith("generic_");
    }

    static void logDeviceInfo(String tag) {
        Logging.d(tag, "Android SDK: " + Build.VERSION.SDK_INT + ", Release: " + Build.VERSION.RELEASE + ", Brand: " + Build.BRAND + ", Device: " + Build.DEVICE + ", Id: " + Build.ID + ", Hardware: " + Build.HARDWARE + ", Manufacturer: " + Build.MANUFACTURER + ", Model: " + Build.MODEL + ", Product: " + Build.PRODUCT);
    }

    /*
     * WARNING - void declaration
     */
    static void logAudioState(String tag, Context context, AudioManager audioManager) {
        void var2_2;
        String string;
        void var1_1;
        WebRtcAudioUtils.logDeviceInfo(tag);
        WebRtcAudioUtils.logAudioStateBasic(tag, (Context)var1_1, audioManager);
        WebRtcAudioUtils.logAudioStateVolume(tag, audioManager);
        WebRtcAudioUtils.logAudioDeviceInfo(string, (AudioManager)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void logAudioStateBasic(String tag, Context context, AudioManager audioManager) {
        void var2_2;
        void var1_1;
        Logging.d(tag, "Audio State: audio mode: " + WebRtcAudioUtils.modeToString(audioManager.getMode()) + ", has mic: " + WebRtcAudioUtils.hasMicrophone((Context)var1_1) + ", mic muted: " + audioManager.isMicrophoneMute() + ", music active: " + audioManager.isMusicActive() + ", speakerphone: " + audioManager.isSpeakerphoneOn() + ", BT SCO: " + var2_2.isBluetoothScoOn());
    }

    private static boolean isVolumeFixed(AudioManager audioManager) {
        AudioManager audioManager2;
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return audioManager2.isVolumeFixed();
    }

    private static void logAudioStateVolume(String tag, AudioManager audioManager) {
        int[] nArray = new int[]{0, 3, 2, 4, 5, 1};
        Logging.d(tag, "Audio State: ");
        int n = WebRtcAudioUtils.isVolumeFixed(audioManager);
        Logging.d(tag, "  fixed volume=".concat(String.valueOf(n != 0)));
        if (n == 0) {
            for (n = 0; n < 6; ++n) {
                int n2 = nArray[n];
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("  " + WebRtcAudioUtils.streamTypeToString(n2) + ": ");
                stringBuilder.append("volume=").append(audioManager.getStreamVolume(n2));
                stringBuilder.append(", max=").append(audioManager.getStreamMaxVolume(n2));
                WebRtcAudioUtils.logIsStreamMute(tag, audioManager, n2, stringBuilder);
                Logging.d(tag, stringBuilder.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void logIsStreamMute(String tag, AudioManager audioManager, int stream, StringBuilder info) {
        if (Build.VERSION.SDK_INT >= 23) {
            void var2_2;
            void var1_1;
            void var3_3;
            var3_3.append(", muted=").append(var1_1.isStreamMute((int)var2_2));
        }
    }

    private static void logAudioDeviceInfo(String tag, AudioManager audioManager) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if ((audioDeviceInfoArray = audioDeviceInfoArray.getDevices(3)).length == 0) {
            return;
        }
        Logging.d(tag, "Audio Devices: ");
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  ").append(WebRtcAudioUtils.deviceTypeToString(audioDeviceInfo.getType()));
            stringBuilder.append(audioDeviceInfo.isSource() ? "(in): " : "(out): ");
            if (audioDeviceInfo.getChannelCounts().length > 0) {
                stringBuilder.append("channels=").append(Arrays.toString(audioDeviceInfo.getChannelCounts()));
                stringBuilder.append(", ");
            }
            if (audioDeviceInfo.getEncodings().length > 0) {
                stringBuilder.append("encodings=").append(Arrays.toString(audioDeviceInfo.getEncodings()));
                stringBuilder.append(", ");
            }
            if (audioDeviceInfo.getSampleRates().length > 0) {
                stringBuilder.append("sample rates=").append(Arrays.toString(audioDeviceInfo.getSampleRates()));
                stringBuilder.append(", ");
            }
            stringBuilder.append("id=").append(audioDeviceInfo.getId());
            Logging.d(tag, stringBuilder.toString());
        }
    }

    static String modeToString(int mode) {
        switch (mode) {
            case 2: {
                return "MODE_IN_CALL";
            }
            case 3: {
                return "MODE_IN_COMMUNICATION";
            }
            case 0: {
                return "MODE_NORMAL";
            }
            case 1: {
                return "MODE_RINGTONE";
            }
        }
        return "MODE_INVALID";
    }

    private static String streamTypeToString(int stream) {
        switch (stream) {
            case 0: {
                return "STREAM_VOICE_CALL";
            }
            case 3: {
                return "STREAM_MUSIC";
            }
            case 2: {
                return "STREAM_RING";
            }
            case 4: {
                return "STREAM_ALARM";
            }
            case 5: {
                return "STREAM_NOTIFICATION";
            }
            case 1: {
                return "STREAM_SYSTEM";
            }
        }
        return "STREAM_INVALID";
    }

    private static String deviceTypeToString(int type) {
        switch (type) {
            case 0: {
                return "TYPE_UNKNOWN";
            }
            case 1: {
                return "TYPE_BUILTIN_EARPIECE";
            }
            case 2: {
                return "TYPE_BUILTIN_SPEAKER";
            }
            case 3: {
                return "TYPE_WIRED_HEADSET";
            }
            case 4: {
                return "TYPE_WIRED_HEADPHONES";
            }
            case 5: {
                return "TYPE_LINE_ANALOG";
            }
            case 6: {
                return "TYPE_LINE_DIGITAL";
            }
            case 7: {
                return "TYPE_BLUETOOTH_SCO";
            }
            case 8: {
                return "TYPE_BLUETOOTH_A2DP";
            }
            case 9: {
                return "TYPE_HDMI";
            }
            case 10: {
                return "TYPE_HDMI_ARC";
            }
            case 11: {
                return "TYPE_USB_DEVICE";
            }
            case 12: {
                return "TYPE_USB_ACCESSORY";
            }
            case 13: {
                return "TYPE_DOCK";
            }
            case 14: {
                return "TYPE_FM";
            }
            case 15: {
                return "TYPE_BUILTIN_MIC";
            }
            case 16: {
                return "TYPE_FM_TUNER";
            }
            case 17: {
                return "TYPE_TV_TUNER";
            }
            case 18: {
                return "TYPE_TELEPHONY";
            }
            case 19: {
                return "TYPE_AUX_LINE";
            }
            case 20: {
                return "TYPE_IP";
            }
            case 21: {
                return "TYPE_BUS";
            }
            case 22: {
                return "TYPE_USB_HEADSET";
            }
        }
        return "TYPE_UNKNOWN";
    }

    private static boolean hasMicrophone(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.microphone");
    }
}

