/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc.audio;

import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.Logging;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.audio.JavaAudioDeviceModule;

class WebRtcOpenSLESPlayer {
    private static final String TAG = "WebRtcOpenSLESPlayer";
    private long nativeOpenSLESPlayer;
    @Nullable
    private JavaAudioDeviceModule.AudioTrackEventListener trackEventListener;
    @Nullable
    private JavaAudioDeviceModule.AudioDataCallback trackPlayDataCallback;
    @Nullable
    private final JavaAudioDeviceModule.AudioTrackErrorCallback errorCallback;
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();

    /*
     * WARNING - void declaration
     */
    public WebRtcOpenSLESPlayer(JavaAudioDeviceModule.AudioTrackErrorCallback errorCallback) {
        void var1_1;
        this.errorCallback = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAudioTrackEventListener(JavaAudioDeviceModule.AudioTrackEventListener listener) {
        void var1_1;
        Logging.d(TAG, "Set audio track event listener: ".concat(String.valueOf(listener)));
        this.trackEventListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setPlayDataCallback(JavaAudioDeviceModule.AudioDataCallback callback) {
        void var1_1;
        Logging.d(TAG, "Set play data callback: ".concat(String.valueOf(callback)));
        this.trackPlayDataCallback = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    public void setNativeOpenSLESPlayer(long nativeOpenSLESPlayer) {
        void var1_1;
        Logging.d(TAG, "setNativeOpenSLESPlayer : ".concat(String.valueOf(nativeOpenSLESPlayer)));
        this.nativeOpenSLESPlayer = var1_1;
    }

    @CalledByNative
    private boolean initPlayout() {
        Logging.d(TAG, "initPlayout");
        if (this.trackEventListener != null) {
            this.trackEventListener.onWebRtcAudioTrackInitDone();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    private void initPlayoutFailed(String errorMessage) {
        Logging.e(TAG, "initPlayoutFailed : ".concat(String.valueOf(errorMessage)));
        if (this.errorCallback != null) {
            void var1_1;
            this.errorCallback.onWebRtcAudioTrackInitError((String)var1_1);
        }
    }

    @CalledByNative
    private boolean stopPlayout() {
        Logging.d(TAG, "stopPlayout");
        if (this.trackEventListener != null) {
            this.trackEventListener.onWebRtcAudioTrackReleased();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    private void OnPlayoutDataGot(ByteBuffer srcBuffer, int size, int bitsPerSample, int sampleRate, int channels) {
        if (this.trackPlayDataCallback != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.trackPlayDataCallback.onAudioDataAvailable((ByteBuffer)var1_1, (int)var2_2, (int)var3_3, sampleRate, channels, System.nanoTime());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSpeakerMute(boolean mute) {
        void var1_1;
        Logging.i(TAG, "setSpeakerMute(" + mute + ")");
        WebRtcOpenSLESPlayer.nativeSetSpeakerMute(this.nativeOpenSLESPlayer, (boolean)var1_1);
    }

    private static native void nativeSetSpeakerMute(long var0, boolean var2);
}

