/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc.voiceengine;

import android.media.AudioRecord;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.qnwebrtc.Logging;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.voiceengine.WebRtcAudioEffects;
import org.qnwebrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_AUDIO_SOURCE;
    private static int audioSource;
    private final long nativeAudioRecord;
    @Nullable
    private WebRtcAudioEffects effects;
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private AudioRecordThread audioThread;
    private static volatile boolean microphoneMute;
    private byte[] emptyBytes;
    @Nullable
    private static WebRtcAudioRecordErrorCallback errorCallback;
    @Nullable
    private static WebRtcAudioRecordSamplesReadyCallback audioSamplesReadyCallback;

    public static void setErrorCallback(WebRtcAudioRecordErrorCallback errorCallback) {
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback;
        Logging.d(TAG, "Set error callback");
        WebRtcAudioRecord.errorCallback = webRtcAudioRecordErrorCallback;
    }

    public static void setOnAudioSamplesReady(WebRtcAudioRecordSamplesReadyCallback callback) {
        audioSamplesReadyCallback = callback;
    }

    /*
     * WARNING - void declaration
     */
    WebRtcAudioRecord(long nativeAudioRecord) {
        void var1_1;
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.nativeAudioRecord = var1_1;
        this.effects = WebRtcAudioEffects.create();
    }

    /*
     * WARNING - void declaration
     */
    private boolean enableBuiltInAEC(boolean enable) {
        void var1_1;
        Logging.d(TAG, "enableBuiltInAEC(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in AEC is not supported on this platform");
            return false;
        }
        return this.effects.setAEC((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean enableBuiltInNS(boolean enable) {
        void var1_1;
        Logging.d(TAG, "enableBuiltInNS(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in NS is not supported on this platform");
            return false;
        }
        return this.effects.setNS((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int initRecording(int sampleRate, int channels) {
        int n;
        Logging.d(TAG, "initRecording(sampleRate=" + sampleRate + ", channels=" + channels + ")");
        if (this.audioRecord != null) {
            this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        int n2 = channels * 2;
        int n3 = sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(n2 * n3);
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        WebRtcAudioRecord webRtcAudioRecord = this;
        webRtcAudioRecord.nativeCacheDirectBufferAddress(webRtcAudioRecord.byteBuffer, this.nativeAudioRecord);
        n = this.channelCountToConfiguration(n);
        n2 = AudioRecord.getMinBufferSize((int)sampleRate, (int)n, (int)2);
        if (n2 == -1 || n2 == -2) {
            this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: ".concat(String.valueOf(n2)));
            return -1;
        }
        Logging.d(TAG, "AudioRecord.getMinBufferSize: ".concat(String.valueOf(n2)));
        n2 = Math.max(2 * n2, this.byteBuffer.capacity());
        Logging.d(TAG, "bufferSizeInBytes: ".concat(String.valueOf(n2)));
        try {
            void var1_1;
            this.audioRecord = new AudioRecord(audioSource, (int)var1_1, n, 2, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.reportWebRtcAudioRecordInitError("AudioRecord ctor error: " + illegalArgumentException.getMessage());
            this.releaseAudioResources();
            return -1;
        }
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            this.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance");
            this.releaseAudioResources();
            return -1;
        }
        if (this.effects != null) {
            this.effects.enable(this.audioRecord.getAudioSessionId());
        }
        this.logMainParameters();
        this.logMainParametersExtended();
        return n3;
    }

    private boolean startRecording() {
        Logging.d(TAG, "startRecording");
        WebRtcAudioRecord.assertTrue(this.audioRecord != null);
        WebRtcAudioRecord.assertTrue(this.audioThread == null);
        try {
            this.audioRecord.startRecording();
        }
        catch (IllegalStateException illegalStateException) {
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + illegalStateException.getMessage());
            return false;
        }
        if (this.audioRecord.getRecordingState() != 3) {
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state :" + this.audioRecord.getRecordingState());
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        WebRtcAudioRecord.assertTrue(this.audioThread != null);
        this.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioRecordJavaThread timed out");
            WebRtcAudioUtils.logAudioState(TAG);
        }
        this.audioThread = null;
        if (this.effects != null) {
            this.effects.release();
        }
        this.releaseAudioResources();
        return true;
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioRecord: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
    }

    private void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames());
        }
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        if (channels == 1) {
            return 16;
        }
        return 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    public static synchronized void setAudioSource(int source) {
        int n;
        Logging.w(TAG, "Audio source is changed from: " + audioSource + " to " + source);
        audioSource = n;
    }

    private static int getDefaultAudioSource() {
        return 7;
    }

    public static void setMicrophoneMute(boolean mute) {
        boolean bl;
        Logging.w(TAG, "setMicrophoneMute(" + mute + ")");
        microphoneMute = bl;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        if (this.audioRecord != null) {
            this.audioRecord.release();
            this.audioRecord = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportWebRtcAudioRecordInitError(String errorMessage) {
        Logging.e(TAG, "Init recording error: ".concat(String.valueOf(errorMessage)));
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallback != null) {
            void var1_1;
            errorCallback.onWebRtcAudioRecordInitError((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode errorCode, String errorMessage) {
        Logging.e(TAG, "Start recording error: " + (Object)((Object)errorCode) + ". " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallback != null) {
            void var2_2;
            void var1_1;
            errorCallback.onWebRtcAudioRecordStartError((AudioRecordStartErrorCode)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportWebRtcAudioRecordError(String errorMessage) {
        Logging.e(TAG, "Run-time recording error: ".concat(String.valueOf(errorMessage)));
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallback != null) {
            void var1_1;
            errorCallback.onWebRtcAudioRecordError((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(WebRtcAudioRecord x0, int x1, long x2) {
        void var2_2;
        void var1_1;
        x0.nativeDataIsRecorded((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$900(WebRtcAudioRecord x0, String x1) {
        void var1_1;
        x0.reportWebRtcAudioRecordError((String)var1_1);
    }

    static {
        audioSource = DEFAULT_AUDIO_SOURCE = WebRtcAudioRecord.getDefaultAudioSource();
    }

    class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        /*
         * WARNING - void declaration
         */
        public AudioRecordThread(String name) {
            void var2_2;
            super((String)var2_2);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
            System.nanoTime();
            while (this.keepAlive) {
                Object object;
                int n = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                if (n == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    if (microphoneMute) {
                        WebRtcAudioRecord.this.byteBuffer.clear();
                        WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                    }
                    if (this.keepAlive) {
                        WebRtcAudioRecord webRtcAudioRecord = WebRtcAudioRecord.this;
                        WebRtcAudioRecord.access$600(webRtcAudioRecord, n, webRtcAudioRecord.nativeAudioRecord);
                    }
                    if (audioSamplesReadyCallback == null) continue;
                    object = Arrays.copyOf(WebRtcAudioRecord.this.byteBuffer.array(), WebRtcAudioRecord.this.byteBuffer.capacity());
                    audioSamplesReadyCallback.onWebRtcAudioRecordSamplesReady(new AudioSamples(WebRtcAudioRecord.this.audioRecord, (byte[])object));
                    continue;
                }
                object = "AudioRecord.read failed: ".concat(String.valueOf(n));
                Logging.e(WebRtcAudioRecord.TAG, (String)object);
                if (n != -3) continue;
                this.keepAlive = false;
                WebRtcAudioRecord.access$900(WebRtcAudioRecord.this, (String)object);
            }
            try {
                if (WebRtcAudioRecord.this.audioRecord != null) {
                    WebRtcAudioRecord.this.audioRecord.stop();
                }
                return;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.stop failed: " + illegalStateException.getMessage());
                return;
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioRecord.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface WebRtcAudioRecordSamplesReadyCallback {
        public void onWebRtcAudioRecordSamplesReady(AudioSamples var1);
    }

    public static class AudioSamples {
        private final int audioFormat;
        private final int channelCount;
        private final int sampleRate;
        private final byte[] data;

        /*
         * WARNING - void declaration
         */
        private AudioSamples(AudioRecord audioRecord, byte[] data) {
            void var2_2;
            void var1_1;
            this.audioFormat = audioRecord.getAudioFormat();
            this.channelCount = audioRecord.getChannelCount();
            this.sampleRate = var1_1.getSampleRate();
            this.data = var2_2;
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static interface WebRtcAudioRecordErrorCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);
    }

    public static enum AudioRecordStartErrorCode {
        AUDIO_RECORD_START_EXCEPTION,
        AUDIO_RECORD_START_STATE_MISMATCH;

    }
}

