/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc.voiceengine;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.qnwebrtc.ContextUtils;
import org.qnwebrtc.Logging;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioTrack {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioTrack";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final long AUDIO_TRACK_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_USAGE;
    private static int usageAttribute;
    private final long nativeAudioTrack;
    private final AudioManager audioManager;
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioTrack audioTrack;
    @Nullable
    private AudioTrackThread audioThread;
    private static volatile boolean speakerMute;
    private byte[] emptyBytes;
    @Nullable
    private static WebRtcAudioTrackErrorCallback errorCallbackOld;
    @Nullable
    private static ErrorCallback errorCallback;
    @Nullable
    private static WebRtcRemoteAudioCallback remoteAudioCallback;

    public static synchronized void setAudioTrackUsageAttribute(int usage) {
        int n;
        Logging.w(TAG, "Default usage attribute is changed from: " + DEFAULT_USAGE + " to " + usage);
        usageAttribute = n;
    }

    private static int getDefaultUsageAttribute() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        return 0;
    }

    @Deprecated
    public static void setErrorCallback(WebRtcAudioTrackErrorCallback errorCallback) {
        WebRtcAudioTrackErrorCallback webRtcAudioTrackErrorCallback;
        Logging.d(TAG, "Set error callback: ".concat(String.valueOf(errorCallback)));
        errorCallbackOld = webRtcAudioTrackErrorCallback;
    }

    public static void setErrorCallback(ErrorCallback errorCallback) {
        ErrorCallback errorCallback2;
        Logging.d(TAG, "Set extended error callback");
        WebRtcAudioTrack.errorCallback = errorCallback2;
    }

    public static void setRemoteAudioCallback(WebRtcRemoteAudioCallback remoteAudioCallback) {
        WebRtcRemoteAudioCallback webRtcRemoteAudioCallback;
        Logging.d(TAG, "Set remote audio callback: ".concat(String.valueOf(remoteAudioCallback)));
        WebRtcAudioTrack.remoteAudioCallback = webRtcRemoteAudioCallback;
    }

    /*
     * WARNING - void declaration
     */
    WebRtcAudioTrack(long nativeAudioTrack) {
        void var1_1;
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.nativeAudioTrack = var1_1;
        this.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
    }

    /*
     * WARNING - void declaration
     */
    private boolean initPlayout(int sampleRate, int channels) {
        int n;
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "initPlayout(sampleRate=" + sampleRate + ", channels=" + channels + ")");
        int n2 = channels * 2;
        this.byteBuffer = ByteBuffer.allocateDirect(n2 * (sampleRate / 100));
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.nativeCacheDirectBufferAddress(webRtcAudioTrack.byteBuffer, this.nativeAudioTrack);
        n = this.channelCountToConfiguration(n);
        n2 = AudioTrack.getMinBufferSize((int)sampleRate, (int)n, (int)2);
        Logging.d(TAG, "AudioTrack.getMinBufferSize: ".concat(String.valueOf(n2)));
        if (n2 < this.byteBuffer.capacity()) {
            this.reportWebRtcAudioTrackInitError("AudioTrack.getMinBufferSize returns an invalid value.");
            return false;
        }
        if (this.audioTrack != null) {
            this.reportWebRtcAudioTrackInitError("Conflict with existing AudioTrack.");
            return false;
        }
        try {
            void var1_1;
            this.audioTrack = Build.VERSION.SDK_INT >= 21 ? WebRtcAudioTrack.createAudioTrackOnLollipopOrHigher(sampleRate, n, n2) : WebRtcAudioTrack.createAudioTrackOnLowerThanLollipop((int)var1_1, n, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.reportWebRtcAudioTrackInitError(illegalArgumentException.getMessage());
            this.releaseAudioResources();
            return false;
        }
        if (this.audioTrack == null || this.audioTrack.getState() != 1) {
            this.reportWebRtcAudioTrackInitError("Initialization of audio track failed.");
            this.releaseAudioResources();
            return false;
        }
        this.logMainParameters();
        this.logMainParametersExtended();
        return true;
    }

    private boolean startPlayout() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "startPlayout");
        WebRtcAudioTrack.assertTrue(this.audioTrack != null);
        WebRtcAudioTrack.assertTrue(this.audioThread == null);
        try {
            this.audioTrack.play();
        }
        catch (IllegalStateException illegalStateException) {
            this.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_EXCEPTION, "AudioTrack.play failed: " + illegalStateException.getMessage());
            this.releaseAudioResources();
            return false;
        }
        if (this.audioTrack.getPlayState() != 3) {
            this.reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode.AUDIO_TRACK_START_STATE_MISMATCH, "AudioTrack.play failed - incorrect state :" + this.audioTrack.getPlayState());
            this.releaseAudioResources();
            return false;
        }
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopPlayout() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "stopPlayout");
        WebRtcAudioTrack.assertTrue(this.audioThread != null);
        this.logUnderrunCount();
        this.audioThread.stopThread();
        Logging.d(TAG, "Stopping the AudioTrackThread...");
        this.audioThread.interrupt();
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioTrackThread timed out.");
            WebRtcAudioUtils.logAudioState(TAG);
        }
        Logging.d(TAG, "AudioTrackThread has now been stopped.");
        this.audioThread = null;
        this.releaseAudioResources();
        return true;
    }

    private int getStreamMaxVolume() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamMaxVolume");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        return this.audioManager.getStreamMaxVolume(0);
    }

    /*
     * WARNING - void declaration
     */
    private boolean setStreamVolume(int volume) {
        void var1_1;
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "setStreamVolume(" + volume + ")");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        if (this.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, (int)var1_1, 0);
        return true;
    }

    private boolean isVolumeFixed() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    private int getStreamVolume() {
        this.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamVolume");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        return this.audioManager.getStreamVolume(0);
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioTrack: session ID: " + this.audioTrack.getAudioSessionId() + ", channels: " + this.audioTrack.getChannelCount() + ", sample rate: " + this.audioTrack.getSampleRate() + ", max gain: " + AudioTrack.getMaxVolume());
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=21)
    private static AudioTrack createAudioTrackOnLollipopOrHigher(int sampleRateInHz, int channelConfig, int bufferSizeInBytes) {
        void var2_2;
        void var1_1;
        int n;
        Logging.d(TAG, "createAudioTrackOnLollipopOrHigher");
        int n2 = AudioTrack.getNativeOutputSampleRate((int)0);
        Logging.d(TAG, "nativeOutputSampleRate: ".concat(String.valueOf(n2)));
        if (sampleRateInHz != n2) {
            Logging.w(TAG, "Unable to use fast mode since requested sample rate is not native");
        }
        if (usageAttribute != DEFAULT_USAGE) {
            Logging.w(TAG, "A non default usage attribute is used: " + usageAttribute);
        }
        return new AudioTrack(new AudioAttributes.Builder().setUsage(usageAttribute).setContentType(1).build(), new AudioFormat.Builder().setEncoding(2).setSampleRate(n).setChannelMask((int)var1_1).build(), (int)var2_2, 1, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static AudioTrack createAudioTrackOnLowerThanLollipop(int sampleRateInHz, int channelConfig, int bufferSizeInBytes) {
        void var2_2;
        void var1_1;
        int n;
        return new AudioTrack(0, n, (int)var1_1, 2, (int)var2_2, 1);
    }

    private void logBufferSizeInFrames() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioTrack: buffer size in frames: " + this.audioTrack.getBufferSizeInFrames());
        }
    }

    private void logBufferCapacityInFrames() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, "AudioTrack: buffer capacity in frames: " + this.audioTrack.getBufferCapacityInFrames());
        }
    }

    private void logMainParametersExtended() {
        this.logBufferSizeInFrames();
        this.logBufferCapacityInFrames();
    }

    private void logUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, "underrun count: " + this.audioTrack.getUnderrunCount());
        }
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        if (channels == 1) {
            return 4;
        }
        return 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2);

    public static void setSpeakerMute(boolean mute) {
        boolean bl;
        Logging.w(TAG, "setSpeakerMute(" + mute + ")");
        speakerMute = bl;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportWebRtcAudioTrackInitError(String errorMessage) {
        Logging.e(TAG, "Init playout error: ".concat(String.valueOf(errorMessage)));
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallbackOld != null) {
            errorCallbackOld.onWebRtcAudioTrackInitError(errorMessage);
        }
        if (errorCallback != null) {
            void var1_1;
            errorCallback.onWebRtcAudioTrackInitError((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportWebRtcAudioTrackStartError(AudioTrackStartErrorCode errorCode, String errorMessage) {
        Logging.e(TAG, "Start playout error: " + (Object)((Object)errorCode) + ". " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallbackOld != null) {
            errorCallbackOld.onWebRtcAudioTrackStartError(errorMessage);
        }
        if (errorCallback != null) {
            void var2_2;
            void var1_1;
            errorCallback.onWebRtcAudioTrackStartError((AudioTrackStartErrorCode)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportWebRtcAudioTrackError(String errorMessage) {
        Logging.e(TAG, "Run-time playback error: ".concat(String.valueOf(errorMessage)));
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallbackOld != null) {
            errorCallbackOld.onWebRtcAudioTrackError(errorMessage);
        }
        if (errorCallback != null) {
            void var1_1;
            errorCallback.onWebRtcAudioTrackError((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(WebRtcAudioTrack x0, int x1, long x2) {
        void var2_2;
        void var1_1;
        x0.nativeGetPlayoutData((int)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$800(WebRtcAudioTrack x0, String x1) {
        void var1_1;
        x0.reportWebRtcAudioTrackError((String)var1_1);
    }

    static {
        usageAttribute = DEFAULT_USAGE = WebRtcAudioTrack.getDefaultUsageAttribute();
    }

    class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        /*
         * WARNING - void declaration
         */
        public AudioTrackThread(String name) {
            void var2_2;
            super((String)var2_2);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioTrack.TAG, "AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            int n = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                WebRtcAudioTrack webRtcAudioTrack = WebRtcAudioTrack.this;
                WebRtcAudioTrack.access$400(webRtcAudioTrack, n, webRtcAudioTrack.nativeAudioTrack);
                WebRtcAudioTrack.assertTrue(n <= WebRtcAudioTrack.this.byteBuffer.remaining());
                if (speakerMute) {
                    WebRtcAudioTrack.this.byteBuffer.clear();
                    WebRtcAudioTrack.this.byteBuffer.put(WebRtcAudioTrack.this.emptyBytes);
                    WebRtcAudioTrack.this.byteBuffer.position(0);
                }
                if (remoteAudioCallback != null) {
                    remoteAudioCallback.onRemoteAudioAvailable(WebRtcAudioTrack.this.byteBuffer, n, System.nanoTime());
                }
                AudioTrackThread audioTrackThread = this;
                int n2 = audioTrackThread.writeBytes(audioTrackThread.WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, n);
                if (n2 != n) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.write played invalid number of bytes: ".concat(String.valueOf(n2)));
                    if (n2 < 0) {
                        this.keepAlive = false;
                        WebRtcAudioTrack.access$800(WebRtcAudioTrack.this, "AudioTrack.write failed: ".concat(String.valueOf(n2)));
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            if (WebRtcAudioTrack.this.audioTrack != null) {
                Logging.d(WebRtcAudioTrack.TAG, "Calling AudioTrack.stop...");
                try {
                    WebRtcAudioTrack.this.audioTrack.stop();
                    Logging.d(WebRtcAudioTrack.TAG, "AudioTrack.stop is done.");
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.stop failed: " + illegalStateException.getMessage());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private int writeBytes(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (Build.VERSION.SDK_INT >= 21) {
                return audioTrack.write(byteBuffer, sizeInBytes, 0);
            }
            return var1_1.write(byteBuffer.array(), var2_2.arrayOffset(), (int)var3_3);
        }

        public void stopThread() {
            Logging.d(WebRtcAudioTrack.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface WebRtcRemoteAudioCallback {
        public void onRemoteAudioAvailable(ByteBuffer var1, int var2, long var3);
    }

    public static interface ErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(AudioTrackStartErrorCode var1, String var2);

        public void onWebRtcAudioTrackError(String var1);
    }

    @Deprecated
    public static interface WebRtcAudioTrackErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(String var1);

        public void onWebRtcAudioTrackError(String var1);
    }

    public static enum AudioTrackStartErrorCode {
        AUDIO_TRACK_START_EXCEPTION,
        AUDIO_TRACK_START_STATE_MISMATCH;

    }
}

