/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.droid.rtc;

import com.qiniu.droid.rtc.QNAudioScene;
import com.qiniu.droid.rtc.QNLogLevel;
import com.qiniu.droid.rtc.utils.R7N8DF4OVS;
import java.io.File;
import org.qnwebrtc.CalledByNative;

public class QNRTCSetting {
    private static final String TAG = "QNRTCSetting";
    private boolean mHWCodecEnabled = false;
    private boolean mMaintainResolution = false;
    private String mFieldTrials;
    private TransportPolicy mTransportPolicy = TransportPolicy.FORCE_UDP;
    private QNAudioScene mAudioScene = QNAudioScene.DEFAULT;
    private boolean mEncoderQualityMode = false;
    private boolean mDefaultAudioRouteToSpeakerphone = true;
    private QNLogLevel mLogLevel = QNLogLevel.INFO;
    private String mCustomSharedLibraryDir = null;
    private int mReconnectionTimeout = 30000;

    /*
     * WARNING - void declaration
     */
    public QNRTCSetting setHWCodecEnabled(boolean enabled) {
        void var1_1;
        this.mHWCodecEnabled = var1_1;
        return this;
    }

    @Deprecated
    @CalledByNative
    public boolean isMaintainResolution() {
        return this.mMaintainResolution;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public QNRTCSetting setMaintainResolution(boolean maintainResolution) {
        void var1_1;
        this.mMaintainResolution = var1_1;
        return this;
    }

    @CalledByNative
    public boolean isHWCodecEnabled() {
        return this.mHWCodecEnabled;
    }

    public String getFieldTrials() {
        return this.mFieldTrials;
    }

    /*
     * WARNING - void declaration
     */
    public QNRTCSetting setFieldTrials(String fieldTrials) {
        void var1_1;
        this.mFieldTrials = var1_1;
        return this;
    }

    @CalledByNative
    public TransportPolicy getTransportPolicy() {
        return this.mTransportPolicy;
    }

    /*
     * WARNING - void declaration
     */
    public QNRTCSetting setTransportPolicy(TransportPolicy transportPolicy) {
        void var1_1;
        this.mTransportPolicy = var1_1;
        return this;
    }

    @CalledByNative
    public QNAudioScene getAudioScene() {
        return this.mAudioScene;
    }

    /*
     * WARNING - void declaration
     */
    public QNRTCSetting setAudioScene(QNAudioScene audioScene) {
        void var1_1;
        this.mAudioScene = var1_1;
        return this;
    }

    @CalledByNative
    public boolean isEncoderQualityMode() {
        return this.mEncoderQualityMode;
    }

    /*
     * WARNING - void declaration
     */
    public QNRTCSetting setEncoderQualityMode(boolean encoderQualityMode) {
        void var1_1;
        this.mEncoderQualityMode = var1_1;
        return this;
    }

    @CalledByNative
    public boolean isDefaultAudioRouteToSpeakerphone() {
        return this.mDefaultAudioRouteToSpeakerphone;
    }

    /*
     * WARNING - void declaration
     */
    public QNRTCSetting setDefaultAudioRouteToSpeakerphone(boolean defaultAudioRouteToSpeakerphone) {
        void var1_1;
        this.mDefaultAudioRouteToSpeakerphone = var1_1;
        return this;
    }

    @CalledByNative
    public String getCustomSharedLibraryDir() {
        return this.mCustomSharedLibraryDir;
    }

    /*
     * WARNING - void declaration
     */
    public QNRTCSetting setCustomSharedLibraryDir(String customSharedLibraryDir) {
        try {
            void var1_1;
            File file = new File(customSharedLibraryDir);
            if (!file.exists() && !file.mkdir()) {
                R7N8DF4OVS.d("Dir does not exists, mkdir failed: ".concat(String.valueOf(customSharedLibraryDir)));
                return this;
            }
            if (!file.isDirectory()) {
                R7N8DF4OVS.d("Invalid custom shared library directory: ".concat(String.valueOf(customSharedLibraryDir)));
                return this;
            }
            this.mCustomSharedLibraryDir = var1_1;
        }
        catch (Exception exception) {
            R7N8DF4OVS.d(exception.getMessage());
        }
        return this;
    }

    @CalledByNative
    public int getReconnectionTimeout() {
        return this.mReconnectionTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public QNRTCSetting setReconnectionTimeout(int reconnectionTimeout) {
        void var1_1;
        this.mReconnectionTimeout = var1_1;
        return this;
    }

    @Deprecated
    @CalledByNative
    public QNLogLevel getLogLevel() {
        return this.mLogLevel;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public QNRTCSetting setLogLevel(QNLogLevel logLevel) {
        void var1_1;
        this.mLogLevel = var1_1;
        return this;
    }

    public String toString() {
        return "QNRTCSetting{HWCodecEnabled=" + this.mHWCodecEnabled + ", MaintainResolution=" + this.mMaintainResolution + ", FieldTrials='" + this.mFieldTrials + '\'' + ", TransportPolicy=" + (Object)((Object)this.mTransportPolicy) + ", EncoderQualityMode=" + this.mEncoderQualityMode + ", DefaultAudioRouteToSpeakerphone=" + this.mDefaultAudioRouteToSpeakerphone + '}';
    }

    public static enum TransportPolicy {
        FORCE_UDP,
        FORCE_TCP,
        PREFER_UDP;

    }
}

