/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.graphics.ImageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.qnwebrtc.Histogram;
import org.qnwebrtc.Size;

public class CameraEnumerationAndroid {
    private static final String TAG = "CameraEnumerationAndroid";
    static final ArrayList<Size> COMMON_RESOLUTIONS = new ArrayList<Size>(Arrays.asList(new Size(160, 120), new Size(240, 160), new Size(320, 240), new Size(400, 240), new Size(480, 320), new Size(640, 360), new Size(640, 480), new Size(768, 480), new Size(854, 480), new Size(800, 600), new Size(960, 540), new Size(960, 640), new Size(1024, 576), new Size(1024, 600), new Size(1280, 720), new Size(1280, 1024), new Size(1920, 1080), new Size(1920, 1440), new Size(2560, 1440), new Size(3840, 2160)));
    public static List<Size> supportedSizesStatistic = new ArrayList<Size>();

    /*
     * WARNING - void declaration
     */
    public static CaptureFormat.FramerateRange getClosestSupportedFramerateRange(List<CaptureFormat.FramerateRange> supportedFramerates, int requestedFps) {
        void var1_1;
        return Collections.min(supportedFramerates, new ClosestComparator<CaptureFormat.FramerateRange>((int)var1_1){
            private static final int MAX_FPS_DIFF_THRESHOLD = 5000;
            private static final int MAX_FPS_LOW_DIFF_WEIGHT = 1;
            private static final int MAX_FPS_HIGH_DIFF_WEIGHT = 3;
            private static final int MIN_FPS_THRESHOLD = 8000;
            private static final int MIN_FPS_LOW_VALUE_WEIGHT = 1;
            private static final int MIN_FPS_HIGH_VALUE_WEIGHT = 4;
            final /* synthetic */ int val$requestedFps;
            {
                this.val$requestedFps = n;
            }

            /*
             * WARNING - void declaration
             */
            private int progressivePenalty(int value, int threshold, int lowWeight, int highWeight) {
                void var2_2;
                void var1_1;
                void var3_3;
                if (value < threshold) {
                    return value * lowWeight;
                }
                return threshold * var3_3 + (var1_1 - var2_2) * highWeight;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            int diff(CaptureFormat.FramerateRange range) {
                void var1_1;
                1 v0 = this;
                int n = v0.progressivePenalty(Math.abs(v0.val$requestedFps * 1000 - range.min), 8000, 1, 4);
                1 v1 = this;
                int n2 = v1.progressivePenalty(Math.abs(v1.val$requestedFps * 1000 - var1_1.max), 5000, 1, 3);
                return n + n2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Size getClosestSupportedSize(List<Size> supportedSizes, int requestedWidth, int requestedHeight) {
        void var2_2;
        void var1_1;
        List<Size> list;
        supportedSizesStatistic.clear();
        if (supportedSizes != null) {
            supportedSizesStatistic.addAll(supportedSizes);
        }
        return Collections.min(list, new ClosestComparator<Size>((int)var1_1, (int)var2_2){
            final /* synthetic */ int val$requestedWidth;
            final /* synthetic */ int val$requestedHeight;
            {
                this.val$requestedWidth = n;
                this.val$requestedHeight = n2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            int diff(Size size) {
                void var1_1;
                return Math.abs(this.val$requestedWidth - size.width) + Math.abs(this.val$requestedHeight - var1_1.height);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    static void reportCameraResolution(Histogram histogram, Size resolution) {
        Histogram histogram2;
        void var1_1;
        int n = COMMON_RESOLUTIONS.indexOf(var1_1);
        histogram2.addSample(n + 1);
    }

    static abstract class ClosestComparator<T>
    implements Comparator<T> {
        private ClosestComparator() {
        }

        abstract int diff(T var1);

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(T t1, T t2) {
            void var2_2;
            void var1_1;
            return this.diff(var1_1) - this.diff(var2_2);
        }
    }

    public static class CaptureFormat {
        public final int width;
        public final int height;
        public final FramerateRange framerate;
        public final int imageFormat = 17;

        /*
         * WARNING - void declaration
         */
        public CaptureFormat(int width, int height, int minFramerate, int maxFramerate) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
            this.framerate = new FramerateRange((int)var3_3, maxFramerate);
        }

        /*
         * WARNING - void declaration
         */
        public CaptureFormat(int width, int height, FramerateRange framerate) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
            this.framerate = var3_3;
        }

        public int frameSize() {
            return CaptureFormat.frameSize(this.width, this.height, 17);
        }

        /*
         * WARNING - void declaration
         */
        public static int frameSize(int width, int height, int imageFormat) {
            void var2_2;
            void var1_1;
            int n;
            if (imageFormat != 17) {
                throw new UnsupportedOperationException("Don't know how to calculate the frame size of non-NV21 image formats.");
            }
            return n * var1_1 * ImageFormat.getBitsPerPixel((int)var2_2) / 8;
        }

        public String toString() {
            return this.width + "x" + this.height + "@" + this.framerate;
        }

        public boolean equals(Object other) {
            CaptureFormat captureFormat;
            if (!(other instanceof CaptureFormat)) {
                return false;
            }
            captureFormat = captureFormat;
            return this.width == captureFormat.width && this.height == captureFormat.height && this.framerate.equals(captureFormat.framerate);
        }

        public int hashCode() {
            return 1 + (this.width * 65497 + this.height) * 251 + this.framerate.hashCode();
        }

        public static class FramerateRange {
            public int min;
            public int max;

            /*
             * WARNING - void declaration
             */
            public FramerateRange(int min, int max) {
                void var2_2;
                void var1_1;
                this.min = var1_1;
                this.max = var2_2;
            }

            public String toString() {
                return "[" + (float)this.min / 1000.0f + ":" + (float)this.max / 1000.0f + "]";
            }

            public boolean equals(Object other) {
                FramerateRange framerateRange;
                if (!(other instanceof FramerateRange)) {
                    return false;
                }
                framerateRange = framerateRange;
                return this.min == framerateRange.min && this.max == framerateRange.max;
            }

            public int hashCode() {
                return 1 + 65537 * this.min + this.max;
            }
        }
    }
}

