/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.content.Context;
import android.graphics.Matrix;
import android.view.WindowManager;
import java.util.List;
import org.qnwebrtc.Size;
import org.qnwebrtc.TextureBufferImpl;
import org.qnwebrtc.VideoFrame;

interface CameraSession {
    public void stop();

    public boolean turnLight(boolean var1);

    public void manualFocus(float var1, float var2, int var3, int var4);

    public void setMirror(boolean var1);

    public void setExposureCompensation(int var1);

    public int getMaxExposureCompensation();

    public int getMinExposureCompensation();

    public void setZoom(int var1);

    public List<Integer> getZoomRatios();

    public static int getDeviceOrientation(Context context) {
        switch (((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRotation()) {
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public static VideoFrame.TextureBuffer createTextureBufferWithModifiedTransformMatrix(TextureBufferImpl buffer, MirrorFlag flag, int rotation) {
        TextureBufferImpl textureBufferImpl;
        void var2_2;
        void var1_1;
        Matrix matrix = new Matrix();
        matrix.preTranslate(0.5f, 0.5f);
        if (flag == MirrorFlag.HORIZONTAL) {
            matrix.preScale(-1.0f, 1.0f);
        } else if (flag == MirrorFlag.VERTICAL) {
            matrix.preScale(1.0f, -1.0f);
        } else if (var1_1 == MirrorFlag.HORIZONTAL_VERTICAL) {
            matrix.preScale(-1.0f, -1.0f);
        }
        matrix.preRotate((float)var2_2);
        matrix.preTranslate(-0.5f, -0.5f);
        return buffer.applyTransformMatrix(matrix, buffer.getWidth(), textureBufferImpl.getHeight());
    }

    public static interface Events {
        public void onCameraOpening();

        public int[] onCameraOpened(List<Size> var1, List<Integer> var2);

        public void onCameraError(CameraSession var1, String var2);

        public void onCameraDisconnected(CameraSession var1);

        public void onCameraClosed(CameraSession var1);

        public void onFrameCaptured(CameraSession var1, VideoFrame var2);
    }

    public static interface CreateSessionCallback {
        public void onDone(CameraSession var1);

        public void onFailure(FailureType var1, String var2);
    }

    public static enum MirrorFlag {
        NONE,
        HORIZONTAL,
        VERTICAL,
        HORIZONTAL_VERTICAL;

    }

    public static enum FailureType {
        ERROR,
        DISCONNECTED;

    }
}

