/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.media.MediaRecorder;
import java.util.List;
import org.qnwebrtc.CapturerObserver;
import org.qnwebrtc.Logging;
import org.qnwebrtc.Size;
import org.qnwebrtc.SurfaceTextureHelper;
import org.qnwebrtc.VideoCapturer;

public interface CameraVideoCapturer
extends VideoCapturer {
    public void switchCamera(CameraSwitchHandler var1);

    public void setCaptureListener(CapturerObserver var1);

    public CapturerObserver getCapturerObserver();

    public boolean turnLight(boolean var1);

    public void manualFocus(float var1, float var2, int var3, int var4);

    public void setMirror(boolean var1);

    public void setExposureCompensation(int var1);

    public int getMaxExposureCompensation();

    public int getMinExposureCompensation();

    public void setZoom(int var1);

    public List<Integer> getZoomRatios();

    @Deprecated
    default public void addMediaRecorderToCamera(MediaRecorder mediaRecorder, MediaRecorderHandler resultHandler) {
        throw new UnsupportedOperationException("Deprecated and not implemented.");
    }

    @Deprecated
    default public void removeMediaRecorderFromCamera(MediaRecorderHandler resultHandler) {
        throw new UnsupportedOperationException("Deprecated and not implemented.");
    }

    public static class CameraStatistics {
        private static final String TAG = "CameraStatistics";
        private static final int CAMERA_OBSERVER_PERIOD_MS = 2000;
        private static final int CAMERA_FREEZE_REPORT_TIMOUT_MS = 4000;
        private final SurfaceTextureHelper surfaceTextureHelper;
        private final CameraEventsHandler eventsHandler;
        private int frameCount;
        private int freezePeriodCount;
        private final Runnable cameraObserver = new Runnable(this){
            final /* synthetic */ CameraStatistics this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                int n = Math.round((float)this.this$0.frameCount * 1000.0f / 2000.0f);
                Logging.d(CameraStatistics.TAG, "Camera fps: " + n + ".");
                if (this.this$0.frameCount == 0) {
                    ++this.this$0.freezePeriodCount;
                    if (2000 * this.this$0.freezePeriodCount >= 4000 && this.this$0.eventsHandler != null) {
                        Logging.e(CameraStatistics.TAG, "Camera freezed.");
                        if (this.this$0.surfaceTextureHelper.isTextureInUse()) {
                            this.this$0.eventsHandler.onCameraFreezed("Camera failure. Client must return video buffers.");
                            return;
                        }
                        this.this$0.eventsHandler.onCameraFreezed("Camera failure.");
                        return;
                    }
                } else {
                    CameraStatistics.access$102(this.this$0, 0);
                }
                CameraStatistics.access$002(this.this$0, 0);
                this.this$0.surfaceTextureHelper.getHandler().postDelayed((Runnable)this, 2000L);
            }
        };

        /*
         * WARNING - void declaration
         */
        public CameraStatistics(SurfaceTextureHelper surfaceTextureHelper, CameraEventsHandler eventsHandler) {
            void var1_1;
            void var2_2;
            if (surfaceTextureHelper == null) {
                throw new IllegalArgumentException("SurfaceTextureHelper is null");
            }
            this.surfaceTextureHelper = surfaceTextureHelper;
            this.eventsHandler = var2_2;
            this.frameCount = 0;
            this.freezePeriodCount = 0;
            var1_1.getHandler().postDelayed(this.cameraObserver, 2000L);
        }

        private void checkThread() {
            if (Thread.currentThread() != this.surfaceTextureHelper.getHandler().getLooper().getThread()) {
                throw new IllegalStateException("Wrong thread");
            }
        }

        public void addFrame() {
            this.checkThread();
            ++this.frameCount;
        }

        public void release() {
            this.surfaceTextureHelper.getHandler().removeCallbacks(this.cameraObserver);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$102(CameraStatistics x0, int x1) {
            void var1_1;
            x0.freezePeriodCount = var1_1;
            return x0.freezePeriodCount;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$002(CameraStatistics x0, int x1) {
            void var1_1;
            x0.frameCount = var1_1;
            return x0.frameCount;
        }
    }

    @Deprecated
    public static interface MediaRecorderHandler {
        public void onMediaRecorderSuccess();

        public void onMediaRecorderError(String var1);
    }

    public static interface CameraSwitchHandler {
        public void onCameraSwitchDone(boolean var1);

        public void onCameraSwitchError(String var1);
    }

    public static interface CameraEventsHandler {
        public void onCameraError(String var1);

        public void onCameraDisconnected();

        public void onCameraFreezed(String var1);

        public void onCameraOpening(String var1);

        public int[] onCameraOpened(List<Size> var1, List<Integer> var2);

        public void onFirstFrameAvailable(Size var1);

        public void onCameraClosed();
    }
}

