/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.HardwareVideoEncoderFactory;
import org.qnwebrtc.SoftwareVideoEncoderFactory;
import org.qnwebrtc.VideoCodecInfo;
import org.qnwebrtc.VideoEncoder;
import org.qnwebrtc.VideoEncoderFactory;
import org.qnwebrtc.VideoEncoderFallback;

public class DefaultVideoEncoderFactory
implements VideoEncoderFactory {
    private final VideoEncoderFactory hardwareVideoEncoderFactory;
    private final VideoEncoderFactory softwareVideoEncoderFactory;
    private final boolean qiniuFallback;

    /*
     * WARNING - void declaration
     */
    public DefaultVideoEncoderFactory(EglBase.Context eglContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile, boolean qiniuFallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.hardwareVideoEncoderFactory = new HardwareVideoEncoderFactory((EglBase.Context)var1_1, (boolean)var2_2, enableH264HighProfile);
        this.softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory((boolean)var3_3);
        this.qiniuFallback = qiniuFallback;
    }

    /*
     * WARNING - void declaration
     */
    DefaultVideoEncoderFactory(VideoEncoderFactory hardwareVideoEncoderFactory) {
        void var1_1;
        this.hardwareVideoEncoderFactory = var1_1;
        this.softwareVideoEncoderFactory = new SoftwareVideoEncoderFactory(false);
        this.qiniuFallback = false;
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info) {
        VideoEncoder videoEncoder;
        VideoEncoder videoEncoder2 = this.softwareVideoEncoderFactory.createEncoder(info);
        if ((videoEncoder = this.hardwareVideoEncoderFactory.createEncoder((VideoCodecInfo)((Object)videoEncoder))) != null && videoEncoder2 != null) {
            return new VideoEncoderFallback(videoEncoder2, videoEncoder, this.qiniuFallback);
        }
        if (videoEncoder != null) {
            return videoEncoder;
        }
        return videoEncoder2;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        LinkedHashSet<VideoCodecInfo> linkedHashSet = new LinkedHashSet<VideoCodecInfo>();
        linkedHashSet.addAll(Arrays.asList(this.softwareVideoEncoderFactory.getSupportedCodecs()));
        linkedHashSet.addAll(Arrays.asList(this.hardwareVideoEncoderFactory.getSupportedCodecs()));
        LinkedHashSet<VideoCodecInfo> linkedHashSet2 = linkedHashSet;
        return linkedHashSet2.toArray(new VideoCodecInfo[linkedHashSet2.size()]);
    }
}

