/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.support.annotation.Nullable;
import android.view.Surface;
import android.view.SurfaceHolder;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.EglBase10;

class EglBase10Impl
implements EglBase10 {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private final EGL10 egl;
    private EGLContext eglContext;
    @Nullable
    private EGLConfig eglConfig;
    private EGLDisplay eglDisplay;
    private EGLSurface eglSurface = EGL10.EGL_NO_SURFACE;

    /*
     * WARNING - void declaration
     */
    public EglBase10Impl(EGLContext sharedContext, int[] configAttributes) {
        void var1_1;
        void var2_2;
        this.egl = (EGL10)EGLContext.getEGL();
        this.eglDisplay = this.getEglDisplay();
        this.eglConfig = this.getEglConfig(this.eglDisplay, (int[])var2_2);
        this.eglContext = this.createEglContext((EGLContext)var1_1, this.eglDisplay, this.eglConfig);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createSurface(Surface surface) {
        void var1_1;
        class FakeSurfaceHolder
        implements SurfaceHolder {
            private final Surface surface;
            final /* synthetic */ EglBase10Impl this$0;

            /*
             * WARNING - void declaration
             */
            FakeSurfaceHolder(EglBase10Impl this$0, Surface surface) {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.surface = var2_2;
            }

            public void addCallback(SurfaceHolder.Callback callback) {
            }

            public void removeCallback(SurfaceHolder.Callback callback) {
            }

            public boolean isCreating() {
                return false;
            }

            @Deprecated
            public void setType(int i2) {
            }

            public void setFixedSize(int i2, int i22) {
            }

            public void setSizeFromLayout() {
            }

            public void setFormat(int i2) {
            }

            public void setKeepScreenOn(boolean b2) {
            }

            @Nullable
            public Canvas lockCanvas() {
                return null;
            }

            @Nullable
            public Canvas lockCanvas(Rect rect) {
                return null;
            }

            public void unlockCanvasAndPost(Canvas canvas) {
            }

            @Nullable
            public Rect getSurfaceFrame() {
                return null;
            }

            public Surface getSurface() {
                return this.surface;
            }
        }
        this.createSurfaceInternal(new FakeSurfaceHolder(this, (Surface)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createSurface(SurfaceTexture surfaceTexture) {
        void var1_1;
        this.createSurfaceInternal(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void createSurfaceInternal(Object nativeWindow) {
        void var1_1;
        if (!(nativeWindow instanceof SurfaceHolder) && !(nativeWindow instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a SurfaceHolder or SurfaceTexture");
        }
        this.checkIsNotReleased();
        if (this.eglSurface != EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("Already has an EGLSurface");
        }
        int[] nArray = new int[]{12344};
        this.eglSurface = this.egl.eglCreateWindowSurface(this.eglDisplay, this.eglConfig, (Object)var1_1, nArray);
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("Failed to create window surface: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createPbufferSurface(int width, int height) {
        this.checkIsNotReleased();
        if (this.eglSurface != EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("Already has an EGLSurface");
        }
        int[] nArray = new int[]{12375, width, 12374, height, 12344};
        this.eglSurface = this.egl.eglCreatePbufferSurface(this.eglDisplay, this.eglConfig, nArray);
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            void var2_2;
            void var1_1;
            throw new RuntimeException("Failed to create pixel buffer surface with size " + (int)var1_1 + "x" + (int)var2_2 + ": 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
    }

    @Override
    public EglBase.Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        return this.eglSurface != EGL10.EGL_NO_SURFACE;
    }

    @Override
    public int surfaceWidth() {
        int[] nArray = new int[1];
        this.egl.eglQuerySurface(this.eglDisplay, this.eglSurface, 12375, nArray);
        return nArray[0];
    }

    @Override
    public int surfaceHeight() {
        int[] nArray = new int[1];
        this.egl.eglQuerySurface(this.eglDisplay, this.eglSurface, 12374, nArray);
        return nArray[0];
    }

    @Override
    public void releaseSurface() {
        if (this.eglSurface != EGL10.EGL_NO_SURFACE) {
            this.egl.eglDestroySurface(this.eglDisplay, this.eglSurface);
            this.eglSurface = EGL10.EGL_NO_SURFACE;
        }
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay == EGL10.EGL_NO_DISPLAY || this.eglContext == EGL10.EGL_NO_CONTEXT || this.eglConfig == null) {
            throw new RuntimeException("This object has been released");
        }
    }

    @Override
    public void release() {
        this.checkIsNotReleased();
        this.releaseSurface();
        this.detachCurrent();
        this.egl.eglDestroyContext(this.eglDisplay, this.eglContext);
        this.egl.eglTerminate(this.eglDisplay);
        this.eglContext = EGL10.EGL_NO_CONTEXT;
        this.eglDisplay = EGL10.EGL_NO_DISPLAY;
        this.eglConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeCurrent() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't make current");
        }
        Object object = EglBase.lock;
        synchronized (object) {
            if (!this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
                throw new RuntimeException("eglMakeCurrent failed: 0x" + Integer.toHexString(this.egl.eglGetError()));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachCurrent() {
        Object object = EglBase.lock;
        synchronized (object) {
            EGLSurface eGLSurface = EGL10.EGL_NO_SURFACE;
            if (!this.egl.eglMakeCurrent(this.eglDisplay, eGLSurface, eGLSurface, EGL10.EGL_NO_CONTEXT)) {
                throw new RuntimeException("eglDetachCurrent failed: 0x" + Integer.toHexString(this.egl.eglGetError()));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't swap buffers");
        }
        Object object = EglBase.lock;
        synchronized (object) {
            this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface);
            return;
        }
    }

    @Override
    public void swapBuffers(long timeStampNs) {
        this.swapBuffers();
    }

    private EGLDisplay getEglDisplay() {
        EGLDisplay eGLDisplay = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (eGLDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("Unable to get EGL10 display: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        int[] nArray = new int[2];
        if (!this.egl.eglInitialize(eGLDisplay, nArray)) {
            throw new RuntimeException("Unable to initialize EGL10: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        return eGLDisplay;
    }

    /*
     * WARNING - void declaration
     */
    private EGLConfig getEglConfig(EGLDisplay eglDisplay, int[] configAttributes) {
        void var2_2;
        EGLConfig eGLConfig;
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray = new int[1];
        if (!this.egl.eglChooseConfig((EGLDisplay)eGLConfig, (int[])var2_2, eGLConfigArray, 1, nArray)) {
            throw new RuntimeException("eglChooseConfig failed: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        if (nArray[0] <= 0) {
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        eGLConfig = eGLConfigArray[0];
        if (eGLConfig == null) {
            throw new RuntimeException("eglChooseConfig returned null");
        }
        return eGLConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private EGLContext createEglContext(@Nullable EGLContext sharedContext, EGLDisplay eglDisplay, EGLConfig eglConfig) {
        EGLContext eGLContext;
        if (sharedContext != null && sharedContext == EGL10.EGL_NO_CONTEXT) {
            throw new RuntimeException("Invalid sharedContext");
        }
        int[] nArray = new int[]{12440, 2, 12344};
        eGLContext = sharedContext == null ? EGL10.EGL_NO_CONTEXT : eGLContext;
        Object object = EglBase.lock;
        synchronized (object) {
            void var3_4;
            void var2_3;
            eGLContext = this.egl.eglCreateContext((EGLDisplay)var2_3, (EGLConfig)var3_4, eGLContext, nArray);
        }
        if (eGLContext == EGL10.EGL_NO_CONTEXT) {
            throw new RuntimeException("Failed to create EGL context: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        return eGLContext;
    }

    static class Context
    implements EglBase10.Context {
        private final EGLContext eglContext;

        @Override
        public EGLContext getRawContext() {
            return this.eglContext;
        }

        @Override
        public long getNativeEglContext() {
            return 0L;
        }

        /*
         * WARNING - void declaration
         */
        public Context(EGLContext eglContext) {
            void var1_1;
            this.eglContext = var1_1;
        }
    }
}

