/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.GlTextureFrameBuffer;
import org.qnwebrtc.GlUtil;
import org.qnwebrtc.Logging;
import org.qnwebrtc.RendererCommon;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoFrameDrawer;
import org.qnwebrtc.VideoSink;

public class EglRenderer
implements VideoSink {
    private static final String TAG = "EglRenderer";
    private static final long LOG_INTERVAL_SEC = 4L;
    protected final String name;
    private final Object handlerLock = new Object();
    @Nullable
    private Handler renderThreadHandler;
    private final ArrayList<FrameListenerAndParams> frameListeners = new ArrayList();
    private final Object fpsReductionLock = new Object();
    private long nextFrameTimeNs;
    private long minRenderPeriodNs;
    @Nullable
    private EglBase eglBase;
    private final VideoFrameDrawer frameDrawer;
    @Nullable
    private RendererCommon.GlDrawer drawer;
    private boolean usePresentationTimeStamp;
    private final Matrix drawMatrix = new Matrix();
    private final Object frameLock = new Object();
    @Nullable
    private VideoFrame pendingFrame;
    private final Object layoutLock = new Object();
    private float layoutAspectRatio;
    private boolean mirrorHorizontally;
    private boolean mirrorVertically;
    private boolean renderScale = true;
    private final Object statisticsLock = new Object();
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long statisticsStartTimeNs;
    private long renderTimeNs;
    private long renderSwapBufferTimeNs;
    private final GlTextureFrameBuffer bitmapTextureFramebuffer = new GlTextureFrameBuffer(6408);
    private final Runnable logStatisticsRunnable = new Runnable(this){
        final /* synthetic */ EglRenderer this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.this$0.logStatistics();
            Object object = this.this$0.handlerLock;
            synchronized (object) {
                if (this.this$0.renderThreadHandler != null) {
                    this.this$0.renderThreadHandler.removeCallbacks(this.this$0.logStatisticsRunnable);
                    this.this$0.renderThreadHandler.postDelayed(this.this$0.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
                }
                return;
            }
        }
    };
    private final EglSurfaceCreation eglSurfaceCreationRunnable = new EglSurfaceCreation();

    /*
     * WARNING - void declaration
     */
    public EglRenderer(String name) {
        this((String)var1_1, new VideoFrameDrawer());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public EglRenderer(String name, VideoFrameDrawer videoFrameDrawer) {
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.frameDrawer = var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void init(@Nullable EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer, boolean usePresentationTimeStamp) {
        Object object = this.handlerLock;
        synchronized (object) {
            void var2_3;
            void var1_1;
            HandlerThread handlerThread;
            if (this.renderThreadHandler != null) {
                throw new IllegalStateException(this.name + "Already initialized");
            }
            this.logD("Initializing EglRenderer");
            this.drawer = handlerThread;
            this.usePresentationTimeStamp = usePresentationTimeStamp;
            handlerThread = new HandlerThread(this.name + TAG);
            handlerThread.start();
            this.renderThreadHandler = new HandlerWithExceptionCallback(handlerThread.getLooper(), new Runnable(this){
                final /* synthetic */ EglRenderer this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = this.this$0.handlerLock;
                    synchronized (object) {
                        EglRenderer.access$302(this.this$0, null);
                        return;
                    }
                }
            });
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, () -> this.lambda$init$0((EglBase.Context)var1_1, (int[])var2_3));
            this.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
            long l2 = System.nanoTime();
            this.resetStatistics(l2);
            this.renderThreadHandler.postDelayed(this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void init(@Nullable EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.init((EglBase.Context)var1_1, (int[])var2_2, (RendererCommon.GlDrawer)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    public void createEglSurface(Surface surface) {
        void var1_1;
        this.createEglSurfaceInternal(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void createEglSurface(SurfaceTexture surfaceTexture) {
        void var1_1;
        this.createEglSurfaceInternal(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void createEglSurfaceInternal(Object surface) {
        void var1_1;
        this.eglSurfaceCreationRunnable.setSurface(var1_1);
        EglRenderer eglRenderer = this;
        eglRenderer.postToRenderThread(eglRenderer.eglSurfaceCreationRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.logD("Releasing.");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            this.renderThreadHandler.removeCallbacks(this.logStatisticsRunnable);
            this.renderThreadHandler.postAtFrontOfQueue(() -> {
                void var1_1;
                GLES20.glUseProgram((int)0);
                if (this.drawer != null) {
                    this.drawer.release();
                    this.drawer = null;
                }
                this.frameDrawer.release();
                this.bitmapTextureFramebuffer.release();
                if (this.eglBase != null) {
                    this.logD("eglBase detach and release.");
                    this.eglBase.detachCurrent();
                    this.eglBase.release();
                    this.eglBase = null;
                }
                this.frameListeners.clear();
                var1_1.countDown();
            });
            Looper looper = this.renderThreadHandler.getLooper();
            this.renderThreadHandler.post(() -> {
                void var1_1;
                this.logD("Quitting render thread.");
                var1_1.quit();
            });
            this.renderThreadHandler = null;
        }
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                this.pendingFrame.release();
                this.pendingFrame = null;
            }
        }
        this.logD("Releasing done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void resetStatistics(long currentTimeNs) {
        Object object = this.statisticsLock;
        synchronized (object) {
            void var1_1;
            this.statisticsStartTimeNs = var1_1;
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.renderTimeNs = 0L;
            this.renderSwapBufferTimeNs = 0L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        Object object = this.handlerLock;
        synchronized (object) {
            StackTraceElement[] stackTraceElementArray = this.renderThreadHandler == null ? null : this.renderThreadHandler.getLooper().getThread();
            if (stackTraceElementArray != null && (stackTraceElementArray = stackTraceElementArray.getStackTrace()).length > 0) {
                this.logW("EglRenderer stack trace:");
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    this.logW(stackTraceElement.toString());
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setMirror(boolean mirror) {
        this.logD("setMirrorHorizontally: ".concat(String.valueOf(mirror)));
        Object object = this.layoutLock;
        synchronized (object) {
            void var1_1;
            this.mirrorHorizontally = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setMirrorVertically(boolean mirrorVertically) {
        this.logD("setMirrorVertically: ".concat(String.valueOf(mirrorVertically)));
        Object object = this.layoutLock;
        synchronized (object) {
            void var1_1;
            this.mirrorVertically = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setRenderScale(boolean scale) {
        this.logD("setRenderScale: ".concat(String.valueOf(scale)));
        Object object = this.layoutLock;
        synchronized (object) {
            void var1_1;
            this.renderScale = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setLayoutAspectRatio(float layoutAspectRatio) {
        this.logD("setLayoutAspectRatio: ".concat(String.valueOf(layoutAspectRatio)));
        Object object = this.layoutLock;
        synchronized (object) {
            void var1_1;
            this.layoutAspectRatio = var1_1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setFpsReduction(float fps) {
        this.logD("setFpsReduction: ".concat(String.valueOf(fps)));
        Object object = this.fpsReductionLock;
        synchronized (object) {
            void var1_1;
            long l2 = this.minRenderPeriodNs;
            this.minRenderPeriodNs = fps <= 0.0f ? Long.MAX_VALUE : (long)((float)TimeUnit.SECONDS.toNanos(1L) / var1_1);
            if (this.minRenderPeriodNs != l2) {
                this.nextFrameTimeNs = System.nanoTime();
            }
            return;
        }
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public void addFrameListener(FrameListener listener, float scale) {
        void var2_2;
        void var1_1;
        this.addFrameListener((FrameListener)var1_1, (float)var2_2, null, false);
    }

    /*
     * WARNING - void declaration
     */
    public void addFrameListener(FrameListener listener, float scale, RendererCommon.GlDrawer drawerParam) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addFrameListener((FrameListener)var1_1, (float)var2_2, (RendererCommon.GlDrawer)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    public void addFrameListener(FrameListener listener, float scale, @Nullable RendererCommon.GlDrawer drawerParam, boolean applyFpsReduction) {
        void var2_2;
        void var1_1;
        void var3_3;
        EglRenderer eglRenderer = this;
        eglRenderer.postToRenderThread(() -> eglRenderer.lambda$addFrameListener$3((RendererCommon.GlDrawer)var3_3, (FrameListener)var1_1, (float)var2_2, applyFpsReduction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeFrameListener(FrameListener listener) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            void var1_1;
            if (this.renderThreadHandler == null) {
                return;
            }
            if (Thread.currentThread() == this.renderThreadHandler.getLooper().getThread()) {
                throw new RuntimeException("removeFrameListener must not be called on the render thread.");
            }
            EglRenderer eglRenderer = this;
            eglRenderer.postToRenderThread(() -> eglRenderer.lambda$removeFrameListener$4(countDownLatch, (FrameListener)var1_1));
        }
        ThreadUtils.awaitUninterruptibly(countDownLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void onFrame(VideoFrame frame) {
        boolean bl;
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.framesReceived;
        }
        Object object2 = this.handlerLock;
        synchronized (object2) {
            if (this.renderThreadHandler == null) {
                this.logD("Dropping frame - Not initialized or already released.");
                return;
            }
            Object object3 = this.frameLock;
            synchronized (object3) {
                void var1_1;
                bl = this.pendingFrame != null;
                if (bl) {
                    this.pendingFrame.release();
                }
                this.pendingFrame = var1_1;
                this.pendingFrame.retain();
                this.renderThreadHandler.post(this::renderFrameOnRenderThread);
            }
        }
        if (bl) {
            object2 = this.statisticsLock;
            synchronized (object2) {
                ++this.framesDropped;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void releaseEglSurface(Runnable completionCallback) {
        void var1_1;
        this.eglSurfaceCreationRunnable.setSurface(null);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
                this.renderThreadHandler.postAtFrontOfQueue(() -> {
                    void var1_1;
                    if (this.eglBase != null) {
                        this.eglBase.detachCurrent();
                        this.eglBase.releaseSurface();
                    }
                    var1_1.run();
                });
                return;
            }
        }
        var1_1.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void postToRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                void var1_1;
                this.renderThreadHandler.post((Runnable)var1_1);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void clearSurfaceOnRenderThread(float r, float g2, float b2, float a2) {
        if (this.eglBase != null && this.eglBase.hasSurface()) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.logD("clearSurface");
            GLES20.glClearColor((float)var1_1, (float)var2_2, (float)var3_3, (float)a2);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    public void clearImage() {
        this.clearImage(0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void clearImage(float r, float g2, float b2, float a2) {
        Object object = this.handlerLock;
        synchronized (object) {
            void var3_4;
            void var2_3;
            void var1_1;
            if (this.renderThreadHandler == null) {
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue(() -> this.lambda$clearImage$6((float)var1_1, (float)var2_3, (float)var3_4, a2));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFrameOnRenderThread() {
        float f2;
        float f3;
        boolean bl;
        VideoFrame videoFrame;
        Object object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame == null) {
                return;
            }
            videoFrame = this.pendingFrame;
            this.pendingFrame = null;
        }
        if (this.eglBase == null || !this.eglBase.hasSurface()) {
            this.logD("Dropping frame - No surface");
            videoFrame.release();
            return;
        }
        Object object2 = this.fpsReductionLock;
        synchronized (object2) {
            if (this.minRenderPeriodNs == Long.MAX_VALUE) {
                bl = false;
            } else if (this.minRenderPeriodNs <= 0L) {
                bl = true;
            } else {
                long l2 = System.nanoTime();
                if (l2 < this.nextFrameTimeNs) {
                    this.logD("Skipping frame rendering - fps reduction is active.");
                    bl = false;
                } else {
                    this.nextFrameTimeNs += this.minRenderPeriodNs;
                    this.nextFrameTimeNs = Math.max(this.nextFrameTimeNs, l2);
                    bl = true;
                }
            }
        }
        long l3 = System.nanoTime();
        float f4 = (float)videoFrame.getRotatedWidth() / (float)videoFrame.getRotatedHeight();
        Object object3 = this.layoutLock;
        synchronized (object3) {
            f3 = this.layoutAspectRatio != 0.0f ? this.layoutAspectRatio : f4;
        }
        if (f4 > f3) {
            f2 = f3 / f4;
            f4 = 1.0f;
        } else {
            f2 = 1.0f;
            f4 /= f3;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        this.drawMatrix.preScale(this.mirrorHorizontally ? -1.0f : 1.0f, this.mirrorVertically ? -1.0f : 1.0f);
        if (this.renderScale) {
            this.drawMatrix.preScale(f2, f4);
        }
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        if (bl) {
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(videoFrame, this.drawer, this.drawMatrix, 0, 0, this.eglBase.surfaceWidth(), this.eglBase.surfaceHeight());
            long l4 = System.nanoTime();
            if (this.usePresentationTimeStamp) {
                this.eglBase.swapBuffers(videoFrame.getTimestampNs());
            } else {
                this.eglBase.swapBuffers();
            }
            long l5 = System.nanoTime();
            Object object4 = this.statisticsLock;
            synchronized (object4) {
                ++this.framesRendered;
                this.renderTimeNs += l5 - l3;
                this.renderSwapBufferTimeNs += l5 - l4;
            }
        }
        this.notifyCallbacks(videoFrame, bl);
        videoFrame.release();
    }

    private void notifyCallbacks(VideoFrame frame, boolean wasRendered) {
        if (this.frameListeners.isEmpty()) {
            return;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        this.drawMatrix.preScale(this.mirrorHorizontally ? -1.0f : 1.0f, this.mirrorVertically ? -1.0f : 1.0f);
        this.drawMatrix.preScale(1.0f, -1.0f);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        Iterator<FrameListenerAndParams> iterator = this.frameListeners.iterator();
        while (iterator.hasNext()) {
            FrameListenerAndParams frameListenerAndParams = iterator.next();
            if (!wasRendered && frameListenerAndParams.applyFpsReduction) continue;
            iterator.remove();
            int n = (int)(frameListenerAndParams.scale * (float)frame.getRotatedWidth());
            int n2 = (int)(frameListenerAndParams.scale * (float)frame.getRotatedHeight());
            if (n == 0 || n2 == 0) {
                frameListenerAndParams.listener.onFrame(null);
                continue;
            }
            this.bitmapTextureFramebuffer.setSize(n, n2);
            GLES20.glBindFramebuffer((int)36160, (int)this.bitmapTextureFramebuffer.getFrameBufferId());
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.bitmapTextureFramebuffer.getTextureId(), (int)0);
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(frame, frameListenerAndParams.drawer, this.drawMatrix, 0, 0, n, n2);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2 * 4);
            GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
            GLES20.glReadPixels((int)0, (int)0, (int)n, (int)n2, (int)6408, (int)5121, (Buffer)byteBuffer);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GlUtil.checkNoGLES2Error("EglRenderer.notifyCallbacks");
            Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            frameListenerAndParams.listener.onFrame(bitmap);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String averageTimeAsString(long sumTimeNs, int count) {
        void var3_2;
        void var1_1;
        if (count <= 0) {
            return "NA";
        }
        return TimeUnit.NANOSECONDS.toMicros((long)(var1_1 / (long)var3_2)) + " us";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatistics() {
        DecimalFormat decimalFormat = new DecimalFormat("#.0");
        long l2 = System.nanoTime();
        Object object = this.statisticsLock;
        synchronized (object) {
            long l3 = l2 - this.statisticsStartTimeNs;
            if (l3 <= 0L) {
                return;
            }
            float f2 = (float)((long)this.framesRendered * TimeUnit.SECONDS.toNanos(1L)) / (float)l3;
            EglRenderer eglRenderer = this;
            EglRenderer eglRenderer2 = this;
            this.logD("Duration: " + TimeUnit.NANOSECONDS.toMillis(l3) + " ms. Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered + ". Render fps: " + decimalFormat.format(f2) + ". Average render time: " + eglRenderer.averageTimeAsString(eglRenderer.renderTimeNs, this.framesRendered) + ". Average swapBuffer time: " + eglRenderer2.averageTimeAsString(eglRenderer2.renderSwapBufferTimeNs, this.framesRendered) + ".");
            this.resetStatistics(l2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logD(String string) {
        void var1_1;
        Logging.d(TAG, this.name + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void logW(String string) {
        void var1_1;
        Logging.w(TAG, this.name + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$clearImage$6(float r, float g2, float b2, float a2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.clearSurfaceOnRenderThread((float)var1_1, (float)var2_2, (float)var3_3, a2);
    }

    private /* synthetic */ void lambda$removeFrameListener$4(CountDownLatch latch, FrameListener listener) {
        latch.countDown();
        Iterator<FrameListenerAndParams> iterator = this.frameListeners.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().listener != listener) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$addFrameListener$3(RendererCommon.GlDrawer drawerParam, FrameListener listener, float scale, boolean applyFpsReduction) {
        void var3_3;
        void var2_2;
        RendererCommon.GlDrawer glDrawer;
        glDrawer = drawerParam == null ? this.drawer : glDrawer;
        this.frameListeners.add(new FrameListenerAndParams((FrameListener)var2_2, (float)var3_3, glDrawer, applyFpsReduction));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$init$0(EglBase.Context sharedContext, int[] configAttributes) {
        void var2_2;
        void var1_1;
        if (sharedContext == null) {
            this.logD("EglBase10.create context");
            this.eglBase = EglBase.createEgl10(configAttributes);
            return;
        }
        this.logD("EglBase.create shared context");
        this.eglBase = EglBase.create((EglBase.Context)var1_1, (int[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Handler access$302(EglRenderer x0, Handler x1) {
        void var1_1;
        x0.renderThreadHandler = var1_1;
        return x0.renderThreadHandler;
    }

    static class HandlerWithExceptionCallback
    extends Handler {
        private final Runnable exceptionCallback;

        /*
         * WARNING - void declaration
         */
        public HandlerWithExceptionCallback(Looper looper, Runnable exceptionCallback) {
            super((Looper)var1_1);
            void var2_2;
            void var1_1;
            this.exceptionCallback = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void dispatchMessage(Message msg) {
            try {
                void var1_1;
                super.dispatchMessage((Message)var1_1);
                return;
            }
            catch (Exception exception) {
                Logging.e(EglRenderer.TAG, "Exception on EglRenderer thread", exception);
                this.exceptionCallback.run();
                throw exception;
            }
        }
    }

    class EglSurfaceCreation
    implements Runnable {
        private Object surface;

        private EglSurfaceCreation() {
        }

        /*
         * WARNING - void declaration
         */
        public synchronized void setSurface(Object surface) {
            void var1_1;
            this.surface = var1_1;
        }

        @Override
        public synchronized void run() {
            if (this.surface != null && EglRenderer.this.eglBase != null && !EglRenderer.this.eglBase.hasSurface()) {
                if (this.surface instanceof Surface) {
                    EglRenderer.this.eglBase.createSurface((Surface)this.surface);
                } else if (this.surface instanceof SurfaceTexture) {
                    EglRenderer.this.eglBase.createSurface((SurfaceTexture)this.surface);
                } else {
                    throw new IllegalStateException("Invalid surface: " + this.surface);
                }
                EglRenderer.this.eglBase.makeCurrent();
                GLES20.glPixelStorei((int)3317, (int)1);
            }
        }
    }

    static class FrameListenerAndParams {
        public final FrameListener listener;
        public final float scale;
        public final RendererCommon.GlDrawer drawer;
        public final boolean applyFpsReduction;

        /*
         * WARNING - void declaration
         */
        public FrameListenerAndParams(FrameListener listener, float scale, RendererCommon.GlDrawer drawer, boolean applyFpsReduction) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.listener = var1_1;
            this.scale = var2_2;
            this.drawer = var3_3;
            this.applyFpsReduction = applyFpsReduction;
        }
    }

    public static interface FrameListener {
        public void onFrame(Bitmap var1);
    }
}

