/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.qnwebrtc.CalledByNative;

public class EncodedImage {
    public final ByteBuffer buffer;
    public final int encodedWidth;
    public final int encodedHeight;
    public final long captureTimeMs;
    public final long captureTimeNs;
    public final FrameType frameType;
    public final int rotation;
    public final boolean completeFrame;
    public final Integer qp;
    public final int spatialIndex;

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    private EncodedImage(ByteBuffer buffer, int encodedWidth, int encodedHeight, long captureTimeNs, FrameType frameType, int rotation, boolean completeFrame, Integer qp, int spatialIndex) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.buffer = var1_1;
        this.encodedWidth = var2_2;
        this.encodedHeight = var3_3;
        this.captureTimeMs = TimeUnit.NANOSECONDS.toMillis(captureTimeNs);
        this.captureTimeNs = captureTimeNs;
        this.frameType = frameType;
        this.rotation = rotation;
        this.completeFrame = completeFrame;
        this.qp = qp;
        this.spatialIndex = spatialIndex;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ByteBuffer buffer;
        private int encodedWidth;
        private int encodedHeight;
        private long captureTimeNs;
        private FrameType frameType;
        private int rotation;
        private boolean completeFrame;
        private Integer qp;
        private int spatialIndex;

        private Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder setBuffer(ByteBuffer buffer) {
            void var1_1;
            this.buffer = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setEncodedWidth(int encodedWidth) {
            void var1_1;
            this.encodedWidth = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setEncodedHeight(int encodedHeight) {
            void var1_1;
            this.encodedHeight = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Builder setCaptureTimeMs(long captureTimeMs) {
            void var1_1;
            this.captureTimeNs = TimeUnit.MILLISECONDS.toNanos((long)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setCaptureTimeNs(long captureTimeNs) {
            void var1_1;
            this.captureTimeNs = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setFrameType(FrameType frameType) {
            void var1_1;
            this.frameType = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setRotation(int rotation) {
            void var1_1;
            this.rotation = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setCompleteFrame(boolean completeFrame) {
            void var1_1;
            this.completeFrame = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setQp(Integer qp) {
            void var1_1;
            this.qp = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder SetSpatialIndex(int index) {
            void var1_1;
            this.spatialIndex = var1_1;
            return this;
        }

        public EncodedImage createEncodedImage() {
            return new EncodedImage(this.buffer, this.encodedWidth, this.encodedHeight, this.captureTimeNs, this.frameType, this.rotation, this.completeFrame, this.qp, this.spatialIndex);
        }
    }

    public static enum FrameType {
        EmptyFrame(0),
        VideoFrameKey(3),
        VideoFrameDelta(4);

        private final int nativeIndex;

        /*
         * WARNING - void declaration
         */
        private FrameType(int nativeIndex) {
            void var3_3;
            this.nativeIndex = var3_3;
        }

        public final int getNative() {
            return this.nativeIndex;
        }

        @CalledByNative(value="FrameType")
        static FrameType fromNativeIndex(int nativeIndex) {
            int n;
            for (FrameType frameType : FrameType.values()) {
                if (frameType.getNative() != nativeIndex) continue;
                return frameType;
            }
            throw new IllegalArgumentException("Unknown native frame type: ".concat(String.valueOf(n)));
        }
    }
}

