/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.opengl.GLES20;
import android.support.annotation.Nullable;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.qnwebrtc.GlShader;
import org.qnwebrtc.GlUtil;
import org.qnwebrtc.RendererCommon;

class GlGenericDrawer
implements RendererCommon.GlDrawer {
    private static final String INPUT_VERTEX_COORDINATE_NAME = "in_pos";
    private static final String INPUT_TEXTURE_COORDINATE_NAME = "in_tc";
    private static final String TEXTURE_MATRIX_NAME = "tex_mat";
    private static final String DEFAULT_VERTEX_SHADER_STRING = "varying vec2 tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\nuniform mat4 tex_mat;\nvoid main() {\n  gl_Position = in_pos;\n  tc = (tex_mat * in_tc).xy;\n}\n";
    private static final FloatBuffer FULL_RECTANGLE_BUFFER = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer FULL_RECTANGLE_TEXTURE_BUFFER = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private final String genericFragmentSource;
    private final String vertexShader;
    private final ShaderCallbacks shaderCallbacks;
    @Nullable
    private ShaderType currentShaderType;
    @Nullable
    private GlShader currentShader;
    private int inPosLocation;
    private int inTcLocation;
    private int texMatrixLocation;

    static String createFragmentShaderString(String genericFragmentSource, ShaderType shaderType) {
        StringBuilder stringBuilder = new StringBuilder();
        if (shaderType == ShaderType.OES) {
            stringBuilder.append("#extension GL_OES_EGL_image_external : require\n");
        }
        stringBuilder.append("precision mediump float;\n");
        stringBuilder.append("varying vec2 tc;\n");
        if (shaderType == ShaderType.YUV) {
            stringBuilder.append("uniform sampler2D y_tex;\n");
            stringBuilder.append("uniform sampler2D u_tex;\n");
            stringBuilder.append("uniform sampler2D v_tex;\n");
            stringBuilder.append("vec4 sample(vec2 p) {\n");
            stringBuilder.append("  float y = texture2D(y_tex, p).r * 1.16438;\n");
            stringBuilder.append("  float u = texture2D(u_tex, p).r;\n");
            stringBuilder.append("  float v = texture2D(v_tex, p).r;\n");
            stringBuilder.append("  return vec4(y + 1.59603 * v - 0.874202,\n");
            stringBuilder.append("    y - 0.391762 * u - 0.812968 * v + 0.531668,\n");
            stringBuilder.append("    y + 2.01723 * u - 1.08563, 1);\n");
            stringBuilder.append("}\n");
            stringBuilder.append(genericFragmentSource);
        } else {
            String string;
            String string2;
            string2 = string2 == ShaderType.OES ? "samplerExternalOES" : "sampler2D";
            stringBuilder.append("uniform ").append(string2).append(" tex;\n");
            stringBuilder.append(string.replace("sample(", "texture2D(tex, "));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public GlGenericDrawer(String genericFragmentSource, ShaderCallbacks shaderCallbacks) {
        this(DEFAULT_VERTEX_SHADER_STRING, (String)var1_1, (ShaderCallbacks)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public GlGenericDrawer(String vertexShader, String genericFragmentSource, ShaderCallbacks shaderCallbacks) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.vertexShader = var1_1;
        this.genericFragmentSource = var2_2;
        this.shaderCallbacks = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    GlShader createShader(ShaderType shaderType) {
        void var1_1;
        return new GlShader(this.vertexShader, GlGenericDrawer.createFragmentShaderString(this.genericFragmentSource, (ShaderType)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawOes(int oesTextureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.prepareShader(ShaderType.OES, (float[])var2_2, (int)var3_3, frameHeight, viewportWidth, viewportHeight);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)var1_1);
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawRgb(int textureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.prepareShader(ShaderType.RGB, (float[])var2_2, (int)var3_3, frameHeight, viewportWidth, viewportHeight);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)var1_1);
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawYuv(int[] yuvTextures, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        int n;
        void var3_4;
        void var2_2;
        this.prepareShader(ShaderType.YUV, (float[])var2_2, (int)var3_4, frameHeight, viewportWidth, viewportHeight);
        for (n = 0; n < 3; ++n) {
            GLES20.glActiveTexture((int)(33984 + n));
            GLES20.glBindTexture((int)3553, (int)yuvTextures[n]);
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        for (n = 0; n < 3; ++n) {
            GLES20.glActiveTexture((int)(33984 + n));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void prepareShader(ShaderType shaderType, float[] texMatrix, int frameWidth, int frameHeight, int viewportWidth, int viewportHeight) {
        void var3_3;
        void var2_2;
        GlShader glShader;
        if (shaderType.equals((Object)this.currentShaderType)) {
            glShader = this.currentShader;
        } else {
            void var1_1;
            this.currentShaderType = shaderType;
            if (this.currentShader != null) {
                this.currentShader.release();
            }
            this.currentShader = glShader = this.createShader(shaderType);
            glShader.useProgram();
            if (var1_1 == ShaderType.YUV) {
                GLES20.glUniform1i((int)glShader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)glShader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)glShader.getUniformLocation("v_tex"), (int)2);
            } else {
                GLES20.glUniform1i((int)glShader.getUniformLocation("tex"), (int)0);
            }
            GlUtil.checkNoGLES2Error("Create shader");
            this.shaderCallbacks.onNewShader(glShader);
            this.texMatrixLocation = glShader.getUniformLocation(TEXTURE_MATRIX_NAME);
            this.inPosLocation = glShader.getAttribLocation(INPUT_VERTEX_COORDINATE_NAME);
            this.inTcLocation = glShader.getAttribLocation(INPUT_TEXTURE_COORDINATE_NAME);
        }
        glShader.useProgram();
        GLES20.glEnableVertexAttribArray((int)this.inPosLocation);
        GLES20.glVertexAttribPointer((int)this.inPosLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_BUFFER);
        GLES20.glEnableVertexAttribArray((int)this.inTcLocation);
        GLES20.glVertexAttribPointer((int)this.inTcLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_TEXTURE_BUFFER);
        GLES20.glUniformMatrix4fv((int)this.texMatrixLocation, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        this.shaderCallbacks.onPrepareShader(glShader, (float[])var2_2, (int)var3_3, frameHeight, viewportWidth, viewportHeight);
        GlUtil.checkNoGLES2Error("Prepare shader");
    }

    @Override
    public void release() {
        if (this.currentShader != null) {
            this.currentShader.release();
            this.currentShader = null;
            this.currentShaderType = null;
        }
    }

    public static interface ShaderCallbacks {
        public void onNewShader(GlShader var1);

        public void onPrepareShader(GlShader var1, float[] var2, int var3, int var4, int var5, int var6);
    }

    public static enum ShaderType {
        OES,
        RGB,
        YUV;

    }
}

