/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.qnwebrtc.GlUtil;
import org.qnwebrtc.Logging;

public class GlShader {
    private static final String TAG = "GlShader";
    private int program;

    /*
     * WARNING - void declaration
     */
    private static int compileShader(int shaderType, String source) {
        int n = GLES20.glCreateShader((int)shaderType);
        if (n == 0) {
            throw new RuntimeException("glCreateShader() failed. GLES20 error: " + GLES20.glGetError());
        }
        GLES20.glShaderSource((int)n, (String)source);
        GLES20.glCompileShader((int)n);
        int[] nArray = new int[]{0};
        GLES20.glGetShaderiv((int)n, (int)35713, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            void var1_1;
            Logging.e(TAG, "Compile error " + GLES20.glGetShaderInfoLog((int)n) + " in shader:\n" + (String)var1_1);
            throw new RuntimeException(GLES20.glGetShaderInfoLog((int)n));
        }
        GlUtil.checkNoGLES2Error("compileShader");
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public GlShader(String vertexSource, String fragmentSource) {
        void var2_3;
        void var1_1;
        int n = GlShader.compileShader(35633, (String)var1_1);
        int n2 = GlShader.compileShader(35632, (String)var2_3);
        this.program = GLES20.glCreateProgram();
        if (this.program == 0) {
            throw new RuntimeException("glCreateProgram() failed. GLES20 error: " + GLES20.glGetError());
        }
        GLES20.glAttachShader((int)this.program, (int)n);
        GLES20.glAttachShader((int)this.program, (int)n2);
        GLES20.glLinkProgram((int)this.program);
        int[] nArray = new int[]{0};
        GLES20.glGetProgramiv((int)this.program, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] != 1) {
            Logging.e(TAG, "Could not link program: " + GLES20.glGetProgramInfoLog((int)this.program));
            throw new RuntimeException(GLES20.glGetProgramInfoLog((int)this.program));
        }
        GLES20.glDeleteShader((int)n);
        GLES20.glDeleteShader((int)n2);
        GlUtil.checkNoGLES2Error("Creating GlShader");
    }

    /*
     * WARNING - void declaration
     */
    public int getAttribLocation(String label) {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        int n = GLES20.glGetAttribLocation((int)this.program, (String)label);
        if (n < 0) {
            void var1_1;
            throw new RuntimeException("Could not locate '" + (String)var1_1 + "' in program");
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void setVertexAttribArray(String label, int dimension, FloatBuffer buffer) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setVertexAttribArray((String)var1_1, (int)var2_2, 0, (FloatBuffer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void setVertexAttribArray(String label, int dimension, int stride, FloatBuffer buffer) {
        void var3_4;
        void var2_3;
        void var1_1;
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        int n = this.getAttribLocation((String)var1_1);
        GLES20.glEnableVertexAttribArray((int)n);
        GLES20.glVertexAttribPointer((int)n, (int)var2_3, (int)5126, (boolean)false, (int)var3_4, (Buffer)buffer);
        GlUtil.checkNoGLES2Error("setVertexAttribArray");
    }

    /*
     * WARNING - void declaration
     */
    public int getUniformLocation(String label) {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        int n = GLES20.glGetUniformLocation((int)this.program, (String)label);
        if (n < 0) {
            void var1_1;
            throw new RuntimeException("Could not locate uniform '" + (String)var1_1 + "' in program");
        }
        return n;
    }

    public void useProgram() {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        GLES20.glUseProgram((int)this.program);
        GlUtil.checkNoGLES2Error("glUseProgram");
    }

    public void release() {
        Logging.d(TAG, "Deleting shader.");
        if (this.program != -1) {
            GLES20.glDeleteProgram((int)this.program);
            this.program = -1;
        }
    }
}

