/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.qnwebrtc.BitrateAdjuster;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.EglBase14;
import org.qnwebrtc.EncodedImage;
import org.qnwebrtc.GlRectDrawer;
import org.qnwebrtc.Logging;
import org.qnwebrtc.MediaCodecWrapper;
import org.qnwebrtc.MediaCodecWrapperFactory;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.VideoCodecStatus;
import org.qnwebrtc.VideoCodecType;
import org.qnwebrtc.VideoEncoder;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoFrameDrawer;
import org.qnwebrtc.YuvHelper;

@TargetApi(value=19)
class HardwareVideoEncoder
implements VideoEncoder {
    private static final String TAG = "HardwareVideoEncoder";
    private static final int VIDEO_ControlRateConstant = 2;
    private static final String KEY_BITRATE_MODE = "bitrate-mode";
    private static final int VIDEO_AVC_PROFILE_HIGH = 8;
    private static final int VIDEO_AVC_LEVEL_3 = 256;
    private static final int MAX_VIDEO_FRAMERATE = 30;
    private static final int MAX_ENCODER_Q_SIZE = 2;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private static final int ENCODER_STALL_FRAMEDROP_THRESHOLD = 60;
    private static final int DYNAMIC_BITRATE_THRESHOLD = 200000;
    private static final int RESOLUTION_ALIGNMENT_FOR_HUAWEI = 32;
    private static final int DEFAULT_RESOLUTION_ALIGNMENT = 16;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private final VideoCodecType codecType;
    private final Integer surfaceColorFormat;
    private final Integer yuvColorFormat;
    private final YuvFormat yuvFormat;
    private final Map<String, String> params;
    private final int keyFrameIntervalSec;
    private final long forcedKeyFrameNs;
    private final BitrateAdjuster bitrateAdjuster;
    private final EglBase14.Context sharedContext;
    private final GlRectDrawer textureDrawer = new GlRectDrawer();
    private final VideoFrameDrawer videoFrameDrawer = new VideoFrameDrawer();
    private final ThreadUtils.ThreadChecker encodeThreadChecker = new ThreadUtils.ThreadChecker();
    private final ThreadUtils.ThreadChecker outputThreadChecker = new ThreadUtils.ThreadChecker();
    private VideoEncoder.Callback callback;
    private boolean automaticResizeOn;
    @Nullable
    private Thread outputThread;
    private int width;
    private int height;
    private int numberOfSimulcastStreams;
    private List<VideoEncoder.SimulcastStream> simulcastStreams;
    private boolean useSurfaceMode;
    private int mFrameDrops;
    private long lastKeyFrameNs;
    private volatile int adjustedBitrate;
    private volatile boolean mNeedResetCodec;
    private volatile boolean running;
    @Nullable
    private volatile Exception shutdownException;
    private volatile boolean mReleaseTimeout;
    @Nullable
    private List<StreamCodecHolder> streamCodecHolders = new ArrayList<StreamCodecHolder>();

    /*
     * WARNING - void declaration
     */
    public HardwareVideoEncoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String codecName, VideoCodecType codecType, Integer surfaceColorFormat, Integer yuvColorFormat, Map<String, String> params, int keyFrameIntervalSec, int forceKeyFrameIntervalMs, BitrateAdjuster bitrateAdjuster, EglBase14.Context sharedContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.mediaCodecWrapperFactory = var1_1;
        this.codecName = var2_2;
        this.codecType = var3_3;
        this.surfaceColorFormat = surfaceColorFormat;
        this.yuvColorFormat = yuvColorFormat;
        this.yuvFormat = YuvFormat.valueOf(yuvColorFormat);
        this.params = params;
        this.keyFrameIntervalSec = keyFrameIntervalSec;
        this.forcedKeyFrameNs = TimeUnit.MILLISECONDS.toNanos(forceKeyFrameIntervalMs);
        this.bitrateAdjuster = bitrateAdjuster;
        this.sharedContext = sharedContext;
        this.encodeThreadChecker.detachThread();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public VideoCodecStatus initEncode(VideoEncoder.Settings settings, VideoEncoder.Callback callback) {
        void var1_1;
        void var2_2;
        this.encodeThreadChecker.checkIsOnValidThread();
        VideoCodecStatus videoCodecStatus = this.release();
        if (videoCodecStatus != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        this.callback = var2_2;
        this.automaticResizeOn = settings.automaticResizeOn;
        this.width = settings.width;
        this.height = settings.height;
        this.numberOfSimulcastStreams = settings.numberOfSimulcastStreams;
        this.simulcastStreams = settings.simulcastStreams;
        this.useSurfaceMode = this.canUseSurface();
        if (settings.startBitrate != 0 && settings.maxFramerate != 0) {
            this.bitrateAdjuster.setTargets(settings.startBitrate * 1000, settings.maxFramerate);
        }
        this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
        Logging.d(TAG, "initEncode: " + settings.startBitrate + "kbps. Fps: " + var1_1.maxFramerate + " Use surface mode: " + this.useSurfaceMode + " streams: " + this.numberOfSimulcastStreams);
        return this.initEncodersInternal();
    }

    private VideoCodecStatus initEncodersInternal() {
        this.encodeThreadChecker.checkIsOnValidThread();
        this.lastKeyFrameNs = -1L;
        for (int i2 = 0; i2 < this.numberOfSimulcastStreams; ++i2) {
            VideoCodecStatus videoCodecStatus = this.initEncodeInternal(i2);
            if (videoCodecStatus == VideoCodecStatus.OK) continue;
            return videoCodecStatus;
        }
        this.running = true;
        this.outputThreadChecker.detachThread();
        this.outputThread = this.createOutputThread();
        this.outputThread.start();
        return VideoCodecStatus.OK;
    }

    /*
     * WARNING - void declaration
     */
    private VideoCodecStatus initEncodeInternal(int idx) {
        void var1_1;
        MediaCodecWrapper mediaCodecWrapper;
        StreamCodecHolder streamCodecHolder = new StreamCodecHolder();
        EglBase14 eglBase14 = null;
        Surface surface = null;
        try {
            mediaCodecWrapper = this.mediaCodecWrapperFactory.createByCodecName(this.codecName);
        }
        catch (IOException | IllegalArgumentException exception) {
            Logging.e(TAG, "Cannot create media encoder " + this.codecName);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        int n = this.useSurfaceMode ? this.surfaceColorFormat : this.yuvColorFormat;
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)this.simulcastStreams.get((int)idx).width, (int)this.simulcastStreams.get((int)idx).height);
            mediaFormat.setInteger("bitrate", this.adjustedBitrate);
            mediaFormat.setInteger(KEY_BITRATE_MODE, 2);
            mediaFormat.setInteger("color-format", n);
            mediaFormat.setInteger("frame-rate", this.bitrateAdjuster.getCodecConfigFramerate());
            mediaFormat.setInteger("i-frame-interval", this.keyFrameIntervalSec);
            if (this.codecType == VideoCodecType.H264) {
                String string = this.params.get("profile-level-id");
                if (string == null) {
                    string = "42e01f";
                }
                switch (string) {
                    case "640c1f": {
                        mediaFormat.setInteger("profile", 8);
                        mediaFormat.setInteger("level", 256);
                        break;
                    }
                    case "42e01f": {
                        break;
                    }
                    default: {
                        Logging.w(TAG, "Unknown profile level id: ".concat(String.valueOf(string)));
                    }
                }
            }
            Logging.d(TAG, "Format: ".concat(String.valueOf(mediaFormat)));
            mediaCodecWrapper.configure(mediaFormat, null, null, 1);
            if (this.useSurfaceMode) {
                eglBase14 = EglBase.createEgl14(this.sharedContext, EglBase.CONFIG_RECORDABLE);
                surface = mediaCodecWrapper.createInputSurface();
                eglBase14.createSurface(surface);
                eglBase14.makeCurrent();
            }
            mediaCodecWrapper.start();
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            Logging.e(TAG, "initEncodeInternal failed", runtimeException);
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        streamCodecHolder.simulcastIdx = idx;
        streamCodecHolder.targetBps = this.adjustedBitrate;
        streamCodecHolder.codec = mediaCodecWrapper;
        streamCodecHolder.textureEglBase = eglBase14;
        streamCodecHolder.textureInputSurface = surface;
        streamCodecHolder.stream = this.simulcastStreams.get(idx);
        this.streamCodecHolders.add(streamCodecHolder);
        Logging.i(TAG, "init idx " + (int)var1_1 + " width " + streamCodecHolder.stream.width + " height " + streamCodecHolder.stream.height + " bitrate " + streamCodecHolder.targetBps);
        return VideoCodecStatus.OK;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public VideoCodecStatus release() {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.outputThread == null) ** GOTO lbl-1000
        this.running = false;
        if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
            Logging.e("HardwareVideoEncoder", "Media encoder release timeout");
            var1_1 = VideoCodecStatus.TIMEOUT;
            this.mReleaseTimeout = true;
        } else if (this.shutdownException != null) {
            Logging.e("HardwareVideoEncoder", "Media encoder release exception", this.shutdownException);
            var1_1 = VideoCodecStatus.ERROR;
        } else lbl-1000:
        // 2 sources

        {
            var1_1 = VideoCodecStatus.OK;
        }
        this.textureDrawer.release();
        this.videoFrameDrawer.release();
        for (var2_2 = 0; var2_2 < this.streamCodecHolders.size(); ++var2_2) {
            this.streamCodecHolders.get((int)var2_2).outputBuilders.clear();
            if (this.streamCodecHolders.get((int)var2_2).textureEglBase != null) {
                this.streamCodecHolders.get((int)var2_2).textureEglBase.release();
            }
            if (this.streamCodecHolders.get((int)var2_2).textureInputSurface == null) continue;
            this.streamCodecHolders.get((int)var2_2).textureInputSurface.release();
        }
        this.streamCodecHolders.clear();
        this.outputThread = null;
        this.encodeThreadChecker.detachThread();
        return var1_1;
    }

    @Override
    public VideoCodecStatus encode(VideoFrame videoFrame, VideoEncoder.EncodeInfo encodeInfo) {
        int n;
        Object object;
        int n2;
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.streamCodecHolders.size() == 0 || this.streamCodecHolders.get((int)0).codec == null) {
            return VideoCodecStatus.UNINITIALIZED;
        }
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        boolean bl = buffer instanceof VideoFrame.TextureBuffer;
        int n3 = videoFrame.getBuffer().getWidth();
        int n4 = videoFrame.getBuffer().getHeight();
        int n5 = n2 = this.canUseSurface() && bl ? 1 : 0;
        if (n3 != this.width || n4 != this.height || n2 != this.useSurfaceMode || this.mNeedResetCodec) {
            this.mNeedResetCodec = false;
            Logging.i(TAG, "incomig frame " + n3 + "x" + n4 + " vs " + this.width + "x" + this.height + "; incoming surface mode " + (n2 != 0) + "(texture " + bl + ") vs " + this.useSurfaceMode + "; needReset " + this.mNeedResetCodec);
            VideoCodecStatus videoCodecStatus = this.resetCodec(n3, n4, n2 != 0);
            if (videoCodecStatus != VideoCodecStatus.OK) {
                return videoCodecStatus;
            }
        }
        if (this.outputBuildersSize() > 2 * this.numberOfSimulcastStreams) {
            Logging.e(TAG, "Dropped frame, encoder queue full");
            ++this.mFrameDrops;
            if (this.mFrameDrops >= 60) {
                this.mFrameDrops = 0;
                Logging.e(TAG, "Fallback to SW encoder.");
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            return VideoCodecStatus.NO_OUTPUT;
        }
        bl = false;
        object = object.frameTypes;
        n2 = object.frameTypes.length;
        for (n = 0; n < n2; ++n) {
            if (object[n] != EncodedImage.FrameType.VideoFrameKey) continue;
            bl = true;
        }
        if (bl || this.shouldForceKeyFrame(videoFrame.getTimestampNs())) {
            this.requestKeyFrame(videoFrame.getTimestampNs());
        }
        object = VideoCodecStatus.OK;
        for (n2 = 0; n2 < this.streamCodecHolders.size(); ++n2) {
            n = this.streamCodecHolders.get((int)n2).stream.width;
            int n6 = this.streamCodecHolders.get((int)n2).stream.height;
            int n7 = n * n6 * 3 / 2;
            EncodedImage.Builder builder = EncodedImage.builder().setCaptureTimeNs(videoFrame.getTimestampNs()).setCompleteFrame(true).setEncodedWidth(n).setEncodedHeight(n6).setRotation(videoFrame.getRotation()).SetSpatialIndex(this.streamCodecHolders.get((int)n2).simulcastIdx);
            this.streamCodecHolders.get((int)n2).outputBuilders.offer(builder);
            bl = n != this.width && n6 != this.height;
            if (bl) {
                this.streamCodecHolders.get((int)n2).downscaledFrame = new VideoFrame(buffer.cropAndScale(0, 0, n3, n4, n, n6), 0, videoFrame.getTimestampNs());
            }
            object = this.useSurfaceMode ? this.encodeTextureBuffer(n2, bl ? this.streamCodecHolders.get((int)n2).downscaledFrame : videoFrame) : this.encodeByteBuffer(n2, bl ? this.streamCodecHolders.get((int)n2).downscaledFrame : videoFrame, bl ? this.streamCodecHolders.get((int)n2).downscaledFrame.getBuffer() : buffer, n7);
            if (bl) {
                this.streamCodecHolders.get((int)n2).downscaledFrame.release();
            }
            if (object == VideoCodecStatus.OK) continue;
            this.streamCodecHolders.get((int)n2).outputBuilders.pollLast();
            return object;
        }
        return object;
    }

    private int outputBuildersSize() {
        int n = 0;
        for (int i2 = 0; i2 < this.streamCodecHolders.size(); ++i2) {
            n += this.streamCodecHolders.get((int)i2).outputBuilders.size();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private VideoCodecStatus encodeTextureBuffer(int codecIdx, VideoFrame videoFrame) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            void var2_2;
            void var1_1;
            GLES20.glClear((int)16384);
            VideoFrame videoFrame2 = new VideoFrame(videoFrame.getBuffer(), 0, videoFrame.getTimestampNs());
            this.videoFrameDrawer.drawFrame(videoFrame2, this.textureDrawer, null);
            this.streamCodecHolders.get((int)var1_1).textureEglBase.swapBuffers(var2_2.getTimestampNs());
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "encodeTexture failed", runtimeException);
            return VideoCodecStatus.ERROR;
        }
        return VideoCodecStatus.OK;
    }

    /*
     * WARNING - void declaration
     */
    private VideoCodecStatus encodeByteBuffer(int codecIdx, VideoFrame videoFrame, VideoFrame.Buffer videoFrameBuffer, int bufferSize) {
        void var3_6;
        ByteBuffer byteBuffer;
        int n;
        void var2_4;
        this.encodeThreadChecker.checkIsOnValidThread();
        long l2 = (var2_4.getTimestampNs() + 500L) / 1000L;
        try {
            n = this.streamCodecHolders.get((int)codecIdx).codec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueInputBuffer failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        if (n == -1) {
            Logging.d(TAG, "Dropped frame, no input buffers available");
            return VideoCodecStatus.NO_OUTPUT;
        }
        try {
            byteBuffer = this.streamCodecHolders.get((int)codecIdx).codec.getInputBuffers()[n];
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "getInputBuffers failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        if (this.fillInputBuffer(byteBuffer, (VideoFrame.Buffer)var3_6) != VideoCodecStatus.OK) {
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        try {
            void var1_1;
            this.streamCodecHolders.get((int)var1_1).codec.queueInputBuffer(n, 0, bufferSize, l2, 0);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "queueInputBuffer failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus setRateAllocation(VideoEncoder.BitrateAllocation bitrateAllocation, int framerate) {
        int n;
        this.encodeThreadChecker.checkIsOnValidThread();
        if (!this.running) {
            return VideoCodecStatus.OK;
        }
        if (framerate > 30) {
            framerate = 30;
        }
        this.bitrateAdjuster.setTargets(bitrateAllocation.getSum(), n);
        if (this.isSupportDynamicBitrate()) {
            for (n = 0; n < this.numberOfSimulcastStreams; ++n) {
                this.streamCodecHolders.get((int)n).targetBps = bitrateAllocation.getSpatialLayerSum(n);
            }
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoEncoder.ScalingSettings getScalingSettings() {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.automaticResizeOn) {
            if (this.codecType == VideoCodecType.VP8) {
                return new VideoEncoder.ScalingSettings(29, 95);
            }
            if (this.codecType == VideoCodecType.H264) {
                return new VideoEncoder.ScalingSettings(24, 37);
            }
        }
        return VideoEncoder.ScalingSettings.OFF;
    }

    @Override
    public String getImplementationName() {
        return this.codecName;
    }

    @Override
    public int getEncoderAlignment() {
        if (HardwareVideoEncoder.isHuaWeiDevice()) {
            return 32;
        }
        return 16;
    }

    private static boolean isHuaWeiDevice() {
        String string = Build.MANUFACTURER;
        return "huawei".equalsIgnoreCase(string);
    }

    /*
     * WARNING - void declaration
     */
    private VideoCodecStatus resetCodec(int newWidth, int newHeight, boolean newUseSurfaceMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.encodeThreadChecker.checkIsOnValidThread();
        VideoCodecStatus videoCodecStatus = this.release();
        if (videoCodecStatus != VideoCodecStatus.OK) {
            return videoCodecStatus;
        }
        this.width = var1_1;
        this.height = var2_2;
        this.useSurfaceMode = var3_3;
        return this.initEncodersInternal();
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldForceKeyFrame(long presentationTimestampNs) {
        void var1_1;
        this.encodeThreadChecker.checkIsOnValidThread();
        return this.forcedKeyFrameNs > 0L && var1_1 > this.lastKeyFrameNs + this.forcedKeyFrameNs;
    }

    /*
     * WARNING - void declaration
     */
    private void requestKeyFrame(long presentationTimestampNs) {
        void var1_1;
        this.encodeThreadChecker.checkIsOnValidThread();
        for (int i2 = 0; i2 < this.streamCodecHolders.size(); ++i2) {
            MediaCodecWrapper mediaCodecWrapper = this.streamCodecHolders.get((int)i2).codec;
            try {
                Bundle bundle = new Bundle();
                bundle.putInt("request-sync", 0);
                mediaCodecWrapper.setParameters(bundle);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "requestKeyFrame failed", illegalStateException);
                return;
            }
        }
        this.lastKeyFrameNs = var1_1;
    }

    private Thread createOutputThread() {
        return new Thread(this){
            final /* synthetic */ HardwareVideoEncoder this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                while (this.this$0.running) {
                    this.this$0.deliverEncodedImages();
                }
                this.this$0.releaseCodecsOnOutputThread();
            }
        };
    }

    protected void deliverEncodedImages() {
        for (int i2 = 0; i2 < this.streamCodecHolders.size(); ++i2) {
            HardwareVideoEncoder hardwareVideoEncoder = this;
            hardwareVideoEncoder.deliverEncodedImage(hardwareVideoEncoder.streamCodecHolders.get(i2));
        }
    }

    protected void deliverEncodedImage(StreamCodecHolder holder) {
        this.outputThreadChecker.checkIsOnValidThread(this.mReleaseTimeout ? "may cause by release timeout" : null);
        MediaCodecWrapper mediaCodecWrapper = holder.codec;
        Object object = holder.outputBuilders;
        try {
            Object object2 = new MediaCodec.BufferInfo();
            int n = mediaCodecWrapper.dequeueOutputBuffer((MediaCodec.BufferInfo)object2, 100000L);
            if (n < 0) {
                return;
            }
            ByteBuffer byteBuffer = mediaCodecWrapper.getOutputBuffers()[n];
            byteBuffer.position(((MediaCodec.BufferInfo)object2).offset);
            byteBuffer.limit(((MediaCodec.BufferInfo)object2).offset + ((MediaCodec.BufferInfo)object2).size);
            if ((((MediaCodec.BufferInfo)object2).flags & 2) != 0) {
                Logging.d(TAG, "Config frame generated. Offset: " + ((MediaCodec.BufferInfo)object2).offset + ". Size: " + ((MediaCodec.BufferInfo)object2).size);
                holder.configBuffer = ByteBuffer.allocateDirect(((MediaCodec.BufferInfo)object2).size);
                holder.configBuffer.put(byteBuffer);
            } else {
                Object object3;
                boolean bl;
                this.bitrateAdjuster.reportEncodedFrame(((MediaCodec.BufferInfo)object2).size);
                if (this.adjustedBitrate != this.bitrateAdjuster.getAdjustedBitrateBps()) {
                    this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
                    if (this.isSupportDynamicBitrate()) {
                        this.updateBitrate(mediaCodecWrapper, holder.targetBps);
                    } else {
                        this.mNeedResetCodec = Math.abs(this.adjustedBitrate - holder.targetBps) >= 200000;
                    }
                }
                if (bl = (((MediaCodec.BufferInfo)object2).flags & 1) != 0) {
                    Logging.d(TAG, "Sync frame generated");
                }
                if (bl && (this.codecType == VideoCodecType.H264 || this.codecType == VideoCodecType.H265)) {
                    Logging.d(TAG, "Prepending config frame of size " + holder.configBuffer.capacity() + " to output buffer with offset " + ((MediaCodec.BufferInfo)object2).offset + ", size " + ((MediaCodec.BufferInfo)object2).size);
                    object2 = ByteBuffer.allocateDirect(((MediaCodec.BufferInfo)object2).size + holder.configBuffer.capacity());
                    holder.configBuffer.rewind();
                    ((ByteBuffer)object2).put(((StreamCodecHolder)object3).configBuffer);
                    ((ByteBuffer)object2).put(byteBuffer);
                    ((ByteBuffer)object2).rewind();
                } else {
                    object2 = byteBuffer.slice();
                }
                object3 = bl ? EncodedImage.FrameType.VideoFrameKey : EncodedImage.FrameType.VideoFrameDelta;
                object = object.poll();
                ((EncodedImage.Builder)object).setBuffer((ByteBuffer)object2).setFrameType((EncodedImage.FrameType)((Object)object3));
                object3 = ((EncodedImage.Builder)object).createEncodedImage();
                this.callback.onEncodedFrame((EncodedImage)object3, new VideoEncoder.CodecSpecificInfo());
            }
            mediaCodecWrapper.releaseOutputBuffer(n, false);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "deliverOutput failed", illegalStateException);
            return;
        }
    }

    private void releaseCodecsOnOutputThread() {
        for (int i2 = 0; i2 < this.streamCodecHolders.size(); ++i2) {
            HardwareVideoEncoder hardwareVideoEncoder = this;
            hardwareVideoEncoder.releaseCodecOnOutputThread(hardwareVideoEncoder.streamCodecHolders.get((int)i2).codec);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void releaseCodecOnOutputThread(MediaCodecWrapper codec) {
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Releasing MediaCodec on output thread");
        try {
            codec.stop();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media encoder stop failed", exception);
        }
        try {
            void var1_1;
            var1_1.release();
        }
        catch (Exception exception) {
            Logging.e(TAG, "Media encoder release failed", exception);
            this.shutdownException = exception;
        }
        Logging.d(TAG, "Release on output thread done");
    }

    /*
     * WARNING - void declaration
     */
    private VideoCodecStatus updateBitrate(MediaCodecWrapper codec, int targetBps) {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            void var1_1;
            void var2_2;
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", (int)var2_2);
            var1_1.setParameters(bundle);
            return VideoCodecStatus.OK;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "updateBitrate failed", illegalStateException);
            return VideoCodecStatus.ERROR;
        }
    }

    private boolean canUseSurface() {
        return this.sharedContext != null && this.surfaceColorFormat != null;
    }

    private boolean isSupportDynamicBitrate() {
        return this.codecName.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || this.codecName.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 21 || this.codecName.startsWith("OMX.MTK.") && Build.VERSION.SDK_INT >= 27;
    }

    /*
     * WARNING - void declaration
     */
    protected VideoCodecStatus fillInputBuffer(ByteBuffer buffer, VideoFrame.Buffer videoFrameBuffer) {
        void var2_2;
        void var1_1;
        return this.yuvFormat.fillBuffer((ByteBuffer)var1_1, (VideoFrame.Buffer)var2_2);
    }

    static enum YuvFormat {
        I420{

            /*
             * WARNING - void declaration
             */
            @Override
            final VideoCodecStatus fillBuffer(ByteBuffer dstBuffer, VideoFrame.Buffer srcBuffer) {
                VideoFrame.I420Buffer i420Buffer = srcBuffer.toI420();
                int n = (i420Buffer.getHeight() + 1) / 2;
                int n2 = (i420Buffer.getWidth() + 1) / 2;
                n = i420Buffer.getWidth() * i420Buffer.getHeight() + n2 * n * 2;
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.OK;
                if (dstBuffer.capacity() < n) {
                    Logging.e(HardwareVideoEncoder.TAG, "Expected size " + n + " with " + dstBuffer.capacity() + ", fallback !");
                    videoCodecStatus = VideoCodecStatus.FALLBACK_SOFTWARE;
                } else {
                    void var1_1;
                    YuvHelper.I420Copy(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), (ByteBuffer)var1_1, i420Buffer.getWidth(), i420Buffer.getHeight());
                }
                i420Buffer.release();
                return videoCodecStatus;
            }
        }
        ,
        NV12{

            /*
             * WARNING - void declaration
             */
            @Override
            final VideoCodecStatus fillBuffer(ByteBuffer dstBuffer, VideoFrame.Buffer srcBuffer) {
                VideoFrame.I420Buffer i420Buffer = srcBuffer.toI420();
                int n = (i420Buffer.getHeight() + 1) / 2;
                int n2 = (i420Buffer.getWidth() + 1) / 2;
                n = i420Buffer.getWidth() * i420Buffer.getHeight() + n2 * n * 2;
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.OK;
                if (dstBuffer.capacity() < n) {
                    Logging.e(HardwareVideoEncoder.TAG, "Expected size " + n + " with " + dstBuffer.capacity() + ", fallback !");
                    videoCodecStatus = VideoCodecStatus.FALLBACK_SOFTWARE;
                } else {
                    void var1_1;
                    YuvHelper.I420ToNV12(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), (ByteBuffer)var1_1, i420Buffer.getWidth(), i420Buffer.getHeight());
                }
                i420Buffer.release();
                return videoCodecStatus;
            }
        };


        abstract VideoCodecStatus fillBuffer(ByteBuffer var1, VideoFrame.Buffer var2);

        static YuvFormat valueOf(int colorFormat) {
            int n;
            switch (colorFormat) {
                case 19: {
                    return I420;
                }
                case 21: 
                case 2141391872: 
                case 2141391876: {
                    return NV12;
                }
            }
            throw new IllegalArgumentException("Unsupported colorFormat: ".concat(String.valueOf(n)));
        }
    }

    class StreamCodecHolder {
        int simulcastIdx;
        int targetBps;
        @Nullable
        VideoFrame downscaledFrame;
        @Nullable
        MediaCodecWrapper codec;
        @Nullable
        EglBase14 textureEglBase;
        @Nullable
        Surface textureInputSurface;
        VideoEncoder.SimulcastStream stream;
        @Nullable
        ByteBuffer configBuffer;
        final BlockingDeque<EncodedImage.Builder> outputBuilders = new LinkedBlockingDeque<EncodedImage.Builder>();

        private StreamCodecHolder() {
        }
    }
}

