/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.qnwebrtc.BaseBitrateAdjuster;
import org.qnwebrtc.BitrateAdjuster;
import org.qnwebrtc.DynamicBitrateAdjuster;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.EglBase14;
import org.qnwebrtc.FramerateBitrateAdjuster;
import org.qnwebrtc.H264Utils;
import org.qnwebrtc.HardwareVideoEncoder;
import org.qnwebrtc.Logging;
import org.qnwebrtc.MediaCodecUtils;
import org.qnwebrtc.MediaCodecWrapperFactoryImpl;
import org.qnwebrtc.Predicate;
import org.qnwebrtc.VideoCodecInfo;
import org.qnwebrtc.VideoCodecType;
import org.qnwebrtc.VideoEncoder;
import org.qnwebrtc.VideoEncoderFactory;

public class HardwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "HardwareVideoEncoderFactory";
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000;
    private static final List<String> H264_HW_EXCEPTION_MODELS = Arrays.asList("SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4");
    @Nullable
    private final EglBase14.Context sharedContext;
    private final boolean enableIntelVp8Encoder;
    private final boolean enableH264HighProfile;
    @Nullable
    private final Predicate<MediaCodecInfo> codecAllowedPredicate;
    public static boolean FORCE_USE_NV12_COLOR_FORMAT;

    /*
     * WARNING - void declaration
     */
    public HardwareVideoEncoderFactory(EglBase.Context sharedContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this((EglBase.Context)var1_1, (boolean)var2_2, (boolean)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HardwareVideoEncoderFactory(EglBase.Context sharedContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile, @Nullable Predicate<MediaCodecInfo> codecAllowedPredicate) {
        void var3_3;
        void var2_2;
        if (sharedContext instanceof EglBase14.Context) {
            void var1_1;
            this.sharedContext = (EglBase14.Context)var1_1;
        } else {
            Logging.w(TAG, "No shared EglBase.Context.  Encoders will not use texture mode.");
            this.sharedContext = null;
        }
        this.enableIntelVp8Encoder = var2_2;
        this.enableH264HighProfile = var3_3;
        this.codecAllowedPredicate = codecAllowedPredicate;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public HardwareVideoEncoderFactory(boolean enableIntelVp8Encoder, boolean enableH264HighProfile) {
        this(null, (boolean)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo input) {
        void var1_1;
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        VideoCodecType videoCodecType = VideoCodecType.valueOf(input.name);
        MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
        if (mediaCodecInfo == null) {
            return null;
        }
        String string = mediaCodecInfo.getName();
        Object object = videoCodecType.mimeType();
        Integer n = MediaCodecUtils.selectColorFormat(MediaCodecUtils.TEXTURE_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType((String)object));
        object = MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, mediaCodecInfo.getCapabilitiesForType((String)object));
        if (FORCE_USE_NV12_COLOR_FORMAT) {
            Logging.i(TAG, "force use NV12 in " + Build.MODEL);
            object = 21;
        }
        if (videoCodecType == VideoCodecType.H264) {
            boolean bl = H264Utils.isSameH264Profile(input.params, MediaCodecUtils.getCodecProperties(videoCodecType, true));
            boolean bl2 = H264Utils.isSameH264Profile(input.params, MediaCodecUtils.getCodecProperties(videoCodecType, false));
            if (!bl && !bl2) {
                return null;
            }
            if (bl && !this.isH264HighProfileSupported(mediaCodecInfo)) {
                return null;
            }
        }
        return new HardwareVideoEncoder(new MediaCodecWrapperFactoryImpl(), string, videoCodecType, n, (Integer)object, var1_1.params, this.getKeyFrameIntervalSec(videoCodecType), this.getForcedKeyFrameIntervalMs(videoCodecType, string), this.createBitrateAdjuster(videoCodecType, string), this.sharedContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        if (Build.VERSION.SDK_INT < 19) {
            return new VideoCodecInfo[0];
        }
        ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
        VideoCodecType[] videoCodecTypeArray = new VideoCodecType[]{VideoCodecType.VP8, VideoCodecType.VP9, VideoCodecType.H264};
        for (int i2 = 0; i2 < 3; ++i2) {
            VideoCodecType videoCodecType = videoCodecTypeArray[i2];
            MediaCodecInfo mediaCodecInfo = this.findCodecForType(videoCodecType);
            if (mediaCodecInfo == null) continue;
            String string = videoCodecType.name();
            Logging.i(TAG, "find codec " + mediaCodecInfo.getName() + " for " + string);
            if (videoCodecType == VideoCodecType.H264 && this.isH264HighProfileSupported(mediaCodecInfo)) {
                arrayList.add(new VideoCodecInfo(string, MediaCodecUtils.getCodecProperties(videoCodecType, true)));
            }
            arrayList.add(new VideoCodecInfo(string, MediaCodecUtils.getCodecProperties(videoCodecType, false)));
        }
        ArrayList<VideoCodecInfo> arrayList2 = arrayList;
        return arrayList2.toArray(new VideoCodecInfo[arrayList2.size()]);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(VideoCodecType type) {
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder() || !this.isSupportedCodec(mediaCodecInfo, type)) continue;
            return mediaCodecInfo;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type) {
        void var1_1;
        void var2_2;
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, info.getCapabilitiesForType(type.mimeType())) == null) {
            return false;
        }
        return this.isHardwareSupportedInCurrentSdk(info, (VideoCodecType)var2_2) && this.isMediaCodecAllowed((MediaCodecInfo)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo info, VideoCodecType type) {
        void var2_2;
        switch (1.$SwitchMap$org$qnwebrtc$VideoCodecType[var2_2.ordinal()]) {
            case 1: {
                return this.isHardwareSupportedInCurrentSdkVp8(info);
            }
            case 2: {
                return this.isHardwareSupportedInCurrentSdkVp9(info);
            }
            case 3: {
                return this.isHardwareSupportedInCurrentSdkH264(info);
            }
            case 4: {
                void var1_1;
                return this.isHardwareSupportedInCurrentSdkH265((MediaCodecInfo)var1_1);
            }
        }
        return false;
    }

    private boolean isHardwareSupportedInCurrentSdkVp8(MediaCodecInfo info) {
        String string = info.getName();
        return string.startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || string.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 23 || string.startsWith("OMX.Intel.") && Build.VERSION.SDK_INT >= 21 && this.enableIntelVp8Encoder;
    }

    private boolean isHardwareSupportedInCurrentSdkVp9(MediaCodecInfo info) {
        String string = info.getName();
        return (string.startsWith("OMX.qcom.") || string.startsWith("OMX.Exynos.")) && Build.VERSION.SDK_INT >= 24;
    }

    private boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo info) {
        String string;
        if (H264_HW_EXCEPTION_MODELS.contains(Build.MODEL)) {
            return false;
        }
        return (string = string.getName()).startsWith("OMX.qcom.") && Build.VERSION.SDK_INT >= 19 || string.startsWith("OMX.Exynos.") && Build.VERSION.SDK_INT >= 21 || string.startsWith("OMX.MTK.") && Build.VERSION.SDK_INT >= 19 || string.startsWith("OMX.hisi.") && Build.VERSION.SDK_INT >= 19 || string.startsWith("OMX.IMG.") && Build.VERSION.SDK_INT >= 19 || string.startsWith("OMX.sprd.") && Build.VERSION.SDK_INT >= 19;
    }

    private boolean isHardwareSupportedInCurrentSdkH265(MediaCodecInfo info) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isMediaCodecAllowed(MediaCodecInfo info) {
        void var1_1;
        if (this.codecAllowedPredicate == null) {
            return true;
        }
        return this.codecAllowedPredicate.test((MediaCodecInfo)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private int getKeyFrameIntervalSec(VideoCodecType type) {
        void var1_1;
        switch (type) {
            case VP8: 
            case VP9: {
                return 100;
            }
            case H264: 
            case H265: {
                return 20;
            }
        }
        throw new IllegalArgumentException("Unsupported VideoCodecType ".concat(String.valueOf(var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    private int getForcedKeyFrameIntervalMs(VideoCodecType type, String codecName) {
        void var2_2;
        if (type == VideoCodecType.VP8 && var2_2.startsWith("OMX.qcom.")) {
            if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
                return 15000;
            }
            if (Build.VERSION.SDK_INT == 23) {
                return 20000;
            }
            if (Build.VERSION.SDK_INT > 23) {
                return 15000;
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private BitrateAdjuster createBitrateAdjuster(VideoCodecType type, String codecName) {
        if (codecName.startsWith("OMX.Exynos.")) {
            void var1_1;
            if (var1_1 == VideoCodecType.VP8) {
                return new DynamicBitrateAdjuster();
            }
            return new FramerateBitrateAdjuster();
        }
        return new BaseBitrateAdjuster();
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        return this.enableH264HighProfile && Build.VERSION.SDK_INT > 23;
    }
}

