/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.qnwebrtc.JniCommon;
import org.qnwebrtc.RefCountDelegate;
import org.qnwebrtc.VideoFrame;

public class JavaI420Buffer
implements VideoFrame.I420Buffer {
    private final int width;
    private final int height;
    private final ByteBuffer dataY;
    private final ByteBuffer dataU;
    private final ByteBuffer dataV;
    private final int strideY;
    private final int strideU;
    private final int strideV;
    private final RefCountDelegate refCountDelegate;

    /*
     * WARNING - void declaration
     */
    private JavaI420Buffer(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataU, int strideU, ByteBuffer dataV, int strideV, @Nullable Runnable releaseCallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.width = var1_1;
        this.height = var2_2;
        this.dataY = var3_3;
        this.dataU = dataU;
        this.dataV = dataV;
        this.strideY = strideY;
        this.strideU = strideU;
        this.strideV = strideV;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    /*
     * WARNING - void declaration
     */
    private static void checkCapacity(ByteBuffer data, int width, int height, int stride) {
        int n;
        void var2_2;
        n = stride * (var2_2 - true) + n;
        if (data.capacity() < n) {
            ByteBuffer byteBuffer;
            throw new IllegalArgumentException("Buffer must be at least " + n + " bytes, but was " + byteBuffer.capacity());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static JavaI420Buffer wrap(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataU, int strideU, ByteBuffer dataV, int strideV, @Nullable Runnable releaseCallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        if (dataY == null || dataU == null || dataV == null) {
            throw new IllegalArgumentException("Data buffers cannot be null.");
        }
        if (!(dataY.isDirect() && dataU.isDirect() && dataV.isDirect())) {
            throw new IllegalArgumentException("Data buffers must be direct byte buffers.");
        }
        dataY = dataY.slice();
        dataU = dataU.slice();
        dataV = dataV.slice();
        int n2 = (width + 1) / 2;
        int n3 = (height + 1) / 2;
        JavaI420Buffer.checkCapacity(dataY, width, height, strideY);
        JavaI420Buffer.checkCapacity(dataU, n2, n3, strideU);
        JavaI420Buffer.checkCapacity(dataV, n2, n3, strideV);
        return new JavaI420Buffer(n, (int)var1_1, (ByteBuffer)var2_2, (int)var3_3, dataU, strideU, dataV, strideV, releaseCallback);
    }

    /*
     * WARNING - void declaration
     */
    public static JavaI420Buffer allocate(int width, int height) {
        int n;
        void var1_1;
        int n2 = (height + 1) / 2;
        int n3 = (width + 1) / 2;
        int n4 = 0 + width * height;
        int n5 = n4 + n3 * n2;
        ByteBuffer byteBuffer = JniCommon.nativeAllocateByteBuffer(width * height + 2 * n3 * n2);
        byteBuffer.position(0);
        byteBuffer.limit(n4);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.position(n4);
        byteBuffer.limit(n5);
        ByteBuffer byteBuffer3 = byteBuffer.slice();
        byteBuffer.position(n5);
        byteBuffer.limit(n5 + n3 * n2);
        ByteBuffer byteBuffer4 = byteBuffer.slice();
        return new JavaI420Buffer(width, (int)var1_1, byteBuffer2, n, byteBuffer3, n3, byteBuffer4, n3, () -> JniCommon.nativeFreeByteBuffer(byteBuffer));
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.dataV.slice();
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        this.retain();
        return this;
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        void var3_3;
        void var2_2;
        void var1_1;
        return JavaI420Buffer.cropAndScaleI420(this, (int)var1_1, (int)var2_2, (int)var3_3, cropHeight, scaleWidth, scaleHeight);
    }

    /*
     * WARNING - void declaration
     */
    public static VideoFrame.Buffer cropAndScaleI420(VideoFrame.I420Buffer buffer, int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        void var4_5;
        void var3_3;
        void var2_2;
        void var1_1;
        VideoFrame.I420Buffer i420Buffer;
        if (cropWidth == scaleWidth && cropHeight == scaleHeight) {
            ByteBuffer byteBuffer = buffer.getDataY();
            ByteBuffer byteBuffer2 = buffer.getDataU();
            ByteBuffer byteBuffer3 = buffer.getDataV();
            byteBuffer.position(cropX + cropY * buffer.getStrideY());
            byteBuffer2.position(cropX / 2 + cropY / 2 * buffer.getStrideU());
            byteBuffer3.position(cropX / 2 + cropY / 2 * buffer.getStrideV());
            buffer.retain();
            return JavaI420Buffer.wrap(scaleWidth, scaleHeight, byteBuffer.slice(), buffer.getStrideY(), byteBuffer2.slice(), buffer.getStrideU(), byteBuffer3.slice(), buffer.getStrideV(), buffer::release);
        }
        JavaI420Buffer javaI420Buffer = JavaI420Buffer.allocate(scaleWidth, scaleHeight);
        JavaI420Buffer.nativeCropAndScaleI420(buffer.getDataY(), buffer.getStrideY(), buffer.getDataU(), buffer.getStrideU(), buffer.getDataV(), i420Buffer.getStrideV(), (int)var1_1, (int)var2_2, (int)var3_3, (int)var4_5, javaI420Buffer.getDataY(), javaI420Buffer.getStrideY(), javaI420Buffer.getDataU(), javaI420Buffer.getStrideU(), javaI420Buffer.getDataV(), javaI420Buffer.getStrideV(), scaleWidth, scaleHeight);
        return javaI420Buffer;
    }

    private static native void nativeCropAndScaleI420(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8, int var9, ByteBuffer var10, int var11, ByteBuffer var12, int var13, ByteBuffer var14, int var15, int var16, int var17);
}

