/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.qnwebrtc.Loggable;

public class Logging {
    private static final Logger fallbackLogger = Logging.createFallbackLogger();
    private static volatile boolean loggingEnabled;
    @Nullable
    private static Loggable loggable;
    private static Severity loggableSeverity;

    private static Logger createFallbackLogger() {
        Logger logger = Logger.getLogger("org.qnwebrtc.Logging");
        logger.setLevel(Level.ALL);
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    static void injectLoggable(Loggable injectedLoggable, Severity severity) {
        if (injectedLoggable != null) {
            void var1_1;
            Loggable loggable;
            Logging.loggable = loggable;
            loggableSeverity = var1_1;
        }
    }

    static void deleteInjectedLoggable() {
        loggable = null;
    }

    public static void enableLogThreads() {
        Logging.nativeEnableLogThreads();
    }

    public static void enableLogTimeStamps() {
        Logging.nativeEnableLogTimeStamps();
    }

    @Deprecated
    public static void enableTracing(String path, EnumSet<TraceLevel> levels) {
    }

    public static synchronized void enableLogToDebugOutput(Severity severity) {
        Severity severity2;
        if (loggable != null) {
            throw new IllegalStateException("Logging to native debug output not supported while Loggable is injected. Delete the Loggable before calling this method.");
        }
        Logging.nativeEnableLogToDebugOutput(severity2.ordinal());
        loggingEnabled = true;
    }

    /*
     * WARNING - void declaration
     */
    public static void log(Severity severity, String tag, String message) {
        void var2_2;
        void var1_1;
        Object object;
        if (tag == null || message == null) {
            throw new IllegalArgumentException("Logging tag or message may not be null.");
        }
        if (loggable != null) {
            if (severity.ordinal() < loggableSeverity.ordinal()) {
                return;
            }
            loggable.onLogMessage(message, severity, tag);
            return;
        }
        if (loggingEnabled) {
            Logging.nativeLog(severity.ordinal(), tag, message);
            return;
        }
        switch (object) {
            case LS_ERROR: {
                object = Level.SEVERE;
                break;
            }
            case LS_WARNING: {
                object = Level.WARNING;
                break;
            }
            case LS_INFO: {
                object = Level.INFO;
                break;
            }
            default: {
                object = Level.FINE;
            }
        }
        fallbackLogger.log((Level)object, (String)var1_1 + ": " + (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void i(String tag, String message) {
        void var1_1;
        String string;
        Logging.log(Severity.LS_INFO, string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void d(String tag, String message) {
        void var1_1;
        String string;
        Logging.log(Severity.LS_INFO, string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void e(String tag, String message) {
        void var1_1;
        String string;
        Logging.log(Severity.LS_ERROR, string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void w(String tag, String message) {
        void var1_1;
        String string;
        Logging.log(Severity.LS_WARNING, string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void e(String tag, String message, Throwable e2) {
        void var2_2;
        String string;
        void var1_1;
        Logging.log(Severity.LS_ERROR, tag, (String)var1_1);
        Logging.log(Severity.LS_ERROR, tag, e2.toString());
        Logging.log(Severity.LS_ERROR, string, Logging.getStackTraceString((Throwable)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static void w(String tag, String message, Throwable e2) {
        void var2_2;
        String string;
        void var1_1;
        Logging.log(Severity.LS_WARNING, tag, (String)var1_1);
        Logging.log(Severity.LS_WARNING, tag, e2.toString());
        Logging.log(Severity.LS_WARNING, string, Logging.getStackTraceString((Throwable)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static void v(String tag, String message) {
        void var1_1;
        String string;
        Logging.log(Severity.LS_VERBOSE, string, (String)var1_1);
    }

    private static String getStackTraceString(Throwable e2) {
        Throwable throwable;
        if (e2 == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private static native void nativeEnableLogToDebugOutput(int var0);

    private static native void nativeEnableLogThreads();

    private static native void nativeEnableLogTimeStamps();

    private static native void nativeLog(int var0, String var1, String var2);

    public static enum Severity {
        LS_VERBOSE,
        LS_INFO,
        LS_WARNING,
        LS_ERROR,
        LS_NONE;

    }

    @Deprecated
    public static enum TraceLevel {
        TRACE_NONE(0),
        TRACE_STATEINFO(1),
        TRACE_WARNING(2),
        TRACE_ERROR(4),
        TRACE_CRITICAL(8),
        TRACE_APICALL(16),
        TRACE_DEFAULT(255),
        TRACE_MODULECALL(32),
        TRACE_MEMORY(256),
        TRACE_TIMER(512),
        TRACE_STREAM(1024),
        TRACE_DEBUG(2048),
        TRACE_INFO(4096),
        TRACE_TERSEINFO(8192),
        TRACE_ALL(65535);

        public final int level;

        /*
         * WARNING - void declaration
         */
        private TraceLevel(int level) {
            void var3_3;
            this.level = var3_3;
        }
    }
}

