/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.annotation.TargetApi;
import android.graphics.Matrix;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.CalledByNativeUnchecked;
import org.qnwebrtc.DefaultVideoEncoderFactory;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.EglBase14;
import org.qnwebrtc.GlRectDrawer;
import org.qnwebrtc.H264Utils;
import org.qnwebrtc.Logging;
import org.qnwebrtc.MediaCodecVideoDecoder;
import org.qnwebrtc.PeerConnectionFactory;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.VideoCodecInfo;
import org.qnwebrtc.VideoEncoder;
import org.qnwebrtc.VideoEncoderFactory;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoFrameDrawer;
import org.qnwebrtc.WrappedNativeVideoEncoder;

@Deprecated
@TargetApi(value=19)
public class MediaCodecVideoEncoder {
    private static final String TAG = "MediaCodecVideoEncoder";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_TIMEOUT = 0;
    private static final int BITRATE_ADJUSTMENT_FPS = 30;
    private static final int MAXIMUM_INITIAL_FPS = 30;
    private static final double BITRATE_CORRECTION_SEC = 3.0;
    private static final double BITRATE_CORRECTION_MAX_SCALE = 4.0;
    private static final int BITRATE_CORRECTION_STEPS = 20;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000L;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000L;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000L;
    @Nullable
    private static MediaCodecVideoEncoder runningInstance;
    @Nullable
    private static MediaCodecVideoEncoderErrorCallback errorCallback;
    private static int codecErrors;
    private static Set<String> hwEncoderDisabledTypes;
    @Nullable
    private static EglBase staticEglBase;
    @Nullable
    private Thread mediaCodecThread;
    @Nullable
    private MediaCodec mediaCodec;
    private ByteBuffer[] outputBuffers;
    @Nullable
    private EglBase14 eglBase;
    private int profile;
    private int width;
    private int height;
    @Nullable
    private Surface inputSurface;
    @Nullable
    private GlRectDrawer drawer;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final int VIDEO_AVCProfileHigh = 8;
    private static final int VIDEO_AVCLevel3 = 256;
    private static boolean encodeQualityMode;
    private static final MediaCodecProperties qcomVp8HwProperties;
    private static final MediaCodecProperties exynosVp8HwProperties;
    private static final MediaCodecProperties intelVp8HwProperties;
    private static final MediaCodecProperties qcomVp9HwProperties;
    private static final MediaCodecProperties exynosVp9HwProperties;
    private static final MediaCodecProperties[] vp9HwList;
    private static final MediaCodecProperties qcomH264HwProperties;
    private static final MediaCodecProperties exynosH264HwProperties;
    private static final MediaCodecProperties mediatekH264HwProperties;
    private static final MediaCodecProperties hisiH264HwProperties;
    private static final MediaCodecProperties exynosH264HighProfileHwProperties;
    private static final MediaCodecProperties[] h264HighProfileHwList;
    private static final String[] H264_HW_EXCEPTION_MODELS;
    private static final int VIDEO_ControlRateQuality = 0;
    private static final int VIDEO_ControlRateConstant = 2;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int[] supportedColorList;
    private static final int[] supportedSurfaceColorList;
    private VideoCodecType type;
    private int colorFormat;
    private BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
    private double bitrateAccumulator;
    private double bitrateAccumulatorMax;
    private double bitrateObservationTimeMs;
    private int bitrateAdjustmentScaleExp;
    private int targetBitrateBps;
    private int targetFps;
    private long forcedKeyFrameMs;
    private long lastKeyFrameMs;
    @Nullable
    private ByteBuffer configData;

    public static VideoEncoderFactory createFactory() {
        return new DefaultVideoEncoderFactory(new HwEncoderFactory());
    }

    public static void setEglContext(EglBase.Context eglContext) {
        EglBase.Context context;
        if (staticEglBase != null) {
            Logging.w(TAG, "Egl context already set.");
            staticEglBase.release();
        }
        staticEglBase = EglBase.create(context);
    }

    public static void disposeEglContext() {
        if (staticEglBase != null) {
            staticEglBase.release();
            staticEglBase = null;
        }
    }

    @Nullable
    static EglBase.Context getEglContext() {
        if (staticEglBase == null) {
            return null;
        }
        return staticEglBase.getEglBaseContext();
    }

    private static MediaCodecProperties[] vp8HwList() {
        ArrayList<MediaCodecProperties> arrayList = new ArrayList<MediaCodecProperties>();
        arrayList.add(qcomVp8HwProperties);
        arrayList.add(exynosVp8HwProperties);
        if (PeerConnectionFactory.fieldTrialsFindFullName("WebRTC-IntelVP8").equals("Enabled")) {
            arrayList.add(intelVp8HwProperties);
        }
        ArrayList<MediaCodecProperties> arrayList2 = arrayList;
        return arrayList2.toArray(new MediaCodecProperties[arrayList2.size()]);
    }

    private static final MediaCodecProperties[] h264HwList() {
        ArrayList<MediaCodecProperties> arrayList = new ArrayList<MediaCodecProperties>();
        arrayList.add(qcomH264HwProperties);
        arrayList.add(exynosH264HwProperties);
        arrayList.add(mediatekH264HwProperties);
        arrayList.add(hisiH264HwProperties);
        ArrayList<MediaCodecProperties> arrayList2 = arrayList;
        return arrayList2.toArray(new MediaCodecProperties[arrayList2.size()]);
    }

    public static void setEncodeQualityMode() {
        encodeQualityMode = true;
    }

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback errorCallback) {
        MediaCodecVideoEncoderErrorCallback mediaCodecVideoEncoderErrorCallback;
        Logging.d(TAG, "Set error callback");
        MediaCodecVideoEncoder.errorCallback = mediaCodecVideoEncoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), supportedColorList) != null;
    }

    @Nullable
    public static EncoderProperties vp8HwEncoderProperties() {
        if (hwEncoderDisabledTypes.contains(VP8_MIME_TYPE)) {
            return null;
        }
        return MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), supportedColorList);
    }

    public static boolean isVp9HwSupported() {
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, vp9HwList, supportedColorList) != null;
    }

    public static boolean isH264HwSupported() {
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, MediaCodecVideoEncoder.h264HwList(), supportedColorList) != null;
    }

    public static boolean isH264HighProfileHwSupported() {
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, h264HighProfileHwList, supportedColorList) != null;
    }

    public static boolean isVp8HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), supportedSurfaceColorList) != null;
    }

    public static boolean isVp9HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, vp9HwList, supportedSurfaceColorList) != null;
    }

    public static boolean isH264HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, MediaCodecVideoEncoder.h264HwList(), supportedSurfaceColorList) != null;
    }

    @Nullable
    private static EncoderProperties findHwEncoder(String mime, MediaCodecProperties[] supportedHwCodecProperties, int[] colorList) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        if (mime.equals(H264_MIME_TYPE) && Arrays.asList(H264_HW_EXCEPTION_MODELS).contains(Build.MODEL)) {
            Logging.w(TAG, "Model: " + Build.MODEL + " has black listed H.264 encoder.");
            return null;
        }
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            int n;
            MediaCodecInfo.CodecCapabilities codecCapabilities;
            MediaCodecInfo mediaCodecInfo = null;
            try {
                mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder codec info", illegalArgumentException);
            }
            if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder()) continue;
            String string = null;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            int n2 = stringArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!stringArray[i3].equals(mime)) continue;
                string = mediaCodecInfo.getName();
                break;
            }
            if (string == null) continue;
            Logging.v(TAG, "Found candidate encoder ".concat(String.valueOf(string)));
            boolean bl = false;
            BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
            for (MediaCodecProperties mediaCodecProperties : supportedHwCodecProperties) {
                if (!string.startsWith(mediaCodecProperties.codecPrefix)) continue;
                if (Build.VERSION.SDK_INT < mediaCodecProperties.minSdk) {
                    Logging.w(TAG, "Codec " + string + " is disabled due to SDK version " + Build.VERSION.SDK_INT);
                    continue;
                }
                if (mediaCodecProperties.bitrateAdjustmentType != BitrateAdjustmentType.NO_ADJUSTMENT) {
                    bitrateAdjustmentType = mediaCodecProperties.bitrateAdjustmentType;
                    Logging.w(TAG, "Codec " + string + " requires bitrate adjustment: " + (Object)((Object)bitrateAdjustmentType));
                }
                bl = true;
                break;
            }
            if (!bl) continue;
            try {
                codecCapabilities = mediaCodecInfo.getCapabilitiesForType(mime);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.e(TAG, "Cannot retrieve encoder capabilities", illegalArgumentException);
                continue;
            }
            int[] nArray = codecCapabilities.colorFormats;
            int n3 = codecCapabilities.colorFormats.length;
            for (n = 0; n < n3; ++n) {
                int n4 = nArray[n];
                Logging.v(TAG, "   Color: 0x" + Integer.toHexString(n4));
            }
            nArray = colorList;
            n3 = colorList.length;
            for (n = 0; n < n3; ++n) {
                int n5 = nArray[n];
                int[] nArray2 = codecCapabilities.colorFormats;
                int n6 = codecCapabilities.colorFormats.length;
                for (int i4 = 0; i4 < n6; ++i4) {
                    int n7 = nArray2[i4];
                    if (n7 != n5) continue;
                    Logging.d(TAG, "Found target encoder for mime " + mime + " : " + string + ". Color: 0x" + Integer.toHexString(n7) + ". Bitrate adjustment: " + (Object)((Object)bitrateAdjustmentType));
                    return new EncoderProperties(string, n7, bitrateAdjustmentType);
                }
            }
        }
        return null;
    }

    @CalledByNative
    MediaCodecVideoEncoder() {
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new RuntimeException("MediaCodecVideoEncoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoEncoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoEncoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoEncoder stacks trace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.d(TAG, stackTraceElement.toString());
            }
        }
    }

    @Nullable
    static MediaCodec createByCodecName(String codecName) {
        try {
            return MediaCodec.createByCodecName((String)codecName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNativeUnchecked
    boolean initEncode(VideoCodecType type, int profile, int width, int height, int kbps, int fps, boolean useSurface) {
        int n;
        EncoderProperties encoderProperties;
        String string;
        Logging.d(TAG, "Java initEncode: " + (Object)((Object)type) + ". Profile: " + profile + " : " + width + " x " + height + ". @ " + kbps + " kbps. Fps: " + fps + ". Encode from texture : " + useSurface);
        this.profile = profile;
        this.width = width;
        this.height = height;
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("Forgot to release()?");
        }
        boolean bl = false;
        if (type == VideoCodecType.VIDEO_CODEC_VP8) {
            string = VP8_MIME_TYPE;
            encoderProperties = MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, MediaCodecVideoEncoder.vp8HwList(), useSurface ? supportedSurfaceColorList : supportedColorList);
            n = 100;
        } else if (type == VideoCodecType.VIDEO_CODEC_VP9) {
            string = VP9_MIME_TYPE;
            encoderProperties = MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, vp9HwList, useSurface ? supportedSurfaceColorList : supportedColorList);
            n = 100;
        } else if (type == VideoCodecType.VIDEO_CODEC_H264) {
            string = H264_MIME_TYPE;
            encoderProperties = MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, MediaCodecVideoEncoder.h264HwList(), useSurface ? supportedSurfaceColorList : supportedColorList);
            if (n == H264Profile.CONSTRAINED_HIGH.getValue()) {
                if (MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, h264HighProfileHwList, useSurface ? supportedSurfaceColorList : supportedColorList) != null) {
                    Logging.d(TAG, "High profile H.264 encoder supported.");
                    bl = true;
                } else {
                    Logging.d(TAG, "High profile H.264 encoder requested, but not supported. Use baseline.");
                }
            }
            n = 20;
        } else {
            throw new RuntimeException("initEncode: Non-supported codec ".concat(String.valueOf((Object)type)));
        }
        if (encoderProperties == null) {
            throw new RuntimeException("Can not find HW encoder for ".concat(String.valueOf((Object)type)));
        }
        runningInstance = this;
        this.colorFormat = encoderProperties.colorFormat;
        this.bitrateAdjustmentType = encoderProperties.bitrateAdjustmentType;
        fps = this.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT ? 30 : Math.min(fps, 30);
        this.forcedKeyFrameMs = 0L;
        this.lastKeyFrameMs = -1L;
        if (type == VideoCodecType.VIDEO_CODEC_VP8 && encoderProperties.codecName.startsWith(MediaCodecVideoEncoder.qcomVp8HwProperties.codecPrefix)) {
            if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
                this.forcedKeyFrameMs = 15000L;
            } else if (Build.VERSION.SDK_INT == 23) {
                this.forcedKeyFrameMs = 20000L;
            } else if (Build.VERSION.SDK_INT > 23) {
                this.forcedKeyFrameMs = 15000L;
            }
        }
        Logging.d(TAG, "Color format: " + this.colorFormat + ". Bitrate adjustment: " + (Object)((Object)this.bitrateAdjustmentType) + ". Key frame interval: " + this.forcedKeyFrameMs + " . Initial fps: " + fps);
        this.targetBitrateBps = 1000 * kbps;
        this.targetFps = fps;
        this.bitrateAccumulatorMax = (double)this.targetBitrateBps / 8.0;
        this.bitrateAccumulator = 0.0;
        this.bitrateObservationTimeMs = 0.0;
        this.bitrateAdjustmentScaleExp = 0;
        this.mediaCodecThread = Thread.currentThread();
        try {
            void var1_1;
            void var3_3;
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)string, (int)var3_3, (int)height);
            mediaFormat.setInteger("bitrate", this.targetBitrateBps);
            if (encodeQualityMode) {
                mediaFormat.setInteger("bitrate-mode", 0);
            } else {
                mediaFormat.setInteger("bitrate-mode", 2);
            }
            mediaFormat.setInteger("color-format", encoderProperties.colorFormat);
            mediaFormat.setInteger("frame-rate", this.targetFps);
            mediaFormat.setInteger("i-frame-interval", n);
            if (bl) {
                mediaFormat.setInteger("profile", 8);
                mediaFormat.setInteger("level", 256);
            }
            Logging.d(TAG, "  Format: ".concat(String.valueOf(mediaFormat)));
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(encoderProperties.codecName);
            this.type = var1_1;
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media encoder");
                this.release();
                return false;
            }
            this.mediaCodec.configure(mediaFormat, null, null, 1);
            if (useSurface) {
                this.eglBase = EglBase.createEgl14((EglBase14.Context)MediaCodecVideoEncoder.getEglContext(), EglBase.CONFIG_RECORDABLE);
                this.inputSurface = this.mediaCodec.createInputSurface();
                this.eglBase.createSurface(this.inputSurface);
                this.drawer = new GlRectDrawer();
            }
            this.mediaCodec.start();
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            Logging.d(TAG, "Output buffers: " + this.outputBuffers.length);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initEncode failed", illegalStateException);
            this.release();
            return false;
        }
        return true;
    }

    @CalledByNativeUnchecked
    ByteBuffer[] getInputBuffers() {
        ByteBuffer[] byteBufferArray = this.mediaCodec.getInputBuffers();
        Logging.d(TAG, "Input buffers: " + byteBufferArray.length);
        return byteBufferArray;
    }

    /*
     * WARNING - void declaration
     */
    void checkKeyFrameRequired(boolean requestedKeyFrame, long presentationTimestampUs) {
        long l2 = (presentationTimestampUs + 500L) / 1000L;
        if (this.lastKeyFrameMs < 0L) {
            this.lastKeyFrameMs = l2;
        }
        boolean bl = false;
        if (!requestedKeyFrame && this.forcedKeyFrameMs > 0L && l2 > this.lastKeyFrameMs + this.forcedKeyFrameMs) {
            bl = true;
        }
        if (requestedKeyFrame || bl) {
            void var1_1;
            if (var1_1 != false) {
                Logging.d(TAG, "Sync frame request");
            } else {
                Logging.d(TAG, "Sync frame forced");
            }
            Bundle bundle = new Bundle();
            bundle.putInt("request-sync", 0);
            this.mediaCodec.setParameters(bundle);
            this.lastKeyFrameMs = l2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNativeUnchecked
    boolean encodeBuffer(boolean isKeyframe, int inputBuffer, int size, long presentationTimestampUs) {
        this.checkOnMediaCodecThread();
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            this.checkKeyFrameRequired((boolean)var1_1, presentationTimestampUs);
            this.mediaCodec.queueInputBuffer((int)var2_3, 0, (int)var3_4, presentationTimestampUs, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "encodeBuffer failed", illegalStateException);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNativeUnchecked
    boolean encodeFrame(long nativeEncoder, boolean isKeyframe, VideoFrame frame, int bufferIndex, long presentationTimestampUs) {
        this.checkOnMediaCodecThread();
        try {
            void var3_3;
            this.checkKeyFrameRequired((boolean)var3_3, presentationTimestampUs);
            VideoFrame.Buffer buffer = frame.getBuffer();
            if (buffer instanceof VideoFrame.TextureBuffer) {
                buffer = (VideoFrame.TextureBuffer)buffer;
                this.eglBase.makeCurrent();
                GLES20.glClear((int)16384);
                VideoFrameDrawer.drawTexture(this.drawer, (VideoFrame.TextureBuffer)buffer, new Matrix(), this.width, this.height, 0, 0, this.width, this.height);
                this.eglBase.swapBuffers(TimeUnit.MICROSECONDS.toNanos(presentationTimestampUs));
            } else {
                void var1_1;
                buffer = buffer.toI420();
                int n = (this.height + 1) / 2;
                ByteBuffer byteBuffer = buffer.getDataY();
                ByteBuffer byteBuffer2 = buffer.getDataU();
                ByteBuffer byteBuffer3 = buffer.getDataV();
                int n2 = buffer.getStrideY();
                int n3 = buffer.getStrideU();
                int n4 = buffer.getStrideV();
                if (byteBuffer.capacity() < n2 * this.height) {
                    throw new RuntimeException("Y-plane buffer size too small.");
                }
                if (byteBuffer2.capacity() < n3 * n) {
                    throw new RuntimeException("U-plane buffer size too small.");
                }
                if (byteBuffer3.capacity() < n4 * n) {
                    throw new RuntimeException("V-plane buffer size too small.");
                }
                MediaCodecVideoEncoder.nativeFillInputBuffer((long)var1_1, bufferIndex, byteBuffer, n2, byteBuffer2, n3, byteBuffer3, n4);
                buffer.release();
                int n5 = this.width * this.height * 3 / 2;
                this.mediaCodec.queueInputBuffer(bufferIndex, 0, n5, presentationTimestampUs, 0);
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "encodeFrame failed", runtimeException);
            return false;
        }
    }

    @CalledByNativeUnchecked
    void release() {
        Object object;
        Logging.d(TAG, "Java releaseEncoder");
        this.checkOnMediaCodecThread();
        class CaughtException {
            Exception e;
            final /* synthetic */ MediaCodecVideoEncoder this$0;

            /*
             * WARNING - void declaration
             */
            CaughtException(MediaCodecVideoEncoder this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }
        }
        CaughtException caughtException = new CaughtException(this);
        boolean bl = false;
        if (this.mediaCodec != null) {
            object = new CountDownLatch(1);
            Runnable runnable = new Runnable(this, caughtException, (CountDownLatch)object){
                final /* synthetic */ CaughtException val$caughtException;
                final /* synthetic */ CountDownLatch val$releaseDone;
                final /* synthetic */ MediaCodecVideoEncoder this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$caughtException = caughtException;
                    this.val$releaseDone = countDownLatch;
                }

                @Override
                public void run() {
                    Logging.d(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread");
                    try {
                        this.this$0.mediaCodec.stop();
                    }
                    catch (Exception exception) {
                        Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder stop failed", exception);
                    }
                    try {
                        this.this$0.mediaCodec.release();
                    }
                    catch (Exception exception) {
                        Logging.e(MediaCodecVideoEncoder.TAG, "Media encoder release failed", exception);
                        this.val$caughtException.e = exception;
                    }
                    Logging.d(MediaCodecVideoEncoder.TAG, "Java releaseEncoder on release thread done");
                    this.val$releaseDone.countDown();
                }
            };
            new Thread(runnable).start();
            if (!ThreadUtils.awaitUninterruptibly((CountDownLatch)object, 5000L)) {
                Logging.e(TAG, "Media encoder release timeout");
                bl = true;
            }
            this.mediaCodec = null;
        }
        this.mediaCodecThread = null;
        if (this.drawer != null) {
            this.drawer.release();
            this.drawer = null;
        }
        if (this.eglBase != null) {
            this.eglBase.release();
            this.eglBase = null;
        }
        if (this.inputSurface != null) {
            this.inputSurface.release();
            this.inputSurface = null;
        }
        runningInstance = null;
        if (bl) {
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
            }
            throw new RuntimeException("Media encoder release timeout.");
        }
        if (caughtException.e != null) {
            object = new RuntimeException(caughtException.e);
            ((Throwable)object).setStackTrace(ThreadUtils.concatStackTraces(caughtException.e.getStackTrace(), ((Throwable)object).getStackTrace()));
            throw object;
        }
        Logging.d(TAG, "Java releaseEncoder done");
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNativeUnchecked
    private boolean setRates(int kbps, int frameRate) {
        void var2_4;
        this.checkOnMediaCodecThread();
        int n = 1000 * kbps;
        if (this.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            this.bitrateAccumulatorMax = (double)n / 8.0;
            if (this.targetBitrateBps > 0 && n < this.targetBitrateBps) {
                this.bitrateAccumulator = this.bitrateAccumulator * (double)n / (double)this.targetBitrateBps;
            }
        }
        this.targetBitrateBps = n;
        this.targetFps = var2_4;
        if (this.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT && this.targetFps > 0) {
            n = 30 * this.targetBitrateBps / this.targetFps;
            Logging.v(TAG, "setRates: " + kbps + " -> " + n / 1000 + " kbps. Fps: " + this.targetFps);
        } else if (this.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            Logging.v(TAG, "setRates: " + kbps + " kbps. Fps: " + this.targetFps + ". ExpScale: " + this.bitrateAdjustmentScaleExp);
            if (this.bitrateAdjustmentScaleExp != 0) {
                MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
                n = (int)((double)n * mediaCodecVideoEncoder.getBitrateScale(mediaCodecVideoEncoder.bitrateAdjustmentScaleExp));
            }
        } else {
            void var1_1;
            Logging.v(TAG, "setRates: " + (int)var1_1 + " kbps. Fps: " + this.targetFps);
        }
        try {
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", n);
            this.mediaCodec.setParameters(bundle);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "setRates failed", illegalStateException);
            return false;
        }
    }

    @CalledByNativeUnchecked
    int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    @Nullable
    @CalledByNativeUnchecked
    OutputBufferInfo dequeueOutputBuffer() {
        int n;
        block10: {
            this.checkOnMediaCodecThread();
            try {
                MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
                n = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
                if (n >= 0 && (bufferInfo.flags & 2) != 0) {
                    Logging.d(TAG, "Config frame generated. Offset: " + bufferInfo.offset + ". Size: " + bufferInfo.size);
                    this.configData = ByteBuffer.allocateDirect(bufferInfo.size);
                    this.outputBuffers[n].position(bufferInfo.offset);
                    this.outputBuffers[n].limit(bufferInfo.offset + bufferInfo.size);
                    this.configData.put(this.outputBuffers[n]);
                    String string = "";
                    for (int i2 = 0; i2 < (bufferInfo.size < 8 ? bufferInfo.size : 8); ++i2) {
                        string = string + Integer.toHexString(this.configData.get(i2) & 0xFF) + " ";
                    }
                    Logging.d(TAG, string);
                    this.mediaCodec.releaseOutputBuffer(n, false);
                    n = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
                }
                if (n >= 0) {
                    ByteBuffer byteBuffer = this.outputBuffers[n].duplicate();
                    byteBuffer.position(bufferInfo.offset);
                    byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
                    this.reportEncodedFrame(bufferInfo.size);
                    boolean bl = (bufferInfo.flags & 1) != 0;
                    if (bl) {
                        Logging.d(TAG, "Sync frame generated");
                    }
                    if (bl && this.type == VideoCodecType.VIDEO_CODEC_H264) {
                        Logging.d(TAG, "Appending config frame of size " + this.configData.capacity() + " to output buffer with offset " + bufferInfo.offset + ", size " + bufferInfo.size);
                        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.configData.capacity() + bufferInfo.size);
                        this.configData.rewind();
                        byteBuffer2.put(this.configData);
                        byteBuffer2.put(byteBuffer);
                        byteBuffer2.position(0);
                        return new OutputBufferInfo(n, byteBuffer2, true, bufferInfo.presentationTimeUs);
                    }
                    return new OutputBufferInfo(n, byteBuffer.slice(), bl, bufferInfo.presentationTimeUs);
                }
                if (n == -3) {
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                    return this.dequeueOutputBuffer();
                }
                if (n == -2) {
                    return this.dequeueOutputBuffer();
                }
                if (n != -1) break block10;
                return null;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "dequeueOutputBuffer failed", illegalStateException);
                return new OutputBufferInfo(-1, null, false, -1L);
            }
        }
        throw new RuntimeException("dequeueOutputBuffer: ".concat(String.valueOf(n)));
    }

    /*
     * WARNING - void declaration
     */
    private double getBitrateScale(int bitrateAdjustmentScaleExp) {
        void var1_1;
        return Math.pow(4.0, (double)var1_1 / 20.0);
    }

    private void reportEncodedFrame(int size) {
        int n;
        if (this.targetFps == 0 || this.bitrateAdjustmentType != BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            return;
        }
        double d2 = (double)this.targetBitrateBps / (8.0 * (double)this.targetFps);
        this.bitrateAccumulator += (double)n - d2;
        this.bitrateObservationTimeMs += 1000.0 / (double)this.targetFps;
        double d3 = 3.0 * this.bitrateAccumulatorMax;
        this.bitrateAccumulator = Math.min(this.bitrateAccumulator, d3);
        this.bitrateAccumulator = Math.max(this.bitrateAccumulator, -d3);
        if (this.bitrateObservationTimeMs > 3000.0) {
            Logging.d(TAG, "Acc: " + (int)this.bitrateAccumulator + ". Max: " + (int)this.bitrateAccumulatorMax + ". ExpScale: " + this.bitrateAdjustmentScaleExp);
            n = 0;
            if (this.bitrateAccumulator > this.bitrateAccumulatorMax) {
                n = (int)(this.bitrateAccumulator / this.bitrateAccumulatorMax + 0.5);
                this.bitrateAdjustmentScaleExp -= n;
                this.bitrateAccumulator = this.bitrateAccumulatorMax;
                n = 1;
            } else if (this.bitrateAccumulator < -this.bitrateAccumulatorMax) {
                n = (int)(-this.bitrateAccumulator / this.bitrateAccumulatorMax + 0.5);
                this.bitrateAdjustmentScaleExp += n;
                this.bitrateAccumulator = -this.bitrateAccumulatorMax;
                n = 1;
            }
            if (n != 0) {
                this.bitrateAdjustmentScaleExp = Math.min(this.bitrateAdjustmentScaleExp, 20);
                this.bitrateAdjustmentScaleExp = Math.max(this.bitrateAdjustmentScaleExp, -20);
                MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
                Logging.d(TAG, "Adjusting bitrate scale to " + this.bitrateAdjustmentScaleExp + ". Value: " + mediaCodecVideoEncoder.getBitrateScale(mediaCodecVideoEncoder.bitrateAdjustmentScaleExp));
                MediaCodecVideoEncoder mediaCodecVideoEncoder2 = this;
                mediaCodecVideoEncoder2.setRates(mediaCodecVideoEncoder2.targetBitrateBps / 1000, this.targetFps);
            }
            this.bitrateObservationTimeMs = 0.0;
        }
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNativeUnchecked
    boolean releaseOutputBuffer(int index) {
        this.checkOnMediaCodecThread();
        try {
            void var1_1;
            this.mediaCodec.releaseOutputBuffer((int)var1_1, false);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "releaseOutputBuffer failed", illegalStateException);
            return false;
        }
    }

    @CalledByNative
    int getColorFormat() {
        return this.colorFormat;
    }

    @CalledByNative
    static boolean isTextureBuffer(VideoFrame.Buffer buffer) {
        return buffer instanceof VideoFrame.TextureBuffer;
    }

    private static native void nativeFillInputBuffer(long var0, int var2, ByteBuffer var3, int var4, ByteBuffer var5, int var6, ByteBuffer var7, int var8);

    private static native long nativeCreateEncoder(VideoCodecInfo var0, boolean var1);

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$100(VideoCodecInfo x0, boolean x1) {
        void var1_1;
        return MediaCodecVideoEncoder.nativeCreateEncoder(x0, (boolean)var1_1);
    }

    static {
        hwEncoderDisabledTypes = new HashSet<String>();
        qcomVp8HwProperties = new MediaCodecProperties("OMX.qcom.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosVp8HwProperties = new MediaCodecProperties("OMX.Exynos.", 23, BitrateAdjustmentType.DYNAMIC_ADJUSTMENT);
        intelVp8HwProperties = new MediaCodecProperties("OMX.Intel.", 21, BitrateAdjustmentType.NO_ADJUSTMENT);
        qcomVp9HwProperties = new MediaCodecProperties("OMX.qcom.", 24, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosVp9HwProperties = new MediaCodecProperties("OMX.Exynos.", 24, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        vp9HwList = new MediaCodecProperties[]{qcomVp9HwProperties, exynosVp9HwProperties};
        qcomH264HwProperties = new MediaCodecProperties("OMX.qcom.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosH264HwProperties = new MediaCodecProperties("OMX.Exynos.", 21, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        mediatekH264HwProperties = new MediaCodecProperties("OMX.MTK.", 27, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        hisiH264HwProperties = new MediaCodecProperties("OMX.hisi.", 19, BitrateAdjustmentType.NO_ADJUSTMENT);
        exynosH264HighProfileHwProperties = new MediaCodecProperties("OMX.Exynos.", 23, BitrateAdjustmentType.FRAMERATE_ADJUSTMENT);
        h264HighProfileHwList = new MediaCodecProperties[]{exynosH264HighProfileHwProperties};
        H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4"};
        supportedColorList = new int[]{19, 21, 2141391872, 2141391876};
        supportedSurfaceColorList = new int[]{2130708361};
    }

    static class OutputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        /*
         * WARNING - void declaration
         */
        public OutputBufferInfo(int index, ByteBuffer buffer, boolean isKeyFrame, long presentationTimestampUs) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.index = var1_1;
            this.buffer = var2_2;
            this.isKeyFrame = var3_3;
            this.presentationTimestampUs = presentationTimestampUs;
        }

        @CalledByNative(value="OutputBufferInfo")
        int getIndex() {
            return this.index;
        }

        @CalledByNative(value="OutputBufferInfo")
        ByteBuffer getBuffer() {
            return this.buffer;
        }

        @CalledByNative(value="OutputBufferInfo")
        boolean isKeyFrame() {
            return this.isKeyFrame;
        }

        @CalledByNative(value="OutputBufferInfo")
        long getPresentationTimestampUs() {
            return this.presentationTimestampUs;
        }
    }

    public static class EncoderProperties {
        public final String codecName;
        public final int colorFormat;
        public final BitrateAdjustmentType bitrateAdjustmentType;

        /*
         * WARNING - void declaration
         */
        public EncoderProperties(String codecName, int colorFormat, BitrateAdjustmentType bitrateAdjustmentType) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.codecName = var1_1;
            this.colorFormat = var2_2;
            this.bitrateAdjustmentType = var3_3;
        }
    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    static class MediaCodecProperties {
        public final String codecPrefix;
        public final int minSdk;
        public final BitrateAdjustmentType bitrateAdjustmentType;

        /*
         * WARNING - void declaration
         */
        MediaCodecProperties(String codecPrefix, int minSdk, BitrateAdjustmentType bitrateAdjustmentType) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.codecPrefix = var1_1;
            this.minSdk = var2_2;
            this.bitrateAdjustmentType = var3_3;
        }
    }

    public static enum H264Profile {
        CONSTRAINED_BASELINE(0),
        BASELINE(1),
        MAIN(2),
        CONSTRAINED_HIGH(3),
        HIGH(4);

        private final int value;

        /*
         * WARNING - void declaration
         */
        private H264Profile(int value) {
            void var3_3;
            this.value = var3_3;
        }

        public final int getValue() {
            return this.value;
        }
    }

    public static enum BitrateAdjustmentType {
        NO_ADJUSTMENT,
        FRAMERATE_ADJUSTMENT,
        DYNAMIC_ADJUSTMENT;

    }

    public static enum VideoCodecType {
        VIDEO_CODEC_UNKNOWN,
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;


        @CalledByNative(value="VideoCodecType")
        static VideoCodecType fromNativeIndex(int nativeIndex) {
            int n;
            return VideoCodecType.values()[n];
        }
    }

    static class HwEncoderFactory
    implements VideoEncoderFactory {
        private final VideoCodecInfo[] supportedHardwareCodecs = HwEncoderFactory.getSupportedHardwareCodecs();

        HwEncoderFactory() {
        }

        /*
         * WARNING - void declaration
         */
        private static boolean isSameCodec(VideoCodecInfo codecA, VideoCodecInfo codecB) {
            if (!codecA.name.equalsIgnoreCase(codecB.name)) {
                return false;
            }
            if (codecA.name.equalsIgnoreCase("H264")) {
                void var1_1;
                VideoCodecInfo videoCodecInfo;
                return H264Utils.isSameH264Profile(videoCodecInfo.params, var1_1.params);
            }
            return true;
        }

        private static boolean isCodecSupported(VideoCodecInfo[] supportedCodecs, VideoCodecInfo codec) {
            int n = supportedCodecs.length;
            for (int i2 = 0; i2 < n; ++i2) {
                VideoCodecInfo[] videoCodecInfoArray;
                if (!HwEncoderFactory.isSameCodec(videoCodecInfoArray[i2], codec)) continue;
                return true;
            }
            return false;
        }

        private static VideoCodecInfo[] getSupportedHardwareCodecs() {
            ArrayList<VideoCodecInfo> arrayList = new ArrayList<VideoCodecInfo>();
            if (MediaCodecVideoEncoder.isVp8HwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "VP8 HW Encoder supported.");
                arrayList.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
            }
            if (MediaCodecVideoEncoder.isVp9HwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "VP9 HW Encoder supported.");
                arrayList.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
            }
            if (MediaCodecVideoDecoder.isH264HighProfileHwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "H.264 High Profile HW Encoder supported.");
                arrayList.add(H264Utils.DEFAULT_H264_HIGH_PROFILE_CODEC);
            }
            if (MediaCodecVideoEncoder.isH264HwSupported()) {
                Logging.d(MediaCodecVideoEncoder.TAG, "H.264 HW Encoder supported.");
                arrayList.add(H264Utils.DEFAULT_H264_BASELINE_PROFILE_CODEC);
            }
            ArrayList<VideoCodecInfo> arrayList2 = arrayList;
            return arrayList2.toArray(new VideoCodecInfo[arrayList2.size()]);
        }

        @Override
        public VideoCodecInfo[] getSupportedCodecs() {
            return this.supportedHardwareCodecs;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public VideoEncoder createEncoder(VideoCodecInfo info) {
            void var1_1;
            if (!HwEncoderFactory.isCodecSupported(this.supportedHardwareCodecs, info)) {
                Logging.d(MediaCodecVideoEncoder.TAG, "No HW video encoder for codec " + info.name);
                return null;
            }
            Logging.d(MediaCodecVideoEncoder.TAG, "Create HW video encoder for " + info.name);
            return new WrappedNativeVideoEncoder(this, (VideoCodecInfo)var1_1){
                final /* synthetic */ VideoCodecInfo val$info;
                final /* synthetic */ HwEncoderFactory this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$info = videoCodecInfo;
                }

                @Override
                public long createNativeVideoEncoder() {
                    return MediaCodecVideoEncoder.access$100(this.val$info, staticEglBase instanceof EglBase14);
                }

                @Override
                public boolean isHardwareEncoder() {
                    return true;
                }
            };
        }
    }
}

