/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.qnwebrtc.CalledByNative;

public class MediaConstraints {
    public final List<KeyValuePair> mandatory = new ArrayList<KeyValuePair>();
    public final List<KeyValuePair> optional = new ArrayList<KeyValuePair>();

    private static String stringifyKeyValuePairList(List<KeyValuePair> list) {
        Iterator<KeyValuePair> iterator;
        StringBuilder stringBuilder = new StringBuilder("[");
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)iterator.next();
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(keyValuePair.toString());
        }
        return stringBuilder.append("]").toString();
    }

    public String toString() {
        return "mandatory: " + MediaConstraints.stringifyKeyValuePairList(this.mandatory) + ", optional: " + MediaConstraints.stringifyKeyValuePairList(this.optional);
    }

    private static String stringifyKeyValuePairListForJson(List<KeyValuePair> list) {
        Iterator<KeyValuePair> iterator;
        StringBuilder stringBuilder = new StringBuilder("{");
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)iterator.next();
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("\"").append(keyValuePair.key).append("\":\"").append(keyValuePair.value).append("\"");
        }
        return stringBuilder.append("}").toString();
    }

    public String toJsonString() {
        return "{ \"mandatory\": " + MediaConstraints.stringifyKeyValuePairListForJson(this.mandatory) + ", \"optional\": " + MediaConstraints.stringifyKeyValuePairListForJson(this.optional) + "}";
    }

    @CalledByNative
    List<KeyValuePair> getMandatory() {
        return this.mandatory;
    }

    @CalledByNative
    List<KeyValuePair> getOptional() {
        return this.optional;
    }

    public static class KeyValuePair {
        private final String key;
        private final String value;

        /*
         * WARNING - void declaration
         */
        public KeyValuePair(String key, String value) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.value = var2_2;
        }

        @CalledByNative(value="KeyValuePair")
        public String getKey() {
            return this.key;
        }

        @CalledByNative(value="KeyValuePair")
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.key + ": " + this.value;
        }

        public boolean equals(@Nullable Object other) {
            KeyValuePair keyValuePair;
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            keyValuePair = keyValuePair;
            return this.key.equals(keyValuePair.key) && this.value.equals(keyValuePair.value);
        }

        public int hashCode() {
            return this.key.hashCode() + this.value.hashCode();
        }
    }
}

