/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.ContextUtils;
import org.qnwebrtc.Logging;
import org.qnwebrtc.NetworkMonitorAutoDetect;

public class NetworkMonitor {
    private static final String TAG = "NetworkMonitor";
    private final ArrayList<Long> nativeNetworkObservers;
    private final ArrayList<NetworkObserver> networkObservers;
    private final Object autoDetectLock = new Object();
    @Nullable
    private NetworkMonitorAutoDetect autoDetect;
    private int numObservers = 0;
    private volatile NetworkMonitorAutoDetect.ConnectionType currentConnectionType;

    private NetworkMonitor() {
        this.nativeNetworkObservers = new ArrayList();
        this.networkObservers = new ArrayList();
        this.currentConnectionType = NetworkMonitorAutoDetect.ConnectionType.CONNECTION_UNKNOWN;
    }

    @Deprecated
    public static void init(Context context) {
    }

    @CalledByNative
    public static NetworkMonitor getInstance() {
        return InstanceHolder.instance;
    }

    private static void assertIsTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected to be true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void startMonitoring(Context applicationContext) {
        Object object = this.autoDetectLock;
        synchronized (object) {
            ++this.numObservers;
            if (this.autoDetect == null) {
                void var1_1;
                this.autoDetect = this.createAutoDetect((Context)var1_1);
            }
            this.currentConnectionType = NetworkMonitorAutoDetect.getConnectionType(this.autoDetect.getCurrentNetworkState());
            return;
        }
    }

    @Deprecated
    public void startMonitoring() {
        this.startMonitoring(ContextUtils.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @CalledByNative
    private void startMonitoring(@Nullable Context applicationContext, long nativeObserver) {
        void var2_2;
        ArrayList<Long> arrayList;
        Logging.d(TAG, "Start monitoring with native observer ".concat(String.valueOf(nativeObserver)));
        this.startMonitoring((Context)(applicationContext != null ? arrayList : ContextUtils.getApplicationContext()));
        arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            this.nativeNetworkObservers.add(nativeObserver);
        }
        this.updateObserverActiveNetworkList((long)var2_2);
        NetworkMonitor networkMonitor = this;
        networkMonitor.notifyObserversOfConnectionTypeChange(networkMonitor.currentConnectionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoring() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            if (--this.numObservers == 0) {
                this.autoDetect.destroy();
                this.autoDetect = null;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @CalledByNative
    private void stopMonitoring(long nativeObserver) {
        Logging.d(TAG, "Stop monitoring with native observer ".concat(String.valueOf(nativeObserver)));
        this.stopMonitoring();
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            void var1_1;
            this.nativeNetworkObservers.remove((long)var1_1);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean networkBindingSupported() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect != null && this.autoDetect.supportNetworkCallback();
        }
    }

    @CalledByNative
    private static int androidSdkInt() {
        return Build.VERSION.SDK_INT;
    }

    private NetworkMonitorAutoDetect.ConnectionType getCurrentConnectionType() {
        return this.currentConnectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentDefaultNetId() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect == null ? -1L : this.autoDetect.getDefaultNetId();
        }
    }

    /*
     * WARNING - void declaration
     */
    private NetworkMonitorAutoDetect createAutoDetect(Context appContext) {
        void var1_1;
        return new NetworkMonitorAutoDetect(new NetworkMonitorAutoDetect.Observer(this){
            final /* synthetic */ NetworkMonitor this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType newConnectionType) {
                void var1_1;
                NetworkMonitor.access$100(this.this$0, (NetworkMonitorAutoDetect.ConnectionType)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInfo) {
                void var1_1;
                NetworkMonitor.access$200(this.this$0, (NetworkMonitorAutoDetect.NetworkInformation)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onNetworkDisconnect(long networkHandle) {
                void var1_1;
                NetworkMonitor.access$300(this.this$0, (long)var1_1);
            }
        }, (Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void updateCurrentConnectionType(NetworkMonitorAutoDetect.ConnectionType newConnectionType) {
        void var1_1;
        this.currentConnectionType = newConnectionType;
        this.notifyObserversOfConnectionTypeChange((NetworkMonitorAutoDetect.ConnectionType)var1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObserversOfConnectionTypeChange(NetworkMonitorAutoDetect.ConnectionType newConnectionType) {
        ArrayList<NetworkObserver> arrayList;
        for (Long object2 : this.getNativeNetworkObserversSync()) {
            this.nativeNotifyConnectionTypeChanged(object2);
        }
        ArrayList<NetworkObserver> arrayList2 = this.networkObservers;
        synchronized (arrayList2) {
            arrayList = new ArrayList<NetworkObserver>(this.networkObservers);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((NetworkObserver)iterator.next()).onConnectionTypeChanged(newConnectionType);
        }
    }

    private void notifyObserversOfNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInfo) {
        for (Long l2 : this.getNativeNetworkObserversSync()) {
            this.nativeNotifyOfNetworkConnect(l2, networkInfo);
        }
    }

    private void notifyObserversOfNetworkDisconnect(long networkHandle) {
        for (Long l2 : this.getNativeNetworkObserversSync()) {
            this.nativeNotifyOfNetworkDisconnect(l2, networkHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateObserverActiveNetworkList(long nativeObserver) {
        NetworkMonitorAutoDetect.NetworkInformation[] networkInformationArray = this.autoDetectLock;
        synchronized (this.autoDetectLock) {
            void var1_1;
            List<NetworkMonitorAutoDetect.NetworkInformation> list = this.autoDetect == null ? null : this.autoDetect.getActiveNetworkList();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (list == null || list.size() == 0) {
                return;
            }
            networkInformationArray = new NetworkMonitorAutoDetect.NetworkInformation[list.size()];
            networkInformationArray = list.toArray(networkInformationArray);
            this.nativeNotifyOfActiveNetworkList((long)var1_1, networkInformationArray);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getNativeNetworkObserversSync() {
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            return new ArrayList<Long>(this.nativeNetworkObservers);
        }
    }

    @Deprecated
    public static void addNetworkObserver(NetworkObserver observer) {
        NetworkObserver networkObserver;
        NetworkMonitor.getInstance().addObserver(networkObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addObserver(NetworkObserver observer) {
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            void var1_1;
            this.networkObservers.add((NetworkObserver)var1_1);
            return;
        }
    }

    @Deprecated
    public static void removeNetworkObserver(NetworkObserver observer) {
        NetworkObserver networkObserver;
        NetworkMonitor.getInstance().removeObserver(networkObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeObserver(NetworkObserver observer) {
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            void var1_1;
            this.networkObservers.remove(var1_1);
            return;
        }
    }

    public static boolean isOnline() {
        return NetworkMonitor.getInstance().getCurrentConnectionType() != NetworkMonitorAutoDetect.ConnectionType.CONNECTION_NONE;
    }

    private native void nativeNotifyConnectionTypeChanged(long var1);

    private native void nativeNotifyOfNetworkConnect(long var1, NetworkMonitorAutoDetect.NetworkInformation var3);

    private native void nativeNotifyOfNetworkDisconnect(long var1, long var3);

    private native void nativeNotifyOfActiveNetworkList(long var1, NetworkMonitorAutoDetect.NetworkInformation[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    NetworkMonitorAutoDetect getNetworkMonitorAutoDetect() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumObservers() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.numObservers;
        }
    }

    static NetworkMonitorAutoDetect createAndSetAutoDetectForTest(Context context) {
        Object object;
        NetworkMonitor networkMonitor = NetworkMonitor.getInstance();
        object = networkMonitor.createAutoDetect((Context)object);
        networkMonitor.autoDetect = object;
        return networkMonitor.autoDetect;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(NetworkMonitor x0, NetworkMonitorAutoDetect.ConnectionType x1) {
        void var1_1;
        x0.updateCurrentConnectionType((NetworkMonitorAutoDetect.ConnectionType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(NetworkMonitor x0, NetworkMonitorAutoDetect.NetworkInformation x1) {
        void var1_1;
        x0.notifyObserversOfNetworkConnect((NetworkMonitorAutoDetect.NetworkInformation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(NetworkMonitor x0, long x1) {
        void var1_1;
        x0.notifyObserversOfNetworkDisconnect((long)var1_1);
    }

    static class InstanceHolder {
        static final NetworkMonitor instance = new NetworkMonitor();

        private InstanceHolder() {
        }
    }

    public static interface NetworkObserver {
        public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType var1);
    }
}

