/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiInfo;
import android.net.wifi.p2p.WifiP2pGroup;
import android.os.Build;
import android.support.annotation.Nullable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.Logging;
import org.qnwebrtc.PeerConnectionFactory;

public class NetworkMonitorAutoDetect
extends BroadcastReceiver {
    public static final int NETWORK_TYPE_NR = 20;
    static final long INVALID_NET_ID = -1L;
    private static final String TAG = "NetworkMonitorAutoDetect";
    private final Observer observer;
    private final IntentFilter intentFilter;
    private final Context context;
    @Nullable
    private final ConnectivityManager.NetworkCallback mobileNetworkCallback;
    @Nullable
    private final ConnectivityManager.NetworkCallback allNetworkCallback;
    private ConnectivityManagerDelegate connectivityManagerDelegate;
    private WifiManagerDelegate wifiManagerDelegate;
    private WifiDirectManagerDelegate wifiDirectManagerDelegate;
    private boolean isRegistered;
    private ConnectionType connectionType;
    private String wifiSSID;

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"NewApi"})
    public NetworkMonitorAutoDetect(Observer observer, Context context) {
        ConnectivityManager.NetworkCallback networkCallback;
        this.observer = observer;
        this.context = context;
        this.connectivityManagerDelegate = new ConnectivityManagerDelegate(context);
        this.wifiManagerDelegate = new WifiManagerDelegate(context);
        NetworkState networkState = this.connectivityManagerDelegate.getNetworkState();
        this.connectionType = NetworkMonitorAutoDetect.getConnectionType(networkState);
        this.wifiSSID = this.getWifiSSID(networkState);
        this.intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        if (PeerConnectionFactory.fieldTrialsFindFullName("IncludeWifiDirect").equals("Enabled")) {
            void var2_2;
            this.wifiDirectManagerDelegate = new WifiDirectManagerDelegate((Observer)networkCallback, (Context)var2_2);
        }
        this.registerReceiver();
        if (this.connectivityManagerDelegate.supportNetworkCallback()) {
            networkCallback = new ConnectivityManager.NetworkCallback();
            try {
                this.connectivityManagerDelegate.requestMobileNetwork(networkCallback);
            }
            catch (SecurityException securityException) {
                Logging.w(TAG, "Unable to obtain permission to request a cellular network.");
                networkCallback = null;
            }
            this.mobileNetworkCallback = networkCallback;
            this.allNetworkCallback = new SimpleNetworkCallback();
            this.connectivityManagerDelegate.registerNetworkCallback(this.allNetworkCallback);
            return;
        }
        this.mobileNetworkCallback = null;
        this.allNetworkCallback = null;
    }

    public boolean supportNetworkCallback() {
        return this.connectivityManagerDelegate.supportNetworkCallback();
    }

    /*
     * WARNING - void declaration
     */
    void setConnectivityManagerDelegateForTests(ConnectivityManagerDelegate delegate) {
        void var1_1;
        this.connectivityManagerDelegate = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void setWifiManagerDelegateForTests(WifiManagerDelegate delegate) {
        void var1_1;
        this.wifiManagerDelegate = var1_1;
    }

    boolean isReceiverRegisteredForTesting() {
        return this.isRegistered;
    }

    @Nullable
    List<NetworkInformation> getActiveNetworkList() {
        List<NetworkInformation> list = this.connectivityManagerDelegate.getActiveNetworkList();
        if (list == null) {
            return null;
        }
        list = new ArrayList<NetworkInformation>(list);
        if (this.wifiDirectManagerDelegate != null) {
            ((ArrayList)list).addAll(this.wifiDirectManagerDelegate.getActiveNetworkList());
        }
        return list;
    }

    public void destroy() {
        if (this.allNetworkCallback != null) {
            this.connectivityManagerDelegate.releaseCallback(this.allNetworkCallback);
        }
        if (this.mobileNetworkCallback != null) {
            this.connectivityManagerDelegate.releaseCallback(this.mobileNetworkCallback);
        }
        if (this.wifiDirectManagerDelegate != null) {
            this.wifiDirectManagerDelegate.release();
        }
        this.unregisterReceiver();
    }

    private void registerReceiver() {
        if (this.isRegistered) {
            return;
        }
        this.isRegistered = true;
        NetworkMonitorAutoDetect networkMonitorAutoDetect = this;
        this.context.registerReceiver((BroadcastReceiver)networkMonitorAutoDetect, networkMonitorAutoDetect.intentFilter);
    }

    private void unregisterReceiver() {
        if (!this.isRegistered) {
            return;
        }
        this.isRegistered = false;
        this.context.unregisterReceiver((BroadcastReceiver)this);
    }

    public NetworkState getCurrentNetworkState() {
        return this.connectivityManagerDelegate.getNetworkState();
    }

    public long getDefaultNetId() {
        return this.connectivityManagerDelegate.getDefaultNetId();
    }

    /*
     * WARNING - void declaration
     */
    private static ConnectionType getConnectionType(boolean isConnected, int networkType, int networkSubtype) {
        void var1_1;
        if (!isConnected) {
            return ConnectionType.CONNECTION_NONE;
        }
        switch (var1_1) {
            case 9: {
                return ConnectionType.CONNECTION_ETHERNET;
            }
            case 1: {
                return ConnectionType.CONNECTION_WIFI;
            }
            case 6: {
                return ConnectionType.CONNECTION_4G;
            }
            case 7: {
                return ConnectionType.CONNECTION_BLUETOOTH;
            }
            case 0: {
                void var2_2;
                switch (var2_2) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return ConnectionType.CONNECTION_2G;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return ConnectionType.CONNECTION_3G;
                    }
                    case 13: {
                        return ConnectionType.CONNECTION_4G;
                    }
                    case 20: {
                        return ConnectionType.CONNECTION_5G;
                    }
                }
                return ConnectionType.CONNECTION_UNKNOWN_CELLULAR;
            }
            case 17: {
                return ConnectionType.CONNECTION_VPN;
            }
        }
        return ConnectionType.CONNECTION_UNKNOWN;
    }

    public static ConnectionType getConnectionType(NetworkState networkState) {
        NetworkState networkState2;
        return NetworkMonitorAutoDetect.getConnectionType(networkState.isConnected(), networkState.getNetworkType(), networkState2.getNetworkSubType());
    }

    private static ConnectionType getUnderlyingConnectionTypeForVpn(NetworkState networkState) {
        NetworkState networkState2;
        if (networkState.getNetworkType() != 17) {
            return ConnectionType.CONNECTION_NONE;
        }
        return NetworkMonitorAutoDetect.getConnectionType(networkState.isConnected(), networkState.getUnderlyingNetworkTypeForVpn(), networkState2.getUnderlyingNetworkSubtypeForVpn());
    }

    private String getWifiSSID(NetworkState networkState) {
        if (NetworkMonitorAutoDetect.getConnectionType(networkState) != ConnectionType.CONNECTION_WIFI) {
            return "";
        }
        return this.wifiManagerDelegate.getWifiSSID();
    }

    /*
     * WARNING - void declaration
     */
    public void onReceive(Context context, Intent intent) {
        void var2_2;
        NetworkState networkState = this.getCurrentNetworkState();
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(var2_2.getAction())) {
            this.connectionTypeChanged(networkState);
        }
    }

    private void connectionTypeChanged(NetworkState networkState) {
        String string;
        ConnectionType connectionType = NetworkMonitorAutoDetect.getConnectionType(networkState);
        string = this.getWifiSSID((NetworkState)((Object)string));
        if (connectionType == this.connectionType && string.equals(this.wifiSSID)) {
            return;
        }
        this.connectionType = connectionType;
        this.wifiSSID = string;
        Logging.d(TAG, "Network connectivity changed, type is: " + (Object)((Object)this.connectionType));
        this.observer.onConnectionTypeChanged(connectionType);
    }

    @SuppressLint(value={"NewApi"})
    private static long networkToNetId(Network network) {
        Network network2;
        if (Build.VERSION.SDK_INT >= 23) {
            return network.getNetworkHandle();
        }
        return Integer.parseInt(network2.toString());
    }

    public static interface Observer {
        public void onConnectionTypeChanged(ConnectionType var1);

        public void onNetworkConnect(NetworkInformation var1);

        public void onNetworkDisconnect(long var1);
    }

    static class WifiDirectManagerDelegate
    extends BroadcastReceiver {
        private static final int WIFI_P2P_NETWORK_HANDLE = 0;
        private final Context context;
        private final Observer observer;
        @Nullable
        private NetworkInformation wifiP2pNetworkInfo;

        /*
         * WARNING - void declaration
         */
        WifiDirectManagerDelegate(Observer observer, Context context) {
            void var2_2;
            IntentFilter intentFilter;
            this.context = context;
            this.observer = intentFilter;
            intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.wifi.p2p.STATE_CHANGED");
            intentFilter.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
            var2_2.registerReceiver((BroadcastReceiver)this, intentFilter);
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"InlinedApi"})
        public void onReceive(Context context, Intent intent) {
            if ("android.net.wifi.p2p.CONNECTION_STATE_CHANGE".equals(intent.getAction())) {
                WifiP2pGroup wifiP2pGroup = (WifiP2pGroup)intent.getParcelableExtra("p2pGroupInfo");
                this.onWifiP2pGroupChange(wifiP2pGroup);
                return;
            }
            if ("android.net.wifi.p2p.STATE_CHANGED".equals(intent.getAction())) {
                void var2_3;
                int n = var2_3.getIntExtra("wifi_p2p_state", 0);
                this.onWifiP2pStateChange(n);
            }
        }

        public void release() {
            this.context.unregisterReceiver((BroadcastReceiver)this);
        }

        public List<NetworkInformation> getActiveNetworkList() {
            if (this.wifiP2pNetworkInfo != null) {
                return Collections.singletonList(this.wifiP2pNetworkInfo);
            }
            return Collections.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        private void onWifiP2pGroupChange(@Nullable WifiP2pGroup wifiP2pGroup) {
            void var1_1;
            Object object;
            if (wifiP2pGroup == null || wifiP2pGroup.getInterface() == null) {
                return;
            }
            try {
                object = NetworkInterface.getByName(wifiP2pGroup.getInterface());
            }
            catch (SocketException socketException) {
                Logging.e(NetworkMonitorAutoDetect.TAG, "Unable to get WifiP2p network interface", socketException);
                return;
            }
            object = Collections.list(((NetworkInterface)object).getInetAddresses());
            IPAddress[] iPAddressArray = new IPAddress[object.size()];
            for (int i2 = 0; i2 < object.size(); ++i2) {
                iPAddressArray[i2] = new IPAddress(((InetAddress)object.get(i2)).getAddress());
            }
            this.wifiP2pNetworkInfo = new NetworkInformation(var1_1.getInterface(), ConnectionType.CONNECTION_WIFI, ConnectionType.CONNECTION_NONE, 0L, iPAddressArray);
            this.observer.onNetworkConnect(this.wifiP2pNetworkInfo);
        }

        private void onWifiP2pStateChange(int state) {
            if (state == 1) {
                this.wifiP2pNetworkInfo = null;
                this.observer.onNetworkDisconnect(0L);
            }
        }
    }

    static class WifiManagerDelegate {
        @Nullable
        private final Context context;

        /*
         * WARNING - void declaration
         */
        WifiManagerDelegate(Context context) {
            void var1_1;
            this.context = var1_1;
        }

        WifiManagerDelegate() {
            this.context = null;
        }

        String getWifiSSID() {
            Object object = this.context.registerReceiver(null, new IntentFilter("android.net.wifi.STATE_CHANGE"));
            if (object != null && (object = (WifiInfo)object.getParcelableExtra("wifiInfo")) != null && (object = object.getSSID()) != null) {
                return object;
            }
            return "";
        }
    }

    static class ConnectivityManagerDelegate {
        @Nullable
        private final ConnectivityManager connectivityManager;

        /*
         * WARNING - void declaration
         */
        ConnectivityManagerDelegate(Context context) {
            void var1_1;
            this.connectivityManager = (ConnectivityManager)var1_1.getSystemService("connectivity");
        }

        ConnectivityManagerDelegate() {
            this.connectivityManager = null;
        }

        NetworkState getNetworkState() {
            if (this.connectivityManager == null) {
                return new NetworkState(false, -1, -1, -1, -1);
            }
            ConnectivityManagerDelegate connectivityManagerDelegate = this;
            return connectivityManagerDelegate.getNetworkState(connectivityManagerDelegate.connectivityManager.getActiveNetworkInfo());
        }

        @SuppressLint(value={"NewApi"})
        NetworkState getNetworkState(@Nullable Network network) {
            NetworkCapabilities networkCapabilities;
            if (network == null || this.connectivityManager == null) {
                return new NetworkState(false, -1, -1, -1, -1);
            }
            NetworkInfo networkInfo = this.connectivityManager.getNetworkInfo(network);
            if (networkInfo == null) {
                Logging.w(NetworkMonitorAutoDetect.TAG, "Couldn't retrieve information from network " + network.toString());
                return new NetworkState(false, -1, -1, -1, -1);
            }
            if (networkInfo.getType() != 17) {
                if ((networkCapabilities = this.connectivityManager.getNetworkCapabilities((Network)networkCapabilities)) == null || !networkCapabilities.hasTransport(4)) {
                    return this.getNetworkState(networkInfo);
                }
                return new NetworkState(networkInfo.isConnected(), 17, -1, networkInfo.getType(), networkInfo.getSubtype());
            }
            if (networkInfo.getType() == 17) {
                if (Build.VERSION.SDK_INT >= 23 && networkCapabilities.equals((Object)this.connectivityManager.getActiveNetwork()) && (networkCapabilities = this.connectivityManager.getActiveNetworkInfo()) != null && networkCapabilities.getType() != 17) {
                    return new NetworkState(networkInfo.isConnected(), 17, -1, networkCapabilities.getType(), networkCapabilities.getSubtype());
                }
                return new NetworkState(networkInfo.isConnected(), 17, -1, -1, -1);
            }
            return this.getNetworkState(networkInfo);
        }

        /*
         * WARNING - void declaration
         */
        private NetworkState getNetworkState(@Nullable NetworkInfo networkInfo) {
            void var1_1;
            if (networkInfo == null || !networkInfo.isConnected()) {
                return new NetworkState(false, -1, -1, -1, -1);
            }
            return new NetworkState(true, networkInfo.getType(), var1_1.getSubtype(), -1, -1);
        }

        @SuppressLint(value={"NewApi"})
        Network[] getAllNetworks() {
            if (this.connectivityManager == null) {
                return new Network[0];
            }
            return this.connectivityManager.getAllNetworks();
        }

        @Nullable
        List<NetworkInformation> getActiveNetworkList() {
            if (!this.supportNetworkCallback()) {
                return null;
            }
            ArrayList<NetworkInformation> arrayList = new ArrayList<NetworkInformation>();
            for (Object object : this.getAllNetworks()) {
                if ((object = this.networkToInfo((Network)object)) == null) continue;
                arrayList.add((NetworkInformation)object);
            }
            return arrayList;
        }

        @SuppressLint(value={"NewApi"})
        long getDefaultNetId() {
            if (!this.supportNetworkCallback()) {
                return -1L;
            }
            NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return -1L;
            }
            Network[] networkArray = this.getAllNetworks();
            long l2 = -1L;
            for (Network network : networkArray) {
                NetworkInfo networkInfo2;
                if (!this.hasInternetCapability(network) || (networkInfo2 = this.connectivityManager.getNetworkInfo(network)) == null || networkInfo2.getType() != networkInfo.getType()) continue;
                if (l2 != -1L) {
                    throw new RuntimeException("Multiple connected networks of same type are not supported.");
                }
                l2 = NetworkMonitorAutoDetect.networkToNetId(network);
            }
            return l2;
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"NewApi"})
        @Nullable
        private NetworkInformation networkToInfo(@Nullable Network network) {
            void var1_1;
            if (network == null || this.connectivityManager == null) {
                return null;
            }
            LinkProperties linkProperties = this.connectivityManager.getLinkProperties(network);
            if (linkProperties == null) {
                Logging.w(NetworkMonitorAutoDetect.TAG, "Detected unknown network: " + network.toString());
                return null;
            }
            if (linkProperties.getInterfaceName() == null) {
                Logging.w(NetworkMonitorAutoDetect.TAG, "Null interface name for network " + network.toString());
                return null;
            }
            Object object = this.getNetworkState(network);
            ConnectionType connectionType = NetworkMonitorAutoDetect.getConnectionType((NetworkState)object);
            if (connectionType == ConnectionType.CONNECTION_NONE) {
                Logging.d(NetworkMonitorAutoDetect.TAG, "Network " + network.toString() + " is disconnected");
                return null;
            }
            if (connectionType == ConnectionType.CONNECTION_UNKNOWN || connectionType == ConnectionType.CONNECTION_UNKNOWN_CELLULAR) {
                Logging.d(NetworkMonitorAutoDetect.TAG, "Network " + network.toString() + " connection type is " + (Object)((Object)connectionType) + " because it has type " + ((NetworkState)object).getNetworkType() + " and subtype " + ((NetworkState)object).getNetworkSubType());
            }
            object = NetworkMonitorAutoDetect.getUnderlyingConnectionTypeForVpn((NetworkState)object);
            return new NetworkInformation(linkProperties.getInterfaceName(), connectionType, (ConnectionType)((Object)object), NetworkMonitorAutoDetect.networkToNetId((Network)var1_1), this.getIPAddresses(linkProperties));
        }

        @SuppressLint(value={"NewApi"})
        boolean hasInternetCapability(Network network) {
            NetworkCapabilities networkCapabilities;
            if (this.connectivityManager == null) {
                return false;
            }
            return (networkCapabilities = this.connectivityManager.getNetworkCapabilities((Network)networkCapabilities)) != null && networkCapabilities.hasCapability(12);
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"NewApi"})
        public void registerNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
            void var1_1;
            this.connectivityManager.registerNetworkCallback(new NetworkRequest.Builder().addCapability(12).build(), (ConnectivityManager.NetworkCallback)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"NewApi"})
        public void requestMobileNetwork(ConnectivityManager.NetworkCallback networkCallback) {
            void var1_1;
            NetworkRequest.Builder builder = new NetworkRequest.Builder();
            builder.addCapability(12).addTransportType(0);
            this.connectivityManager.requestNetwork(builder.build(), (ConnectivityManager.NetworkCallback)var1_1);
        }

        @SuppressLint(value={"NewApi"})
        IPAddress[] getIPAddresses(LinkProperties linkProperties) {
            Iterator iterator;
            IPAddress[] iPAddressArray = new IPAddress[linkProperties.getLinkAddresses().size()];
            int n = 0;
            for (LinkAddress linkAddress : iterator.getLinkAddresses()) {
                iPAddressArray[n] = new IPAddress(linkAddress.getAddress().getAddress());
                ++n;
            }
            return iPAddressArray;
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"NewApi"})
        public void releaseCallback(ConnectivityManager.NetworkCallback networkCallback) {
            if (this.supportNetworkCallback()) {
                void var1_1;
                Logging.d(NetworkMonitorAutoDetect.TAG, "Unregister network callback");
                this.connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)var1_1);
            }
        }

        public boolean supportNetworkCallback() {
            return Build.VERSION.SDK_INT >= 21 && this.connectivityManager != null;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ NetworkInformation access$300(ConnectivityManagerDelegate x0, Network x1) {
            void var1_1;
            return x0.networkToInfo((Network)var1_1);
        }
    }

    @SuppressLint(value={"NewApi"})
    class SimpleNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private SimpleNetworkCallback() {
        }

        /*
         * WARNING - void declaration
         */
        public void onAvailable(Network network) {
            void var1_1;
            Logging.d(NetworkMonitorAutoDetect.TAG, "Network becomes available: " + network.toString());
            this.onNetworkChanged((Network)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            void var1_1;
            void var2_2;
            Logging.d(NetworkMonitorAutoDetect.TAG, "capabilities changed: " + var2_2.toString());
            this.onNetworkChanged((Network)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
            void var1_1;
            void var2_2;
            Logging.d(NetworkMonitorAutoDetect.TAG, "link properties changed: " + var2_2.toString());
            this.onNetworkChanged((Network)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void onLosing(Network network, int maxMsToLive) {
            void var2_2;
            void var1_1;
            Logging.d(NetworkMonitorAutoDetect.TAG, "Network " + var1_1.toString() + " is about to lose in " + (int)var2_2 + "ms");
        }

        /*
         * WARNING - void declaration
         */
        public void onLost(Network network) {
            void var1_1;
            Logging.d(NetworkMonitorAutoDetect.TAG, "Network " + network.toString() + " is disconnected");
            NetworkMonitorAutoDetect.this.observer.onNetworkDisconnect(NetworkMonitorAutoDetect.networkToNetId((Network)var1_1));
        }

        private void onNetworkChanged(Network network) {
            NetworkInformation networkInformation;
            networkInformation = ConnectivityManagerDelegate.access$300(NetworkMonitorAutoDetect.this.connectivityManagerDelegate, (Network)networkInformation);
            if (networkInformation != null) {
                NetworkMonitorAutoDetect.this.observer.onNetworkConnect(networkInformation);
            }
        }
    }

    static class NetworkState {
        private final boolean connected;
        private final int type;
        private final int subtype;
        private final int underlyingNetworkTypeForVpn;
        private final int underlyingNetworkSubtypeForVpn;

        /*
         * WARNING - void declaration
         */
        public NetworkState(boolean connected, int type, int subtype, int underlyingNetworkTypeForVpn, int underlyingNetworkSubtypeForVpn) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.connected = var1_1;
            this.type = var2_2;
            this.subtype = var3_3;
            this.underlyingNetworkTypeForVpn = underlyingNetworkTypeForVpn;
            this.underlyingNetworkSubtypeForVpn = underlyingNetworkSubtypeForVpn;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public int getNetworkType() {
            return this.type;
        }

        public int getNetworkSubType() {
            return this.subtype;
        }

        public int getUnderlyingNetworkTypeForVpn() {
            return this.underlyingNetworkTypeForVpn;
        }

        public int getUnderlyingNetworkSubtypeForVpn() {
            return this.underlyingNetworkSubtypeForVpn;
        }
    }

    public static class NetworkInformation {
        public final String name;
        public final ConnectionType type;
        public final ConnectionType underlyingTypeForVpn;
        public final long handle;
        public final IPAddress[] ipAddresses;

        /*
         * WARNING - void declaration
         */
        public NetworkInformation(String name, ConnectionType type, ConnectionType underlyingTypeForVpn, long handle, IPAddress[] addresses) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.type = var2_2;
            this.underlyingTypeForVpn = var3_3;
            this.handle = handle;
            this.ipAddresses = addresses;
        }

        @CalledByNative(value="NetworkInformation")
        private IPAddress[] getIpAddresses() {
            return this.ipAddresses;
        }

        @CalledByNative(value="NetworkInformation")
        private ConnectionType getConnectionType() {
            return this.type;
        }

        @CalledByNative(value="NetworkInformation")
        private ConnectionType getUnderlyingConnectionTypeForVpn() {
            return this.underlyingTypeForVpn;
        }

        @CalledByNative(value="NetworkInformation")
        private long getHandle() {
            return this.handle;
        }

        @CalledByNative(value="NetworkInformation")
        private String getName() {
            return this.name;
        }
    }

    public static class IPAddress {
        public final byte[] address;

        /*
         * WARNING - void declaration
         */
        public IPAddress(byte[] address) {
            void var1_1;
            this.address = var1_1;
        }

        @CalledByNative(value="IPAddress")
        private byte[] getAddress() {
            return this.address;
        }
    }

    public static enum ConnectionType {
        CONNECTION_UNKNOWN,
        CONNECTION_ETHERNET,
        CONNECTION_WIFI,
        CONNECTION_5G,
        CONNECTION_4G,
        CONNECTION_3G,
        CONNECTION_2G,
        CONNECTION_UNKNOWN_CELLULAR,
        CONNECTION_BLUETOOTH,
        CONNECTION_VPN,
        CONNECTION_NONE;

    }
}

