/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.CryptoOptions;
import org.qnwebrtc.DataChannel;
import org.qnwebrtc.IceCandidate;
import org.qnwebrtc.MediaConstraints;
import org.qnwebrtc.MediaStream;
import org.qnwebrtc.MediaStreamTrack;
import org.qnwebrtc.NativePeerConnectionFactory;
import org.qnwebrtc.RTCStatsCollectorCallback;
import org.qnwebrtc.RtcCertificatePem;
import org.qnwebrtc.RtpReceiver;
import org.qnwebrtc.RtpSender;
import org.qnwebrtc.RtpTransceiver;
import org.qnwebrtc.SdpObserver;
import org.qnwebrtc.SessionDescription;
import org.qnwebrtc.StatsObserver;
import org.qnwebrtc.TurnCustomizer;

public class PeerConnection {
    private final List<MediaStream> localStreams = new ArrayList<MediaStream>();
    private final long nativePeerConnection;
    private List<RtpSender> senders = new ArrayList<RtpSender>();
    private List<RtpReceiver> receivers = new ArrayList<RtpReceiver>();
    private List<RtpTransceiver> transceivers = new ArrayList<RtpTransceiver>();

    /*
     * WARNING - void declaration
     */
    public PeerConnection(NativePeerConnectionFactory factory) {
        this(var1_1.createNativePeerConnection());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    PeerConnection(long nativePeerConnection) {
        void var1_1;
        this.nativePeerConnection = var1_1;
    }

    public SessionDescription getLocalDescription() {
        return this.nativeGetLocalDescription();
    }

    public SessionDescription getRemoteDescription() {
        return this.nativeGetRemoteDescription();
    }

    public RtcCertificatePem getCertificate() {
        return this.nativeGetCertificate();
    }

    /*
     * WARNING - void declaration
     */
    public DataChannel createDataChannel(String label, DataChannel.Init init) {
        void var2_2;
        void var1_1;
        return this.nativeCreateDataChannel((String)var1_1, (DataChannel.Init)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void createOffer(SdpObserver observer, MediaConstraints constraints) {
        void var2_2;
        void var1_1;
        this.nativeCreateOffer((SdpObserver)var1_1, (MediaConstraints)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void createAnswer(SdpObserver observer, MediaConstraints constraints) {
        void var2_2;
        void var1_1;
        this.nativeCreateAnswer((SdpObserver)var1_1, (MediaConstraints)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setLocalDescription(SdpObserver observer, SessionDescription sdp) {
        void var2_2;
        void var1_1;
        this.nativeSetLocalDescription((SdpObserver)var1_1, (SessionDescription)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setRemoteDescription(SdpObserver observer, SessionDescription sdp) {
        void var2_2;
        void var1_1;
        this.nativeSetRemoteDescription((SdpObserver)var1_1, (SessionDescription)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setAudioPlayout(boolean playout) {
        void var1_1;
        this.nativeSetAudioPlayout((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAudioRecording(boolean recording) {
        void var1_1;
        this.nativeSetAudioRecording((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean setConfiguration(RTCConfiguration config) {
        void var1_1;
        return this.nativeSetConfiguration((RTCConfiguration)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean addIceCandidate(IceCandidate candidate) {
        void var1_1;
        return this.nativeAddIceCandidate(candidate.sdpMid, candidate.sdpMLineIndex, var1_1.sdp);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeIceCandidates(IceCandidate[] candidates) {
        void var1_1;
        return this.nativeRemoveIceCandidates((IceCandidate[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean addStream(MediaStream stream) {
        void var1_1;
        if (!this.nativeAddLocalStream(stream.getNativeMediaStream())) {
            return false;
        }
        this.localStreams.add((MediaStream)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void removeStream(MediaStream stream) {
        void var1_1;
        this.nativeRemoveLocalStream(stream.getNativeMediaStream());
        this.localStreams.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public RtpSender createSender(String kind, String stream_id) {
        void var2_2;
        RtpSender rtpSender;
        if ((rtpSender = this.nativeCreateSender((String)((Object)rtpSender), (String)var2_2)) != null) {
            this.senders.add(rtpSender);
        }
        return rtpSender;
    }

    public List<RtpSender> getSenders() {
        Iterator<RtpSender> iterator = this.senders.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        this.senders = this.nativeGetSenders();
        return Collections.unmodifiableList(this.senders);
    }

    public List<RtpReceiver> getReceivers() {
        Iterator<RtpReceiver> iterator = this.receivers.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        this.receivers = this.nativeGetReceivers();
        return Collections.unmodifiableList(this.receivers);
    }

    public List<RtpTransceiver> getTransceivers() {
        Iterator<RtpTransceiver> iterator = this.transceivers.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        this.transceivers = this.nativeGetTransceivers();
        return Collections.unmodifiableList(this.transceivers);
    }

    /*
     * WARNING - void declaration
     */
    public RtpSender addTrack(MediaStreamTrack track) {
        void var1_1;
        return this.addTrack((MediaStreamTrack)var1_1, Collections.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    public RtpSender addTrack(MediaStreamTrack track, List<String> streamIds) {
        void var2_2;
        RtpSender rtpSender;
        if (track == null || streamIds == null) {
            throw new NullPointerException("No MediaStreamTrack specified in addTrack.");
        }
        if ((rtpSender = this.nativeAddTrack(((MediaStreamTrack)((Object)rtpSender)).getNativeMediaStreamTrack(), (List<String>)var2_2)) == null) {
            throw new IllegalStateException("C++ addTrack failed.");
        }
        this.senders.add(rtpSender);
        return rtpSender;
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeTrack(RtpSender sender) {
        void var1_1;
        if (sender == null) {
            throw new NullPointerException("No RtpSender specified for removeTrack.");
        }
        return this.nativeRemoveTrack(var1_1.getNativeRtpSender());
    }

    /*
     * WARNING - void declaration
     */
    public RtpTransceiver addTransceiver(MediaStreamTrack track) {
        void var1_1;
        return this.addTransceiver((MediaStreamTrack)var1_1, new RtpTransceiver.RtpTransceiverInit());
    }

    /*
     * WARNING - void declaration
     */
    public RtpTransceiver addTransceiver(MediaStreamTrack track, @Nullable RtpTransceiver.RtpTransceiverInit init) {
        void var2_2;
        RtpTransceiver rtpTransceiver;
        if (track == null) {
            throw new NullPointerException("No MediaStreamTrack specified for addTransceiver.");
        }
        if (init == null) {
            init = new RtpTransceiver.RtpTransceiverInit();
        }
        if ((rtpTransceiver = this.nativeAddTransceiverWithTrack(((MediaStreamTrack)((Object)rtpTransceiver)).getNativeMediaStreamTrack(), (RtpTransceiver.RtpTransceiverInit)var2_2)) == null) {
            throw new IllegalStateException("C++ addTransceiver failed.");
        }
        this.transceivers.add(rtpTransceiver);
        return rtpTransceiver;
    }

    /*
     * WARNING - void declaration
     */
    public RtpTransceiver addTransceiver(MediaStreamTrack.MediaType mediaType) {
        void var1_1;
        return this.addTransceiver((MediaStreamTrack.MediaType)var1_1, new RtpTransceiver.RtpTransceiverInit());
    }

    /*
     * WARNING - void declaration
     */
    public RtpTransceiver addTransceiver(MediaStreamTrack.MediaType mediaType, @Nullable RtpTransceiver.RtpTransceiverInit init) {
        void var2_2;
        RtpTransceiver rtpTransceiver;
        if (mediaType == null) {
            throw new NullPointerException("No MediaType specified for addTransceiver.");
        }
        if (init == null) {
            init = new RtpTransceiver.RtpTransceiverInit();
        }
        if ((rtpTransceiver = this.nativeAddTransceiverOfType((MediaStreamTrack.MediaType)((Object)rtpTransceiver), (RtpTransceiver.RtpTransceiverInit)var2_2)) == null) {
            throw new IllegalStateException("C++ addTransceiver failed.");
        }
        this.transceivers.add(rtpTransceiver);
        return rtpTransceiver;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean getStats(StatsObserver observer, @Nullable MediaStreamTrack track) {
        void var2_2;
        void var1_1;
        return this.nativeOldGetStats((StatsObserver)var1_1, track == null ? 0L : var2_2.getNativeMediaStreamTrack());
    }

    /*
     * WARNING - void declaration
     */
    public void getStats(RTCStatsCollectorCallback callback) {
        void var1_1;
        this.nativeNewGetStats((RTCStatsCollectorCallback)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean setBitrate(Integer min, Integer current, Integer max) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.nativeSetBitrate((Integer)var1_1, (Integer)var2_2, (Integer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean startRtcEventLog(int file_descriptor, int max_size_bytes) {
        void var2_2;
        void var1_1;
        return this.nativeStartRtcEventLog((int)var1_1, (int)var2_2);
    }

    public void stopRtcEventLog() {
        this.nativeStopRtcEventLog();
    }

    public SignalingState signalingState() {
        return this.nativeSignalingState();
    }

    public IceConnectionState iceConnectionState() {
        return this.nativeIceConnectionState();
    }

    public PeerConnectionState connectionState() {
        return this.nativeConnectionState();
    }

    public IceGatheringState iceGatheringState() {
        return this.nativeIceGatheringState();
    }

    public void close() {
        this.nativeClose();
    }

    public void dispose() {
        this.close();
        for (MediaStream mediaStream : this.localStreams) {
            this.nativeRemoveLocalStream(mediaStream.getNativeMediaStream());
            mediaStream.dispose();
        }
        this.localStreams.clear();
        Iterator<Object> iterator = this.senders.iterator();
        while (iterator.hasNext()) {
            ((RtpSender)iterator.next()).dispose();
        }
        this.senders.clear();
        iterator = this.receivers.iterator();
        while (iterator.hasNext()) {
            ((RtpReceiver)iterator.next()).dispose();
        }
        iterator = this.transceivers.iterator();
        while (iterator.hasNext()) {
            ((RtpTransceiver)iterator.next()).dispose();
        }
        this.transceivers.clear();
        this.receivers.clear();
        PeerConnection.nativeFreeOwnedPeerConnection(this.nativePeerConnection);
    }

    public long getNativePeerConnection() {
        return this.nativeGetNativePeerConnection();
    }

    @CalledByNative
    long getNativeOwnedPeerConnection() {
        return this.nativePeerConnection;
    }

    public static long createNativePeerConnectionObserver(Observer observer) {
        return PeerConnection.nativeCreatePeerConnectionObserver(observer);
    }

    private native long nativeGetNativePeerConnection();

    private native SessionDescription nativeGetLocalDescription();

    private native SessionDescription nativeGetRemoteDescription();

    private native RtcCertificatePem nativeGetCertificate();

    private native DataChannel nativeCreateDataChannel(String var1, DataChannel.Init var2);

    private native void nativeCreateOffer(SdpObserver var1, MediaConstraints var2);

    private native void nativeCreateAnswer(SdpObserver var1, MediaConstraints var2);

    private native void nativeSetLocalDescription(SdpObserver var1, SessionDescription var2);

    private native void nativeSetRemoteDescription(SdpObserver var1, SessionDescription var2);

    private native void nativeSetAudioPlayout(boolean var1);

    private native void nativeSetAudioRecording(boolean var1);

    private native boolean nativeSetBitrate(Integer var1, Integer var2, Integer var3);

    private native SignalingState nativeSignalingState();

    private native IceConnectionState nativeIceConnectionState();

    private native PeerConnectionState nativeConnectionState();

    private native IceGatheringState nativeIceGatheringState();

    private native void nativeClose();

    private static native long nativeCreatePeerConnectionObserver(Observer var0);

    private static native void nativeFreeOwnedPeerConnection(long var0);

    private native boolean nativeSetConfiguration(RTCConfiguration var1);

    private native boolean nativeAddIceCandidate(String var1, int var2, String var3);

    private native boolean nativeRemoveIceCandidates(IceCandidate[] var1);

    private native boolean nativeAddLocalStream(long var1);

    private native void nativeRemoveLocalStream(long var1);

    private native boolean nativeOldGetStats(StatsObserver var1, long var2);

    private native void nativeNewGetStats(RTCStatsCollectorCallback var1);

    private native RtpSender nativeCreateSender(String var1, String var2);

    private native List<RtpSender> nativeGetSenders();

    private native List<RtpReceiver> nativeGetReceivers();

    private native List<RtpTransceiver> nativeGetTransceivers();

    private native RtpSender nativeAddTrack(long var1, List<String> var3);

    private native boolean nativeRemoveTrack(long var1);

    private native RtpTransceiver nativeAddTransceiverWithTrack(long var1, RtpTransceiver.RtpTransceiverInit var3);

    private native RtpTransceiver nativeAddTransceiverOfType(MediaStreamTrack.MediaType var1, RtpTransceiver.RtpTransceiverInit var2);

    private native boolean nativeStartRtcEventLog(int var1, int var2);

    private native void nativeStopRtcEventLog();

    public static class RTCConfiguration {
        public IceTransportsType iceTransportsType = IceTransportsType.ALL;
        public List<IceServer> iceServers;
        public BundlePolicy bundlePolicy = BundlePolicy.BALANCED;
        @Nullable
        public RtcCertificatePem certificate;
        public RtcpMuxPolicy rtcpMuxPolicy = RtcpMuxPolicy.REQUIRE;
        public TcpCandidatePolicy tcpCandidatePolicy = TcpCandidatePolicy.ENABLED;
        public CandidateNetworkPolicy candidateNetworkPolicy = CandidateNetworkPolicy.ALL;
        public int audioJitterBufferMaxPackets;
        public boolean audioJitterBufferFastAccelerate;
        public int iceConnectionReceivingTimeout;
        public int iceBackupCandidatePairPingInterval;
        public KeyType keyType;
        public ContinualGatheringPolicy continualGatheringPolicy;
        public int iceCandidatePoolSize;
        public boolean pruneTurnPorts;
        public boolean presumeWritableWhenFullyRelayed;
        @Nullable
        public Integer iceCheckIntervalStrongConnectivityMs;
        @Nullable
        public Integer iceCheckIntervalWeakConnectivityMs;
        @Nullable
        public Integer iceCheckMinInterval;
        @Nullable
        public Integer iceUnwritableTimeMs;
        @Nullable
        public Integer iceUnwritableMinChecks;
        @Nullable
        public Integer stunCandidateKeepaliveIntervalMs;
        public boolean disableIPv6OnWifi;
        public int maxIPv6Networks;
        @Nullable
        public IntervalRange iceRegatherIntervalRange;
        public boolean disableIpv6;
        public boolean enableDscp;
        public boolean enableCpuOveruseDetection;
        public boolean enableRtpDataChannel;
        public boolean suspendBelowMinBitrate;
        @Nullable
        public Integer screencastMinBitrate;
        @Nullable
        public Boolean combinedAudioVideoBwe;
        @Nullable
        public Boolean enableDtlsSrtp;
        public AdapterType networkPreference;
        public SdpSemantics sdpSemantics;
        @Nullable
        public TurnCustomizer turnCustomizer;
        public boolean activeResetSrtpParams;
        public boolean useMediaTransport;
        public boolean useMediaTransportForDataChannels;
        @Nullable
        public CryptoOptions cryptoOptions;

        /*
         * WARNING - void declaration
         */
        public RTCConfiguration(List<IceServer> iceServers) {
            void var1_1;
            this.iceServers = var1_1;
            this.audioJitterBufferMaxPackets = 50;
            this.audioJitterBufferFastAccelerate = false;
            this.iceConnectionReceivingTimeout = -1;
            this.iceBackupCandidatePairPingInterval = -1;
            this.keyType = KeyType.ECDSA;
            this.continualGatheringPolicy = ContinualGatheringPolicy.GATHER_ONCE;
            this.iceCandidatePoolSize = 0;
            this.pruneTurnPorts = false;
            this.presumeWritableWhenFullyRelayed = false;
            this.iceCheckIntervalStrongConnectivityMs = null;
            this.iceCheckIntervalWeakConnectivityMs = null;
            this.iceCheckMinInterval = null;
            this.iceUnwritableTimeMs = null;
            this.iceUnwritableMinChecks = null;
            this.stunCandidateKeepaliveIntervalMs = null;
            this.disableIPv6OnWifi = false;
            this.maxIPv6Networks = 5;
            this.iceRegatherIntervalRange = null;
            this.disableIpv6 = false;
            this.enableDscp = false;
            this.enableCpuOveruseDetection = true;
            this.enableRtpDataChannel = false;
            this.suspendBelowMinBitrate = false;
            this.screencastMinBitrate = null;
            this.combinedAudioVideoBwe = null;
            this.enableDtlsSrtp = null;
            this.networkPreference = AdapterType.UNKNOWN;
            this.sdpSemantics = SdpSemantics.PLAN_B;
            this.activeResetSrtpParams = false;
            this.useMediaTransport = false;
            this.useMediaTransportForDataChannels = false;
            this.cryptoOptions = null;
        }

        @CalledByNative(value="RTCConfiguration")
        IceTransportsType getIceTransportsType() {
            return this.iceTransportsType;
        }

        @CalledByNative(value="RTCConfiguration")
        List<IceServer> getIceServers() {
            return this.iceServers;
        }

        @CalledByNative(value="RTCConfiguration")
        BundlePolicy getBundlePolicy() {
            return this.bundlePolicy;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        RtcCertificatePem getCertificate() {
            return this.certificate;
        }

        @CalledByNative(value="RTCConfiguration")
        RtcpMuxPolicy getRtcpMuxPolicy() {
            return this.rtcpMuxPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        TcpCandidatePolicy getTcpCandidatePolicy() {
            return this.tcpCandidatePolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        CandidateNetworkPolicy getCandidateNetworkPolicy() {
            return this.candidateNetworkPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        int getAudioJitterBufferMaxPackets() {
            return this.audioJitterBufferMaxPackets;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getAudioJitterBufferFastAccelerate() {
            return this.audioJitterBufferFastAccelerate;
        }

        @CalledByNative(value="RTCConfiguration")
        int getIceConnectionReceivingTimeout() {
            return this.iceConnectionReceivingTimeout;
        }

        @CalledByNative(value="RTCConfiguration")
        int getIceBackupCandidatePairPingInterval() {
            return this.iceBackupCandidatePairPingInterval;
        }

        @CalledByNative(value="RTCConfiguration")
        KeyType getKeyType() {
            return this.keyType;
        }

        @CalledByNative(value="RTCConfiguration")
        ContinualGatheringPolicy getContinualGatheringPolicy() {
            return this.continualGatheringPolicy;
        }

        @CalledByNative(value="RTCConfiguration")
        int getIceCandidatePoolSize() {
            return this.iceCandidatePoolSize;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getPruneTurnPorts() {
            return this.pruneTurnPorts;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getPresumeWritableWhenFullyRelayed() {
            return this.presumeWritableWhenFullyRelayed;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getIceCheckIntervalStrongConnectivity() {
            return this.iceCheckIntervalStrongConnectivityMs;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getIceCheckIntervalWeakConnectivity() {
            return this.iceCheckIntervalWeakConnectivityMs;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getIceCheckMinInterval() {
            return this.iceCheckMinInterval;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getIceUnwritableTimeout() {
            return this.iceUnwritableTimeMs;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getIceUnwritableMinChecks() {
            return this.iceUnwritableMinChecks;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getStunCandidateKeepaliveInterval() {
            return this.stunCandidateKeepaliveIntervalMs;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getDisableIPv6OnWifi() {
            return this.disableIPv6OnWifi;
        }

        @CalledByNative(value="RTCConfiguration")
        int getMaxIPv6Networks() {
            return this.maxIPv6Networks;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        IntervalRange getIceRegatherIntervalRange() {
            return this.iceRegatherIntervalRange;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        TurnCustomizer getTurnCustomizer() {
            return this.turnCustomizer;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getDisableIpv6() {
            return this.disableIpv6;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getEnableDscp() {
            return this.enableDscp;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getEnableCpuOveruseDetection() {
            return this.enableCpuOveruseDetection;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getEnableRtpDataChannel() {
            return this.enableRtpDataChannel;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getSuspendBelowMinBitrate() {
            return this.suspendBelowMinBitrate;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Integer getScreencastMinBitrate() {
            return this.screencastMinBitrate;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Boolean getCombinedAudioVideoBwe() {
            return this.combinedAudioVideoBwe;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        Boolean getEnableDtlsSrtp() {
            return this.enableDtlsSrtp;
        }

        @CalledByNative(value="RTCConfiguration")
        AdapterType getNetworkPreference() {
            return this.networkPreference;
        }

        @CalledByNative(value="RTCConfiguration")
        SdpSemantics getSdpSemantics() {
            return this.sdpSemantics;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getActiveResetSrtpParams() {
            return this.activeResetSrtpParams;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getUseMediaTransport() {
            return this.useMediaTransport;
        }

        @CalledByNative(value="RTCConfiguration")
        boolean getUseMediaTransportForDataChannels() {
            return this.useMediaTransportForDataChannels;
        }

        @Nullable
        @CalledByNative(value="RTCConfiguration")
        CryptoOptions getCryptoOptions() {
            return this.cryptoOptions;
        }
    }

    public static enum SdpSemantics {
        PLAN_B,
        UNIFIED_PLAN;

    }

    public static class IntervalRange {
        private final int min;
        private final int max;

        /*
         * WARNING - void declaration
         */
        public IntervalRange(int min, int max) {
            void var2_2;
            void var1_1;
            this.min = var1_1;
            this.max = var2_2;
        }

        @CalledByNative(value="IntervalRange")
        public int getMin() {
            return this.min;
        }

        @CalledByNative(value="IntervalRange")
        public int getMax() {
            return this.max;
        }
    }

    public static enum ContinualGatheringPolicy {
        GATHER_ONCE,
        GATHER_CONTINUALLY;

    }

    public static enum KeyType {
        RSA,
        ECDSA;

    }

    public static enum AdapterType {
        UNKNOWN,
        ETHERNET,
        WIFI,
        CELLULAR,
        VPN,
        LOOPBACK;

    }

    public static enum CandidateNetworkPolicy {
        ALL,
        LOW_COST;

    }

    public static enum TcpCandidatePolicy {
        ENABLED,
        DISABLED;

    }

    public static enum RtcpMuxPolicy {
        NEGOTIATE,
        REQUIRE;

    }

    public static enum BundlePolicy {
        BALANCED,
        MAXBUNDLE,
        MAXCOMPAT;

    }

    public static enum IceTransportsType {
        NONE,
        RELAY,
        NOHOST,
        ALL;

    }

    public static class IceServer {
        @Deprecated
        public final String uri;
        public final List<String> urls;
        public final String username;
        public final String password;
        public final TlsCertPolicy tlsCertPolicy;
        public final String hostname;
        public final List<String> tlsAlpnProtocols;
        public final List<String> tlsEllipticCurves;

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public IceServer(String uri) {
            this((String)var1_1, "", "");
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public IceServer(String uri, String username, String password) {
            this((String)var1_1, (String)var2_2, (String)var3_3, TlsCertPolicy.TLS_CERT_POLICY_SECURE);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public IceServer(String uri, String username, String password, TlsCertPolicy tlsCertPolicy) {
            this((String)var1_1, (String)var2_2, (String)var3_3, tlsCertPolicy, "");
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public IceServer(String uri, String username, String password, TlsCertPolicy tlsCertPolicy, String hostname) {
            void var3_3;
            void var2_2;
            void var1_1;
            void v0 = var1_1;
            this((String)v0, Collections.singletonList(v0), (String)var2_2, (String)var3_3, tlsCertPolicy, hostname, null, null);
        }

        /*
         * WARNING - void declaration
         */
        private IceServer(String uri, List<String> urls, String username, String password, TlsCertPolicy tlsCertPolicy, String hostname, List<String> tlsAlpnProtocols, List<String> tlsEllipticCurves) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (uri == null || urls == null || urls.isEmpty()) {
                throw new IllegalArgumentException("uri == null || urls == null || urls.isEmpty()");
            }
            Iterator<String> iterator = urls.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                throw new IllegalArgumentException("urls element is null: ".concat(String.valueOf(urls)));
            }
            if (username == null) {
                throw new IllegalArgumentException("username == null");
            }
            if (password == null) {
                throw new IllegalArgumentException("password == null");
            }
            if (hostname == null) {
                throw new IllegalArgumentException("hostname == null");
            }
            this.uri = var1_1;
            this.urls = var2_2;
            this.username = var3_3;
            this.password = password;
            this.tlsCertPolicy = tlsCertPolicy;
            this.hostname = hostname;
            this.tlsAlpnProtocols = tlsAlpnProtocols;
            this.tlsEllipticCurves = tlsEllipticCurves;
        }

        public String toString() {
            return this.urls + " [" + this.username + ":" + this.password + "] [" + (Object)((Object)this.tlsCertPolicy) + "] [" + this.hostname + "] [" + this.tlsAlpnProtocols + "] [" + this.tlsEllipticCurves + "]";
        }

        public boolean equals(@Nullable Object obj) {
            IceServer iceServer;
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IceServer)) {
                return false;
            }
            iceServer = iceServer;
            return this.uri.equals(iceServer.uri) && this.urls.equals(iceServer.urls) && this.username.equals(iceServer.username) && this.password.equals(iceServer.password) && this.tlsCertPolicy.equals((Object)iceServer.tlsCertPolicy) && this.hostname.equals(iceServer.hostname) && this.tlsAlpnProtocols.equals(iceServer.tlsAlpnProtocols) && this.tlsEllipticCurves.equals(iceServer.tlsEllipticCurves);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.uri, this.urls, this.username, this.password, this.tlsCertPolicy, this.hostname, this.tlsAlpnProtocols, this.tlsEllipticCurves});
        }

        public static Builder builder(String uri) {
            String string;
            return new Builder(Collections.singletonList(string));
        }

        public static Builder builder(List<String> urls) {
            List<String> list;
            return new Builder(list);
        }

        @Nullable
        @CalledByNative(value="IceServer")
        List<String> getUrls() {
            return this.urls;
        }

        @Nullable
        @CalledByNative(value="IceServer")
        String getUsername() {
            return this.username;
        }

        @Nullable
        @CalledByNative(value="IceServer")
        String getPassword() {
            return this.password;
        }

        @CalledByNative(value="IceServer")
        TlsCertPolicy getTlsCertPolicy() {
            return this.tlsCertPolicy;
        }

        @Nullable
        @CalledByNative(value="IceServer")
        String getHostname() {
            return this.hostname;
        }

        @CalledByNative(value="IceServer")
        List<String> getTlsAlpnProtocols() {
            return this.tlsAlpnProtocols;
        }

        @CalledByNative(value="IceServer")
        List<String> getTlsEllipticCurves() {
            return this.tlsEllipticCurves;
        }

        public static class Builder {
            @Nullable
            private final List<String> urls;
            private String username = "";
            private String password = "";
            private TlsCertPolicy tlsCertPolicy = TlsCertPolicy.TLS_CERT_POLICY_SECURE;
            private String hostname = "";
            private List<String> tlsAlpnProtocols;
            private List<String> tlsEllipticCurves;

            /*
             * WARNING - void declaration
             */
            private Builder(List<String> urls) {
                void var1_1;
                if (urls == null || urls.isEmpty()) {
                    throw new IllegalArgumentException("urls == null || urls.isEmpty(): ".concat(String.valueOf(urls)));
                }
                this.urls = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setUsername(String username) {
                void var1_1;
                this.username = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setPassword(String password) {
                void var1_1;
                this.password = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setTlsCertPolicy(TlsCertPolicy tlsCertPolicy) {
                void var1_1;
                this.tlsCertPolicy = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setHostname(String hostname) {
                void var1_1;
                this.hostname = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setTlsAlpnProtocols(List<String> tlsAlpnProtocols) {
                void var1_1;
                this.tlsAlpnProtocols = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setTlsEllipticCurves(List<String> tlsEllipticCurves) {
                void var1_1;
                this.tlsEllipticCurves = var1_1;
                return this;
            }

            public IceServer createIceServer() {
                return new IceServer(this.urls.get(0), this.urls, this.username, this.password, this.tlsCertPolicy, this.hostname, this.tlsAlpnProtocols, this.tlsEllipticCurves);
            }
        }
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onSignalingChange(SignalingState var1);

        @CalledByNative(value="Observer")
        public void onIceConnectionChange(IceConnectionState var1);

        @CalledByNative(value="Observer")
        default public void onConnectionChange(PeerConnectionState newState) {
        }

        @CalledByNative(value="Observer")
        public void onIceConnectionReceivingChange(boolean var1);

        @CalledByNative(value="Observer")
        public void onIceGatheringChange(IceGatheringState var1);

        @CalledByNative(value="Observer")
        public void onIceCandidate(IceCandidate var1);

        @CalledByNative(value="Observer")
        public void onIceCandidatesRemoved(IceCandidate[] var1);

        @CalledByNative(value="Observer")
        public void onAddStream(MediaStream var1);

        @CalledByNative(value="Observer")
        public void onRemoveStream(MediaStream var1);

        @CalledByNative(value="Observer")
        public void onDataChannel(DataChannel var1);

        @CalledByNative(value="Observer")
        public void onRenegotiationNeeded();

        @CalledByNative(value="Observer")
        public void onAddTrack(RtpReceiver var1, MediaStream[] var2);

        @CalledByNative(value="Observer")
        default public void onTrack(RtpTransceiver transceiver) {
        }
    }

    public static enum SignalingState {
        STABLE,
        HAVE_LOCAL_OFFER,
        HAVE_LOCAL_PRANSWER,
        HAVE_REMOTE_OFFER,
        HAVE_REMOTE_PRANSWER,
        CLOSED;


        @CalledByNative(value="SignalingState")
        static SignalingState fromNativeIndex(int nativeIndex) {
            int n;
            return SignalingState.values()[n];
        }
    }

    public static enum TlsCertPolicy {
        TLS_CERT_POLICY_SECURE,
        TLS_CERT_POLICY_INSECURE_NO_CHECK;

    }

    public static enum PeerConnectionState {
        NEW,
        CONNECTING,
        CONNECTED,
        DISCONNECTED,
        FAILED,
        CLOSED;


        @CalledByNative(value="PeerConnectionState")
        static PeerConnectionState fromNativeIndex(int nativeIndex) {
            int n;
            return PeerConnectionState.values()[n];
        }
    }

    public static enum IceConnectionState {
        NEW,
        CHECKING,
        CONNECTED,
        COMPLETED,
        FAILED,
        DISCONNECTED,
        CLOSED;


        @CalledByNative(value="IceConnectionState")
        static IceConnectionState fromNativeIndex(int nativeIndex) {
            int n;
            return IceConnectionState.values()[n];
        }
    }

    public static enum IceGatheringState {
        NEW,
        GATHERING,
        COMPLETE;


        @CalledByNative(value="IceGatheringState")
        static IceGatheringState fromNativeIndex(int nativeIndex) {
            int n;
            return IceGatheringState.values()[n];
        }
    }
}

