/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.content.Context;
import android.os.Process;
import android.support.annotation.Nullable;
import java.util.List;
import org.qnwebrtc.AudioDecoderFactoryFactory;
import org.qnwebrtc.AudioEncoderFactoryFactory;
import org.qnwebrtc.AudioProcessingFactory;
import org.qnwebrtc.AudioSource;
import org.qnwebrtc.AudioTrack;
import org.qnwebrtc.BuiltinAudioDecoderFactoryFactory;
import org.qnwebrtc.BuiltinAudioEncoderFactoryFactory;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.ContextUtils;
import org.qnwebrtc.FecControllerFactoryFactoryInterface;
import org.qnwebrtc.JNILogging;
import org.qnwebrtc.Loggable;
import org.qnwebrtc.Logging;
import org.qnwebrtc.MediaCodecVideoDecoder;
import org.qnwebrtc.MediaCodecVideoEncoder;
import org.qnwebrtc.MediaConstraints;
import org.qnwebrtc.MediaStream;
import org.qnwebrtc.MediaTransportFactoryFactory;
import org.qnwebrtc.NativeLibrary;
import org.qnwebrtc.NativeLibraryLoader;
import org.qnwebrtc.NetworkStatePredictorFactoryFactory;
import org.qnwebrtc.PeerConnection;
import org.qnwebrtc.PeerConnectionDependencies;
import org.qnwebrtc.SSLCertificateVerifier;
import org.qnwebrtc.VideoDecoderFactory;
import org.qnwebrtc.VideoEncoderFactory;
import org.qnwebrtc.VideoSource;
import org.qnwebrtc.VideoTrack;
import org.qnwebrtc.audio.AudioDeviceModule;
import org.qnwebrtc.audio.JavaAudioDeviceModule;

public class PeerConnectionFactory {
    public static final String TRIAL_ENABLED = "Enabled";
    @Deprecated
    public static final String VIDEO_FRAME_EMIT_TRIAL = "VideoFrameEmit";
    private static final String TAG = "PeerConnectionFactory";
    private static final String VIDEO_CAPTURER_THREAD_NAME = "VideoCapturerThread";
    private static final int kRequiredResolutionAlignment = 2;
    private static volatile boolean internalTracerInitialized;
    @Nullable
    private static ThreadInfo staticNetworkThread;
    @Nullable
    private static ThreadInfo staticWorkerThread;
    @Nullable
    private static ThreadInfo staticSignalingThread;
    private long nativeFactory;
    @Nullable
    private volatile ThreadInfo networkThread;
    @Nullable
    private volatile ThreadInfo workerThread;
    @Nullable
    private volatile ThreadInfo signalingThread;

    public static Builder builder() {
        return new Builder();
    }

    public static void initialize(InitializationOptions options) {
        InitializationOptions initializationOptions;
        ContextUtils.initialize(options.applicationContext);
        NativeLibrary.initialize(options.nativeLibraryLoader, options.nativeLibraryName);
        PeerConnectionFactory.nativeInitializeAndroidGlobals();
        if (initializationOptions.enableInternalTracer && !internalTracerInitialized) {
            PeerConnectionFactory.initializeInternalTracer();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void enableInjectLog(Loggable loggable, Logging.Severity loggableSeverity) {
        if (loggable != null) {
            void var1_1;
            Loggable loggable2;
            Logging.injectLoggable(loggable, loggableSeverity);
            PeerConnectionFactory.nativeInjectLoggable(new JNILogging(loggable2), var1_1.ordinal());
        }
    }

    public static void disableInjectLog() {
        Logging.deleteInjectedLoggable();
        PeerConnectionFactory.nativeDeleteLoggable();
    }

    public static void enableLogToDebugOutput(Logging.Severity severity) {
        Logging.enableLogToDebugOutput(severity);
    }

    private static void checkInitializeHasBeenCalled() {
        if (!NativeLibrary.isLoaded() || ContextUtils.getApplicationContext() == null) {
            throw new IllegalStateException("PeerConnectionFactory.initialize was not called before creating a PeerConnectionFactory.");
        }
    }

    private static void initializeInternalTracer() {
        internalTracerInitialized = true;
        PeerConnectionFactory.nativeInitializeInternalTracer();
    }

    public static void shutdownInternalTracer() {
        internalTracerInitialized = false;
        PeerConnectionFactory.nativeShutdownInternalTracer();
    }

    @Deprecated
    public static void initializeFieldTrials(String fieldTrialsInitString) {
        PeerConnectionFactory.nativeInitializeFieldTrials(fieldTrialsInitString);
    }

    public static String fieldTrialsFindFullName(String name) {
        if (NativeLibrary.isLoaded()) {
            String string;
            return PeerConnectionFactory.nativeFindFieldTrialsFullName(string);
        }
        return "";
    }

    public static boolean startInternalTracingCapture(String tracingFilename) {
        return PeerConnectionFactory.nativeStartInternalTracingCapture(tracingFilename);
    }

    public static void stopInternalTracingCapture() {
        PeerConnectionFactory.nativeStopInternalTracingCapture();
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    PeerConnectionFactory(long nativeFactory) {
        void var1_1;
        PeerConnectionFactory.checkInitializeHasBeenCalled();
        if (nativeFactory == 0L) {
            throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
        }
        this.nativeFactory = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    PeerConnection createPeerConnectionInternal(PeerConnection.RTCConfiguration rtcConfig, MediaConstraints constraints, PeerConnection.Observer observer, SSLCertificateVerifier sslCertificateVerifier) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.checkPeerConnectionFactoryExists();
        long l2 = PeerConnection.createNativePeerConnectionObserver((PeerConnection.Observer)var3_3);
        if (l2 == 0L) {
            return null;
        }
        long l3 = PeerConnectionFactory.nativeCreatePeerConnection(this.nativeFactory, (PeerConnection.RTCConfiguration)var1_1, (MediaConstraints)var2_2, l2, sslCertificateVerifier);
        if (l3 == 0L) {
            return null;
        }
        return new PeerConnection(l3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Nullable
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rtcConfig, MediaConstraints constraints, PeerConnection.Observer observer) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.createPeerConnectionInternal((PeerConnection.RTCConfiguration)var1_1, (MediaConstraints)var2_2, (PeerConnection.Observer)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Nullable
    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> iceServers, MediaConstraints constraints, PeerConnection.Observer observer) {
        void var3_3;
        void var2_2;
        PeerConnection.RTCConfiguration rTCConfiguration;
        rTCConfiguration = new PeerConnection.RTCConfiguration((List<PeerConnection.IceServer>)((Object)rTCConfiguration));
        return this.createPeerConnection(rTCConfiguration, (MediaConstraints)var2_2, (PeerConnection.Observer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> iceServers, PeerConnection.Observer observer) {
        void var2_2;
        PeerConnection.RTCConfiguration rTCConfiguration;
        rTCConfiguration = new PeerConnection.RTCConfiguration((List<PeerConnection.IceServer>)((Object)rTCConfiguration));
        return this.createPeerConnection(rTCConfiguration, (PeerConnection.Observer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rtcConfig, PeerConnection.Observer observer) {
        void var2_2;
        void var1_1;
        return this.createPeerConnection((PeerConnection.RTCConfiguration)var1_1, null, (PeerConnection.Observer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rtcConfig, PeerConnectionDependencies dependencies) {
        void var2_2;
        void var1_1;
        return this.createPeerConnectionInternal((PeerConnection.RTCConfiguration)var1_1, null, dependencies.getObserver(), var2_2.getSSLCertificateVerifier());
    }

    /*
     * WARNING - void declaration
     */
    public MediaStream createLocalMediaStream(String label) {
        void var1_1;
        this.checkPeerConnectionFactoryExists();
        return new MediaStream(PeerConnectionFactory.nativeCreateLocalMediaStream(this.nativeFactory, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public VideoSource createVideoSource(boolean isScreencast, boolean alignTimestamps, int requiredResolutionAlignment) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkPeerConnectionFactoryExists();
        return new VideoSource(PeerConnectionFactory.nativeCreateVideoSource(this.nativeFactory, (boolean)var1_1, (boolean)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public VideoSource createVideoSource(boolean isScreencast, boolean alignTimestamps) {
        void var2_2;
        void var1_1;
        this.checkPeerConnectionFactoryExists();
        return new VideoSource(PeerConnectionFactory.nativeCreateVideoSource(this.nativeFactory, (boolean)var1_1, (boolean)var2_2, 2));
    }

    /*
     * WARNING - void declaration
     */
    public VideoSource createVideoSource(boolean isScreencast) {
        void var1_1;
        return this.createVideoSource((boolean)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public VideoTrack createVideoTrack(String id, VideoSource source) {
        void var2_2;
        void var1_1;
        this.checkPeerConnectionFactoryExists();
        return new VideoTrack(PeerConnectionFactory.nativeCreateVideoTrack(this.nativeFactory, (String)var1_1, var2_2.getNativeVideoTrackSource()));
    }

    /*
     * WARNING - void declaration
     */
    public AudioSource createAudioSource(MediaConstraints constraints) {
        void var1_1;
        this.checkPeerConnectionFactoryExists();
        return new AudioSource(PeerConnectionFactory.nativeCreateAudioSource(this.nativeFactory, (MediaConstraints)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public AudioTrack createAudioTrack(String id, AudioSource source) {
        void var2_2;
        void var1_1;
        this.checkPeerConnectionFactoryExists();
        return new AudioTrack(PeerConnectionFactory.nativeCreateAudioTrack(this.nativeFactory, (String)var1_1, var2_2.getNativeAudioSource()));
    }

    /*
     * WARNING - void declaration
     */
    public boolean startAecDump(int file_descriptor, int filesize_limit_bytes) {
        void var2_2;
        void var1_1;
        this.checkPeerConnectionFactoryExists();
        return PeerConnectionFactory.nativeStartAecDump(this.nativeFactory, (int)var1_1, (int)var2_2);
    }

    public void stopAecDump() {
        this.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeStopAecDump(this.nativeFactory);
    }

    /*
     * WARNING - void declaration
     */
    public void addFakeReceivingStream(long source) {
        void var1_1;
        this.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeAddFakeReceivingStream(this.nativeFactory, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeFakeReceivingStream(long source) {
        void var1_1;
        this.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeRemoveFakeReceivingStream(this.nativeFactory, (long)var1_1);
    }

    public void dispose() {
        this.checkPeerConnectionFactoryExists();
        PeerConnectionFactory.nativeFreeFactory(this.nativeFactory);
        this.networkThread = null;
        this.workerThread = null;
        this.signalingThread = null;
        MediaCodecVideoEncoder.disposeEglContext();
        MediaCodecVideoDecoder.disposeEglContext();
        this.nativeFactory = 0L;
    }

    public long getNativePeerConnectionFactory() {
        this.checkPeerConnectionFactoryExists();
        return PeerConnectionFactory.nativeGetNativePeerConnectionFactory(this.nativeFactory);
    }

    public long getNativeOwnedFactoryAndThreads() {
        this.checkPeerConnectionFactoryExists();
        return this.nativeFactory;
    }

    private void checkPeerConnectionFactoryExists() {
        if (this.nativeFactory == 0L) {
            throw new IllegalStateException("PeerConnectionFactory has been disposed.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void printStackTrace(@Nullable ThreadInfo threadInfo, boolean printNativeStackTrace) {
        void var1_1;
        if (threadInfo == null) {
            return;
        }
        String string = threadInfo.thread.getName();
        StackTraceElement[] stackTraceElementArray = threadInfo.thread.getStackTrace();
        if (stackTraceElementArray.length > 0) {
            Logging.w(TAG, string + " stacktrace:");
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                Logging.w(TAG, stackTraceElement.toString());
            }
        }
        if (var1_1 != false) {
            ThreadInfo threadInfo2;
            Logging.w(TAG, "*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***");
            Logging.w(TAG, "pid: " + Process.myPid() + ", tid: " + threadInfo.tid + ", name: " + string + "  >>> WebRTC <<<");
            PeerConnectionFactory.nativePrintStackTrace(threadInfo2.tid);
        }
    }

    @Deprecated
    public static void printStackTraces() {
        PeerConnectionFactory.printStackTrace(staticNetworkThread, false);
        PeerConnectionFactory.printStackTrace(staticWorkerThread, false);
        PeerConnectionFactory.printStackTrace(staticSignalingThread, false);
    }

    /*
     * WARNING - void declaration
     */
    public void printInternalStackTraces(boolean printNativeStackTraces) {
        void var1_1;
        PeerConnectionFactory.printStackTrace(this.signalingThread, printNativeStackTraces);
        PeerConnectionFactory.printStackTrace(this.workerThread, printNativeStackTraces);
        PeerConnectionFactory.printStackTrace(this.networkThread, printNativeStackTraces);
        if (var1_1 != false) {
            PeerConnectionFactory.nativePrintStackTracesOfRegisteredThreads();
        }
    }

    @CalledByNative
    private void onNetworkThreadReady() {
        staticNetworkThread = this.networkThread = ThreadInfo.getCurrent();
        Logging.d(TAG, "onNetworkThreadReady");
    }

    @CalledByNative
    private void onWorkerThreadReady() {
        staticWorkerThread = this.workerThread = ThreadInfo.getCurrent();
        Logging.d(TAG, "onWorkerThreadReady");
    }

    @CalledByNative
    private void onSignalingThreadReady() {
        staticSignalingThread = this.signalingThread = ThreadInfo.getCurrent();
        Logging.d(TAG, "onSignalingThreadReady");
    }

    private static native void nativeInitializeAndroidGlobals();

    private static native void nativeInitializeFieldTrials(String var0);

    private static native String nativeFindFieldTrialsFullName(String var0);

    private static native void nativeInitializeInternalTracer();

    private static native void nativeShutdownInternalTracer();

    private static native boolean nativeStartInternalTracingCapture(String var0);

    private static native void nativeStopInternalTracingCapture();

    private static native PeerConnectionFactory nativeCreatePeerConnectionFactory(Context var0, Options var1, long var2, long var4, long var6, VideoEncoderFactory var8, VideoDecoderFactory var9, long var10, long var12, long var14, long var16, String var18);

    private static native long nativeCreatePeerConnection(long var0, PeerConnection.RTCConfiguration var2, MediaConstraints var3, long var4, SSLCertificateVerifier var6);

    private static native long nativeCreateLocalMediaStream(long var0, String var2);

    private static native long nativeCreateVideoSource(long var0, boolean var2, boolean var3, int var4);

    private static native long nativeCreateVideoTrack(long var0, String var2, long var3);

    private static native long nativeCreateAudioSource(long var0, MediaConstraints var2);

    private static native long nativeCreateAudioTrack(long var0, String var2, long var3);

    private static native boolean nativeStartAecDump(long var0, int var2, int var3);

    private static native void nativeStopAecDump(long var0);

    private static native void nativeAddFakeReceivingStream(long var0, long var2);

    private static native void nativeRemoveFakeReceivingStream(long var0, long var2);

    private static native void nativeFreeFactory(long var0);

    private static native long nativeGetNativePeerConnectionFactory(long var0);

    private static native void nativeInjectLoggable(JNILogging var0, int var1);

    private static native void nativeDeleteLoggable();

    private static native void nativePrintStackTrace(int var0);

    private static native void nativePrintStackTracesOfRegisteredThreads();

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ PeerConnectionFactory access$200(Context x0, Options x1, long x2, long x3, long x4, VideoEncoderFactory x5, VideoDecoderFactory x6, long x7, long x8, long x9, long x10, String x11) {
        void var2_3;
        void var1_2;
        return PeerConnectionFactory.nativeCreatePeerConnectionFactory(x0, (Options)var1_2, (long)var2_3, x3, x4, x5, x6, x7, x8, x9, x10, x11);
    }

    public static class Builder {
        @Nullable
        private Options options;
        @Nullable
        private AudioDeviceModule audioDeviceModule;
        private AudioEncoderFactoryFactory audioEncoderFactoryFactory = new BuiltinAudioEncoderFactoryFactory();
        private AudioDecoderFactoryFactory audioDecoderFactoryFactory = new BuiltinAudioDecoderFactoryFactory();
        @Nullable
        private VideoEncoderFactory videoEncoderFactory;
        @Nullable
        private VideoDecoderFactory videoDecoderFactory;
        @Nullable
        private AudioProcessingFactory audioProcessingFactory;
        @Nullable
        private FecControllerFactoryFactoryInterface fecControllerFactoryFactory;
        @Nullable
        private NetworkStatePredictorFactoryFactory networkStatePredictorFactoryFactory;
        @Nullable
        private MediaTransportFactoryFactory mediaTransportFactoryFactory;
        @Nullable
        private String platformPath;

        private Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder setOptions(Options options) {
            void var1_1;
            this.options = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAudioDeviceModule(AudioDeviceModule audioDeviceModule) {
            void var1_1;
            this.audioDeviceModule = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAudioEncoderFactoryFactory(AudioEncoderFactoryFactory audioEncoderFactoryFactory) {
            void var1_1;
            if (audioEncoderFactoryFactory == null) {
                throw new IllegalArgumentException("PeerConnectionFactory.Builder does not accept a null AudioEncoderFactoryFactory.");
            }
            this.audioEncoderFactoryFactory = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAudioDecoderFactoryFactory(AudioDecoderFactoryFactory audioDecoderFactoryFactory) {
            void var1_1;
            if (audioDecoderFactoryFactory == null) {
                throw new IllegalArgumentException("PeerConnectionFactory.Builder does not accept a null AudioDecoderFactoryFactory.");
            }
            this.audioDecoderFactoryFactory = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
            void var1_1;
            this.videoEncoderFactory = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
            void var1_1;
            this.videoDecoderFactory = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setAudioProcessingFactory(AudioProcessingFactory audioProcessingFactory) {
            void var1_1;
            if (audioProcessingFactory == null) {
                throw new NullPointerException("PeerConnectionFactory builder does not accept a null AudioProcessingFactory.");
            }
            this.audioProcessingFactory = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setFecControllerFactoryFactoryInterface(FecControllerFactoryFactoryInterface fecControllerFactoryFactory) {
            void var1_1;
            this.fecControllerFactoryFactory = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setNetworkStatePredictorFactoryFactory(NetworkStatePredictorFactoryFactory networkStatePredictorFactoryFactory) {
            void var1_1;
            this.networkStatePredictorFactoryFactory = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setMediaTransportFactoryFactory(MediaTransportFactoryFactory mediaTransportFactoryFactory) {
            void var1_1;
            this.mediaTransportFactoryFactory = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setPlatformPath(String path) {
            void var1_1;
            this.platformPath = var1_1;
            return this;
        }

        public PeerConnectionFactory createPeerConnectionFactory() {
            PeerConnectionFactory.checkInitializeHasBeenCalled();
            if (this.audioDeviceModule == null) {
                this.audioDeviceModule = JavaAudioDeviceModule.builder(ContextUtils.getApplicationContext()).createAudioDeviceModule();
            }
            return PeerConnectionFactory.access$200(ContextUtils.getApplicationContext(), this.options, this.audioDeviceModule.getNativeAudioDeviceModulePointer(), this.audioEncoderFactoryFactory.createNativeAudioEncoderFactory(), this.audioDecoderFactoryFactory.createNativeAudioDecoderFactory(), this.videoEncoderFactory, this.videoDecoderFactory, this.audioProcessingFactory == null ? 0L : this.audioProcessingFactory.createNative(), this.fecControllerFactoryFactory == null ? 0L : this.fecControllerFactoryFactory.createNative(), this.networkStatePredictorFactoryFactory == null ? 0L : this.networkStatePredictorFactoryFactory.createNativeNetworkStatePredictorFactory(), this.mediaTransportFactoryFactory == null ? 0L : this.mediaTransportFactoryFactory.createNativeMediaTransportFactory(), this.platformPath);
        }
    }

    public static class Options {
        static final int ADAPTER_TYPE_UNKNOWN = 0;
        static final int ADAPTER_TYPE_ETHERNET = 1;
        static final int ADAPTER_TYPE_WIFI = 2;
        static final int ADAPTER_TYPE_CELLULAR = 4;
        static final int ADAPTER_TYPE_VPN = 8;
        static final int ADAPTER_TYPE_LOOPBACK = 16;
        static final int ADAPTER_TYPE_ANY = 32;
        public int networkIgnoreMask;
        public boolean disableEncryption;
        public boolean disableNetworkMonitor;

        @CalledByNative(value="Options")
        int getNetworkIgnoreMask() {
            return this.networkIgnoreMask;
        }

        @CalledByNative(value="Options")
        boolean getDisableEncryption() {
            return this.disableEncryption;
        }

        @CalledByNative(value="Options")
        boolean getDisableNetworkMonitor() {
            return this.disableNetworkMonitor;
        }
    }

    public static class InitializationOptions {
        final Context applicationContext;
        final String fieldTrials;
        final boolean enableInternalTracer;
        final NativeLibraryLoader nativeLibraryLoader;
        final String nativeLibraryName;
        @Nullable
        Loggable loggable;
        @Nullable
        Logging.Severity loggableSeverity;

        /*
         * WARNING - void declaration
         */
        private InitializationOptions(Context applicationContext, String fieldTrials, boolean enableInternalTracer, NativeLibraryLoader nativeLibraryLoader, String nativeLibraryName, @Nullable Loggable loggable, @Nullable Logging.Severity loggableSeverity) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.applicationContext = var1_1;
            this.fieldTrials = var2_2;
            this.enableInternalTracer = var3_3;
            this.nativeLibraryLoader = nativeLibraryLoader;
            this.nativeLibraryName = nativeLibraryName;
            this.loggable = loggable;
            this.loggableSeverity = loggableSeverity;
        }

        public static Builder builder(Context applicationContext) {
            Context context;
            return new Builder(context);
        }

        public static class Builder {
            private final Context applicationContext;
            private String fieldTrials = "";
            private boolean enableInternalTracer;
            private NativeLibraryLoader nativeLibraryLoader = new NativeLibrary.DefaultLoader();
            private String nativeLibraryName = "qndroid_rtc";
            @Nullable
            private Loggable loggable;
            @Nullable
            private Logging.Severity loggableSeverity;

            /*
             * WARNING - void declaration
             */
            Builder(Context applicationContext) {
                void var1_1;
                this.applicationContext = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setFieldTrials(String fieldTrials) {
                void var1_1;
                this.fieldTrials = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setEnableInternalTracer(boolean enableInternalTracer) {
                void var1_1;
                this.enableInternalTracer = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setNativeLibraryLoader(NativeLibraryLoader nativeLibraryLoader) {
                void var1_1;
                this.nativeLibraryLoader = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setNativeLibraryName(String nativeLibraryName) {
                void var1_1;
                this.nativeLibraryName = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setInjectableLogger(Loggable loggable, Logging.Severity severity) {
                void var2_2;
                void var1_1;
                this.loggable = var1_1;
                this.loggableSeverity = var2_2;
                return this;
            }

            public InitializationOptions createInitializationOptions() {
                return new InitializationOptions(this.applicationContext, this.fieldTrials, this.enableInternalTracer, this.nativeLibraryLoader, this.nativeLibraryName, this.loggable, this.loggableSeverity);
            }
        }
    }

    static class ThreadInfo {
        final Thread thread;
        final int tid;

        public static ThreadInfo getCurrent() {
            return new ThreadInfo(Thread.currentThread(), Process.myTid());
        }

        /*
         * WARNING - void declaration
         */
        private ThreadInfo(Thread thread, int tid) {
            void var2_2;
            void var1_1;
            this.thread = var1_1;
            this.tid = var2_2;
        }
    }
}

