/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import java.util.Map;
import org.qnwebrtc.CalledByNative;

public class RTCStats {
    private final long timestampUs;
    private final String type;
    private final String id;
    private final Map<String, Object> members;

    /*
     * WARNING - void declaration
     */
    public RTCStats(long timestampUs, String type, String id, Map<String, Object> members) {
        void var3_2;
        void var1_1;
        this.timestampUs = var1_1;
        this.type = var3_2;
        this.id = id;
        this.members = members;
    }

    public double getTimestampUs() {
        return this.timestampUs;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getMembers() {
        return this.members;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ timestampUs: ").append(this.timestampUs).append(", type: ").append(this.type).append(", id: ").append(this.id);
        for (Map.Entry<String, Object> entry : this.members.entrySet()) {
            stringBuilder.append(", ").append(entry.getKey()).append(": ");
            RTCStats.appendValue(stringBuilder, entry.getValue());
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public String toJsonString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"timestamp\":").append(this.timestampUs / 1000L).append(",\"type\":\"").append(this.type).append("\",\"id\":\"").append(this.id).append("\"");
        for (Map.Entry<String, Object> entry : this.members.entrySet()) {
            stringBuilder.append(",\"").append(entry.getKey()).append("\":");
            RTCStats.appendValue(stringBuilder, entry.getValue());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static void appendValue(StringBuilder builder, Object value) {
        StringBuilder stringBuilder;
        Object[] objectArray;
        if (value instanceof Object[]) {
            objectArray = objectArray;
            builder.append('[');
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (i2 != 0) {
                    builder.append(", ");
                }
                RTCStats.appendValue(builder, objectArray[i2]);
            }
            builder.append(']');
            return;
        }
        if (objectArray instanceof String) {
            builder.append('\"').append(objectArray).append('\"');
            return;
        }
        stringBuilder.append(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    static RTCStats create(long timestampUs, String type, String id, Map members) {
        void var3_2;
        void var2_1;
        long l2;
        return new RTCStats(l2, (String)var2_1, (String)var3_2, members);
    }
}

