/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.FrameDecryptorImpl;
import org.qnwebrtc.JniCommon;
import org.qnwebrtc.MediaStreamTrack;
import org.qnwebrtc.RtpParameters;

public class RtpReceiver {
    private long nativeRtpReceiver;
    private long nativeObserver;
    @Nullable
    private MediaStreamTrack cachedTrack;

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    public RtpReceiver(long nativeRtpReceiver) {
        void var1_1;
        this.nativeRtpReceiver = nativeRtpReceiver;
        long l2 = RtpReceiver.nativeGetTrack((long)var1_1);
        this.cachedTrack = MediaStreamTrack.createMediaStreamTrack(l2);
    }

    @Nullable
    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setParameters(@Nullable RtpParameters parameters) {
        void var1_1;
        this.checkRtpReceiverExists();
        if (parameters == null) {
            return false;
        }
        return RtpReceiver.nativeSetParameters(this.nativeRtpReceiver, (RtpParameters)var1_1);
    }

    public RtpParameters getParameters() {
        this.checkRtpReceiverExists();
        return RtpReceiver.nativeGetParameters(this.nativeRtpReceiver);
    }

    public String id() {
        this.checkRtpReceiverExists();
        return RtpReceiver.nativeGetId(this.nativeRtpReceiver);
    }

    @CalledByNative
    public void dispose() {
        this.checkRtpReceiverExists();
        this.cachedTrack.dispose();
        if (this.nativeObserver != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, this.nativeObserver);
            this.nativeObserver = 0L;
        }
        JniCommon.nativeReleaseRef(this.nativeRtpReceiver);
        this.nativeRtpReceiver = 0L;
    }

    /*
     * WARNING - void declaration
     */
    public void SetObserver(Observer observer) {
        void var1_1;
        this.checkRtpReceiverExists();
        if (this.nativeObserver != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, this.nativeObserver);
        }
        this.nativeObserver = RtpReceiver.nativeSetObserver(this.nativeRtpReceiver, (Observer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setFrameDecryptor(FrameDecryptorImpl frameDecryptor) {
        void var1_1;
        this.checkRtpReceiverExists();
        FrameDecryptorImpl frameDecryptorImpl = frameDecryptor;
        frameDecryptorImpl.setNativeFrameDecryptor(RtpReceiver.nativeWrapFrameDecryptor(frameDecryptorImpl.getObserver()));
        RtpReceiver.nativeSetFrameDecryptor(this.nativeRtpReceiver, var1_1.getNativeFrameDecryptor());
    }

    private void checkRtpReceiverExists() {
        if (this.nativeRtpReceiver == 0L) {
            throw new IllegalStateException("RtpReceiver has been disposed.");
        }
    }

    private static native long nativeGetTrack(long var0);

    private static native boolean nativeSetParameters(long var0, RtpParameters var2);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native String nativeGetId(long var0);

    private static native long nativeSetObserver(long var0, Observer var2);

    private static native void nativeUnsetObserver(long var0, long var2);

    private static native long nativeWrapFrameDecryptor(FrameDecryptorImpl.DecryptorObserver var0);

    private static native void nativeSetFrameDecryptor(long var0, long var2);

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onFirstPacketReceived(MediaStreamTrack.MediaType var1);
    }
}

