/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.support.annotation.Nullable;
import android.view.Surface;
import java.util.Timer;
import java.util.TimerTask;
import org.qnwebrtc.CapturerObserver;
import org.qnwebrtc.SurfaceTextureHelper;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.VideoCapturer;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoSink;

@TargetApi(value=21)
public class ScreenCapturerAndroid
implements VideoCapturer,
VideoSink {
    private static final int DISPLAY_FLAGS = 3;
    private static final int VIRTUAL_DISPLAY_DPI = 400;
    private final Intent mediaProjectionPermissionResultData;
    private final MediaProjection.Callback mediaProjectionCallback;
    private int width;
    private int height;
    private int frameRate;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private CapturerObserver capturerObserver;
    private long numCapturedFrames;
    @Nullable
    private MediaProjection mediaProjection;
    private boolean isDisposed;
    @Nullable
    private MediaProjectionManager mediaProjectionManager;
    private volatile long frameRateIntervalMs = -1L;
    @Nullable
    private Timer mUpdateFrameTimer;
    @Nullable
    private TimerTask mUpdateFrameTask;

    /*
     * WARNING - void declaration
     */
    public ScreenCapturerAndroid(Intent mediaProjectionPermissionResultData, MediaProjection.Callback mediaProjectionCallback) {
        void var2_2;
        void var1_1;
        this.mediaProjectionPermissionResultData = var1_1;
        this.mediaProjectionCallback = var2_2;
    }

    private void checkNotDisposed() {
        if (this.isDisposed) {
            throw new RuntimeException("capturer is disposed.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, CapturerObserver capturerObserver) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.checkNotDisposed();
        if (capturerObserver == null) {
            throw new RuntimeException("capturerObserver not set.");
        }
        this.capturerObserver = var3_3;
        if (surfaceTextureHelper == null) {
            throw new RuntimeException("surfaceTextureHelper not set.");
        }
        this.surfaceTextureHelper = var1_1;
        this.surfaceTextureHelper.setScreenCapture(true);
        this.mediaProjectionManager = (MediaProjectionManager)var2_2.getSystemService("media_projection");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void startCapture(int width, int height, int ignoredFramerate) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkNotDisposed();
        this.width = var1_1;
        this.height = var2_2;
        this.frameRate = var3_3;
        this.frameRateIntervalMs = 1000 / this.frameRate;
        this.mediaProjection = this.mediaProjectionManager.getMediaProjection(-1, this.mediaProjectionPermissionResultData);
        this.mediaProjection.registerCallback(this.mediaProjectionCallback, this.surfaceTextureHelper.getHandler());
        this.createVirtualDisplay();
        this.capturerObserver.onCapturerStarted(true);
        this.surfaceTextureHelper.startListening(this);
        if (this.mUpdateFrameTimer == null) {
            this.mUpdateFrameTimer = new Timer();
        }
        if (this.mUpdateFrameTask == null) {
            this.mUpdateFrameTask = this.createUpdateFrameTask();
        }
        this.mUpdateFrameTimer.scheduleAtFixedRate(this.mUpdateFrameTask, 0L, this.frameRateIntervalMs);
    }

    @Override
    public synchronized void stopCapture() {
        this.checkNotDisposed();
        ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(this){
            final /* synthetic */ ScreenCapturerAndroid this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                this.this$0.mUpdateFrameTimer.cancel();
                ScreenCapturerAndroid.access$002(this.this$0, null);
                this.this$0.surfaceTextureHelper.stopListening();
                this.this$0.capturerObserver.onCapturerStopped();
                if (this.this$0.virtualDisplay != null) {
                    this.this$0.virtualDisplay.release();
                    ScreenCapturerAndroid.access$302(this.this$0, null);
                }
                if (this.this$0.mediaProjection != null) {
                    this.this$0.mediaProjection.unregisterCallback(this.this$0.mediaProjectionCallback);
                    this.this$0.mediaProjection.stop();
                    ScreenCapturerAndroid.access$402(this.this$0, null);
                }
            }
        });
    }

    @Override
    public synchronized void dispose() {
        this.isDisposed = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void changeCaptureFormat(int width, int height, int frameRate) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.checkNotDisposed();
        this.width = var1_1;
        this.height = var2_2;
        this.frameRate = frameRate;
        this.frameRateIntervalMs = 1000 / var3_3;
        if (this.virtualDisplay == null) {
            return;
        }
        ThreadUtils.invokeAtFrontUninterruptibly(this.surfaceTextureHelper.getHandler(), new Runnable(this){
            final /* synthetic */ ScreenCapturerAndroid this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                if (this.this$0.mUpdateFrameTask != null) {
                    this.this$0.mUpdateFrameTask.cancel();
                    ScreenCapturerAndroid.access$602(this.this$0, null);
                }
                this.this$0.virtualDisplay.release();
                this.this$0.createVirtualDisplay();
                if (this.this$0.mUpdateFrameTimer != null) {
                    ScreenCapturerAndroid.access$602(this.this$0, this.this$0.createUpdateFrameTask());
                    this.this$0.mUpdateFrameTimer.scheduleAtFixedRate(this.this$0.mUpdateFrameTask, 0L, this.this$0.frameRateIntervalMs);
                }
            }
        });
    }

    private void createVirtualDisplay() {
        this.surfaceTextureHelper.setTextureSize(this.width, this.height);
        this.virtualDisplay = this.mediaProjection.createVirtualDisplay("WebRTC_ScreenCapture", this.width, this.height, 400, 3, new Surface(this.surfaceTextureHelper.getSurfaceTexture()), null, null);
    }

    @Override
    public void onFrame(VideoFrame frame) {
        VideoFrame videoFrame;
        long l2 = System.currentTimeMillis() * 1000000L;
        ++this.numCapturedFrames;
        videoFrame = new VideoFrame(frame.getBuffer(), videoFrame.getRotation(), l2);
        this.capturerObserver.onFrameCaptured(videoFrame);
        videoFrame.release();
    }

    @Override
    public boolean isScreencast() {
        return true;
    }

    public long getNumCapturedFrames() {
        return this.numCapturedFrames;
    }

    private TimerTask createUpdateFrameTask() {
        return new TimerTask(this){
            final /* synthetic */ ScreenCapturerAndroid this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                this.this$0.surfaceTextureHelper.requestDeliverTextureFrame();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Timer access$002(ScreenCapturerAndroid x0, Timer x1) {
        void var1_1;
        x0.mUpdateFrameTimer = var1_1;
        return x0.mUpdateFrameTimer;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ VirtualDisplay access$302(ScreenCapturerAndroid x0, VirtualDisplay x1) {
        void var1_1;
        x0.virtualDisplay = var1_1;
        return x0.virtualDisplay;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ MediaProjection access$402(ScreenCapturerAndroid x0, MediaProjection x1) {
        void var1_1;
        x0.mediaProjection = var1_1;
        return x0.mediaProjection;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ TimerTask access$602(ScreenCapturerAndroid x0, TimerTask x1) {
        void var1_1;
        x0.mUpdateFrameTask = var1_1;
        return x0.mUpdateFrameTask;
    }
}

