/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.Nullable;
import java.util.concurrent.Callable;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.GlUtil;
import org.qnwebrtc.Logging;
import org.qnwebrtc.RendererCommon;
import org.qnwebrtc.TextureBufferImpl;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.TimestampAligner;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoSink;
import org.qnwebrtc.YuvConverter;

public class SurfaceTextureHelper {
    private static final String TAG = "SurfaceTextureHelper";
    private final Handler handler;
    private final EglBase eglBase;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private final YuvConverter yuvConverter;
    @Nullable
    private final TimestampAligner timestampAligner;
    @Nullable
    private VideoSink listener;
    private boolean hasPendingTexture;
    private volatile boolean isTextureInUse;
    private boolean isQuitting;
    private int frameRotation;
    private int textureWidth;
    private int textureHeight;
    private boolean isScreenCapture;
    @Nullable
    private VideoSink pendingListener;
    final Runnable setListenerRunnable = new Runnable(this){
        final /* synthetic */ SurfaceTextureHelper this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
            Logging.d(SurfaceTextureHelper.TAG, "Setting listener to " + this.this$0.pendingListener);
            SurfaceTextureHelper.access$202(this.this$0, this.this$0.pendingListener);
            SurfaceTextureHelper.access$102(this.this$0, null);
            if (this.this$0.hasPendingTexture) {
                this.this$0.updateTexImage();
                SurfaceTextureHelper.access$302(this.this$0, false);
            }
        }
    };

    /*
     * WARNING - void declaration
     */
    public static SurfaceTextureHelper create(String threadName, EglBase.Context sharedContext, boolean alignTimestamps, YuvConverter yuvConverter) {
        String string;
        void var3_3;
        void var2_2;
        void var1_1;
        HandlerThread handlerThread = new HandlerThread(threadName);
        handlerThread.start();
        handlerThread = new Handler(handlerThread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly((Handler)handlerThread, new Callable<SurfaceTextureHelper>((EglBase.Context)var1_1, (Handler)handlerThread, (boolean)var2_2, (YuvConverter)var3_3, string){
            final /* synthetic */ EglBase.Context val$sharedContext;
            final /* synthetic */ Handler val$handler;
            final /* synthetic */ boolean val$alignTimestamps;
            final /* synthetic */ YuvConverter val$yuvConverter;
            final /* synthetic */ String val$threadName;
            {
                this.val$sharedContext = context;
                this.val$handler = handler;
                this.val$alignTimestamps = bl;
                this.val$yuvConverter = yuvConverter;
                this.val$threadName = string;
            }

            @Override
            @Nullable
            public SurfaceTextureHelper call() {
                try {
                    return new SurfaceTextureHelper(this.val$sharedContext, this.val$handler, this.val$alignTimestamps, this.val$yuvConverter);
                }
                catch (RuntimeException runtimeException) {
                    Logging.e(SurfaceTextureHelper.TAG, this.val$threadName + " create failure", runtimeException);
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static SurfaceTextureHelper create(String threadName, EglBase.Context sharedContext) {
        void var1_1;
        return SurfaceTextureHelper.create(threadName, (EglBase.Context)var1_1, false, new YuvConverter());
    }

    /*
     * WARNING - void declaration
     */
    public static SurfaceTextureHelper create(String threadName, EglBase.Context sharedContext, boolean alignTimestamps) {
        void var2_2;
        void var1_1;
        return SurfaceTextureHelper.create(threadName, (EglBase.Context)var1_1, (boolean)var2_2, new YuvConverter());
    }

    /*
     * WARNING - void declaration
     */
    private SurfaceTextureHelper(EglBase.Context sharedContext, Handler handler, boolean alignTimestamps, YuvConverter yuvConverter) {
        void var2_3;
        void var1_1;
        void var3_4;
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
        }
        this.handler = handler;
        this.timestampAligner = var3_4 != false ? new TimestampAligner() : null;
        this.yuvConverter = yuvConverter;
        this.eglBase = EglBase.create((EglBase.Context)var1_1, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException runtimeException) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw runtimeException;
        }
        this.oesTextureId = GlUtil.generateTexture(36197);
        this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
        SurfaceTextureHelper.setOnFrameAvailableListener(this.surfaceTexture, st -> {
            if (!this.isScreenCapture) {
                this.hasPendingTexture = true;
                this.tryDeliverTextureFrame();
            }
        }, (Handler)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener listener, Handler handler) {
        void var1_1;
        SurfaceTexture surfaceTexture2;
        if (Build.VERSION.SDK_INT >= 21) {
            void var2_2;
            surfaceTexture.setOnFrameAvailableListener(listener, (Handler)var2_2);
            return;
        }
        surfaceTexture2.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void startListening(VideoSink listener) {
        void var1_1;
        if (this.listener != null || this.pendingListener != null) {
            throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
        }
        this.pendingListener = var1_1;
        this.handler.post(this.setListenerRunnable);
    }

    public void stopListening() {
        Logging.d(TAG, "stopListening()");
        this.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, () -> {
            this.listener = null;
            this.pendingListener = null;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void setTextureSize(int textureWidth, int textureHeight) {
        void var2_2;
        void var1_1;
        if (textureWidth <= 0) {
            throw new IllegalArgumentException("Texture width must be positive, but was ".concat(String.valueOf(textureWidth)));
        }
        if (textureHeight <= 0) {
            throw new IllegalArgumentException("Texture height must be positive, but was ".concat(String.valueOf(textureHeight)));
        }
        this.surfaceTexture.setDefaultBufferSize(textureWidth, textureHeight);
        this.handler.post(() -> this.lambda$setTextureSize$2((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void setFrameRotation(int rotation) {
        void var1_1;
        this.handler.post(() -> this.lambda$setFrameRotation$3((int)var1_1));
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void requestDeliverTextureFrame() {
        this.handler.post(this::tryDeliverTextureFrame);
    }

    private void returnTextureFrame() {
        this.handler.post(() -> {
            this.isTextureInUse = false;
            if (this.isQuitting) {
                this.release();
                return;
            }
            if (!this.isScreenCapture) {
                this.tryDeliverTextureFrame();
            }
        });
    }

    public boolean isTextureInUse() {
        return this.isTextureInUse;
    }

    /*
     * WARNING - void declaration
     */
    public void setScreenCapture(boolean isScreenCapture) {
        void var1_1;
        this.isScreenCapture = var1_1;
    }

    public void dispose() {
        Logging.d(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, () -> {
            this.isQuitting = true;
            if (!this.isTextureInUse) {
                this.release();
            }
        });
    }

    @Deprecated
    public VideoFrame.I420Buffer textureToYuv(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.toI420();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexImage() {
        Object object = EglBase.lock;
        synchronized (object) {
            this.surfaceTexture.updateTexImage();
            return;
        }
    }

    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isQuitting || !this.isScreenCapture && !this.hasPendingTexture || this.isTextureInUse || this.listener == null) {
            return;
        }
        this.isTextureInUse = true;
        this.hasPendingTexture = false;
        this.updateTexImage();
        Object object = new float[16];
        this.surfaceTexture.getTransformMatrix((float[])object);
        long l2 = this.surfaceTexture.getTimestamp();
        if (l2 == 0L) {
            l2 = System.nanoTime();
        }
        if (this.timestampAligner != null) {
            l2 = this.timestampAligner.translateTimestamp(l2);
        }
        if (this.textureWidth == 0 || this.textureHeight == 0) {
            throw new RuntimeException("Texture size has not been set.");
        }
        object = new TextureBufferImpl(this.textureWidth, this.textureHeight, VideoFrame.TextureBuffer.Type.OES, this.oesTextureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix((float[])object), this.handler, this.yuvConverter, this::returnTextureFrame);
        object = new VideoFrame((VideoFrame.Buffer)object, this.frameRotation, l2);
        this.listener.onFrame((VideoFrame)object);
        ((VideoFrame)object).release();
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isTextureInUse || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        this.yuvConverter.release();
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
        this.surfaceTexture.release();
        this.eglBase.release();
        this.handler.getLooper().quit();
        if (this.timestampAligner != null) {
            this.timestampAligner.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$setFrameRotation$3(int rotation) {
        void var1_1;
        this.frameRotation = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$setTextureSize$2(int textureWidth, int textureHeight) {
        void var2_2;
        void var1_1;
        this.textureWidth = var1_1;
        this.textureHeight = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ VideoSink access$202(SurfaceTextureHelper x0, VideoSink x1) {
        void var1_1;
        x0.listener = var1_1;
        return x0.listener;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ VideoSink access$102(SurfaceTextureHelper x0, VideoSink x1) {
        void var1_1;
        x0.pendingListener = var1_1;
        return x0.pendingListener;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$302(SurfaceTextureHelper x0, boolean x1) {
        void var1_1;
        x0.hasPendingTexture = var1_1;
        return x0.hasPendingTexture;
    }
}

