/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.TextureView;
import java.util.concurrent.CountDownLatch;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.EglRenderer;
import org.qnwebrtc.GlRectDrawer;
import org.qnwebrtc.Logging;
import org.qnwebrtc.RendererCommon;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoSink;

public class TextureViewRenderer
extends TextureView
implements TextureView.SurfaceTextureListener,
VideoSink {
    private static final String TAG = "TextureViewRenderer";
    private final String resourceName;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
    private final EglRenderer eglRenderer;
    private RendererCommon.RendererEvents rendererEvents;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private int frameRotation;
    private int surfaceWidth;
    private int surfaceHeight;
    private boolean isFirstFrameRendered;
    private final Object layoutLock = new Object();
    private Handler uiThreadHandler = new Handler(Looper.getMainLooper());

    /*
     * WARNING - void declaration
     */
    public TextureViewRenderer(Context context) {
        super((Context)var1_1);
        void var1_1;
        this.resourceName = this.getResourceName();
        this.eglRenderer = new EglRenderer(this.resourceName);
        TextureViewRenderer textureViewRenderer = this;
        textureViewRenderer.setSurfaceTextureListener(textureViewRenderer);
    }

    /*
     * WARNING - void declaration
     */
    public TextureViewRenderer(Context context, AttributeSet attrs) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var2_2;
        void var1_1;
        this.resourceName = this.getResourceName();
        this.eglRenderer = new EglRenderer(this.resourceName);
        TextureViewRenderer textureViewRenderer = this;
        textureViewRenderer.setSurfaceTextureListener(textureViewRenderer);
    }

    /*
     * WARNING - void declaration
     */
    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents) {
        void var2_2;
        void var1_1;
        this.init((EglBase.Context)var1_1, (RendererCommon.RendererEvents)var2_2, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    /*
     * WARNING - void declaration
     */
    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        void var3_3;
        void var1_1;
        void var2_2;
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = var2_2;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init((EglBase.Context)var1_1, (int[])var3_3, drawer);
    }

    public void release() {
        this.eglRenderer.release();
    }

    /*
     * WARNING - void declaration
     */
    protected void postToRenderThread(Runnable runnable) {
        void var1_1;
        this.eglRenderer.postToRenderThread((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addFrameListener(EglRenderer.FrameListener listener, float scale, RendererCommon.GlDrawer drawerParam) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.eglRenderer.addFrameListener((EglRenderer.FrameListener)var1_1, (float)var2_2, (RendererCommon.GlDrawer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addFrameListener(EglRenderer.FrameListener listener, float scale) {
        void var2_2;
        void var1_1;
        this.eglRenderer.addFrameListener((EglRenderer.FrameListener)var1_1, (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void removeFrameListener(EglRenderer.FrameListener listener) {
        void var1_1;
        this.eglRenderer.removeFrameListener((EglRenderer.FrameListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMirror(boolean mirror) {
        void var1_1;
        this.eglRenderer.setMirror((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setFrameStretch(boolean stretch) {
        void var1_1;
        this.eglRenderer.setRenderScale(var1_1 == false);
    }

    /*
     * WARNING - void declaration
     */
    public void setScalingType(RendererCommon.ScalingType scalingType) {
        void var1_1;
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType((RendererCommon.ScalingType)var1_1);
        this.requestLayout();
    }

    /*
     * WARNING - void declaration
     */
    public void setScalingType(RendererCommon.ScalingType scalingTypeMatchOrientation, RendererCommon.ScalingType scalingTypeMismatchOrientation) {
        void var2_2;
        void var1_1;
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType((RendererCommon.ScalingType)var1_1, (RendererCommon.ScalingType)var2_2);
        this.requestLayout();
    }

    /*
     * WARNING - void declaration
     */
    public void setFpsReduction(float fps) {
        void var1_1;
        this.eglRenderer.setFpsReduction((float)var1_1);
    }

    public void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    public void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFrame(VideoFrame frame) {
        void var1_1;
        this.updateFrameDimensionsAndReportEvents(frame);
        this.eglRenderer.onFrame((VideoFrame)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void onMeasure(int widthSpec, int heightSpec) {
        void var2_3;
        void var1_1;
        ThreadUtils.checkIsOnMainThread();
        Point point = this.videoLayoutMeasure.measure((int)var1_1, (int)var2_3, this.rotatedFrameWidth, this.rotatedFrameHeight);
        this.setMeasuredDimension(point.x, point.y);
        this.logD("onMeasure(). New size: " + point.x + "x" + point.y);
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        void var3_3;
        void var2_2;
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setLayoutAspectRatio((float)(right - var2_2) / (float)(bottom - var3_3));
        Logging.d(TAG, "onLayout");
        this.updateSurfaceSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
                int n;
                int n2;
                float f2 = (float)this.getWidth() / (float)this.getHeight();
                if ((float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight > f2) {
                    n2 = (int)((float)this.rotatedFrameHeight * f2);
                    n = this.rotatedFrameHeight;
                } else {
                    n2 = this.rotatedFrameWidth;
                    n = (int)((float)this.rotatedFrameWidth / f2);
                }
                n2 = Math.min(this.getWidth(), n2);
                n = Math.min(this.getHeight(), n);
                this.logV("updateSurfaceSize. Layout size: " + this.getWidth() + "x" + this.getHeight() + ", frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + n2 + "x" + n + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
                if (n2 != this.surfaceWidth || n != this.surfaceHeight) {
                    this.surfaceWidth = n2;
                    this.surfaceHeight = n;
                }
            } else {
                TextureViewRenderer textureViewRenderer = this;
                textureViewRenderer.surfaceHeight = 0;
                textureViewRenderer.surfaceWidth = 0;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.createEglSurface((SurfaceTexture)var1_1);
        this.surfaceWidth = var2_2;
        this.surfaceHeight = var3_3;
        this.updateSurfaceSize();
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        ThreadUtils.checkIsOnMainThread();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.eglRenderer.releaseEglSurface(new Runnable(this, countDownLatch){
            final /* synthetic */ CountDownLatch val$completionLatch;
            final /* synthetic */ TextureViewRenderer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$completionLatch = countDownLatch;
            }

            @Override
            public void run() {
                this.val$completionLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        void var3_3;
        void var2_2;
        ThreadUtils.checkIsOnMainThread();
        this.logV("surfaceChanged: size: " + (int)var2_2 + "x" + (int)var3_3);
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        ThreadUtils.checkIsOnMainThread();
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId());
        }
        catch (Resources.NotFoundException notFoundException) {
            return "";
        }
    }

    public void clearImage() {
        this.eglRenderer.clearImage();
    }

    /*
     * WARNING - void declaration
     */
    private void postOrRun(Runnable r) {
        void var1_1;
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            r.run();
            return;
        }
        this.post((Runnable)var1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateFrameDimensionsAndReportEvents(VideoFrame frame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (!this.isFirstFrameRendered) {
                this.isFirstFrameRendered = true;
                this.logD("Reporting first rendered frame.");
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFirstFrameRendered();
                }
            }
            if (this.rotatedFrameWidth != frame.getRotatedWidth() || this.rotatedFrameHeight != frame.getRotatedHeight() || this.frameRotation != frame.getRotation()) {
                void var1_1;
                this.logD("Reporting frame resolution changed to " + frame.getBuffer().getWidth() + "x" + frame.getBuffer().getHeight() + " with rotation " + frame.getRotation());
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation());
                }
                this.rotatedFrameWidth = frame.getRotatedWidth();
                this.rotatedFrameHeight = frame.getRotatedHeight();
                this.frameRotation = var1_1.getRotation();
                this.uiThreadHandler.post(new Runnable(this){
                    final /* synthetic */ TextureViewRenderer this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    @Override
                    public void run() {
                        this.this$0.updateSurfaceSize();
                        this.this$0.requestLayout();
                    }
                });
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logD(String string) {
        void var1_1;
        Logging.d(TAG, this.resourceName + ": " + (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void logV(String string) {
        void var1_1;
        Logging.d(TAG, this.resourceName + ": " + (String)var1_1);
    }
}

