/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.support.annotation.Nullable;
import java.util.List;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.EncodedImage;
import org.qnwebrtc.VideoCodecStatus;
import org.qnwebrtc.VideoFrame;

public interface VideoEncoder {
    @CalledByNative
    default public long createNativeVideoEncoder() {
        return 0L;
    }

    @CalledByNative
    default public boolean isHardwareEncoder() {
        return true;
    }

    @CalledByNative
    public VideoCodecStatus initEncode(Settings var1, Callback var2);

    @CalledByNative
    public VideoCodecStatus release();

    @CalledByNative
    public VideoCodecStatus encode(VideoFrame var1, EncodeInfo var2);

    @CalledByNative
    public VideoCodecStatus setRateAllocation(BitrateAllocation var1, int var2);

    @CalledByNative
    public ScalingSettings getScalingSettings();

    @CalledByNative
    public String getImplementationName();

    @CalledByNative
    default public int getEncoderAlignment() {
        return 16;
    }

    public static interface Callback {
        public void onEncodedFrame(EncodedImage var1, CodecSpecificInfo var2);
    }

    public static class ScalingSettings {
        public final boolean on;
        @Nullable
        public final Integer low;
        @Nullable
        public final Integer high;
        public static final ScalingSettings OFF = new ScalingSettings();

        /*
         * WARNING - void declaration
         */
        public ScalingSettings(int low, int high) {
            void var2_2;
            void var1_1;
            this.on = true;
            this.low = (int)var1_1;
            this.high = (int)var2_2;
        }

        private ScalingSettings() {
            this.on = false;
            this.low = null;
            this.high = null;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public ScalingSettings(boolean on) {
            void var1_1;
            this.on = var1_1;
            this.low = null;
            this.high = null;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public ScalingSettings(boolean on, int low, int high) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.on = var1_1;
            this.low = (int)var2_2;
            this.high = (int)var3_3;
        }

        public String toString() {
            if (this.on) {
                return "[ " + this.low + ", " + this.high + " ]";
            }
            return "OFF";
        }
    }

    public static class BitrateAllocation {
        public final int[][] bitratesBbs;

        /*
         * WARNING - void declaration
         */
        @CalledByNative(value="BitrateAllocation")
        public BitrateAllocation(int[][] bitratesBbs) {
            void var1_1;
            this.bitratesBbs = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public int getSpatialLayerSum(int spatialIndex) {
            void var1_1;
            int n = 0;
            for (int n2 : this.bitratesBbs[var1_1]) {
                n += n2;
            }
            return n;
        }

        public int getSum() {
            int n = 0;
            int[][] nArray = this.bitratesBbs;
            int n2 = this.bitratesBbs.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int n3 : nArray[i2]) {
                    n += n3;
                }
            }
            return n;
        }
    }

    public static class CodecSpecificInfoH264
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP9
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP8
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfo {
    }

    public static class EncodeInfo {
        public final EncodedImage.FrameType[] frameTypes;

        /*
         * WARNING - void declaration
         */
        @CalledByNative(value="EncodeInfo")
        public EncodeInfo(EncodedImage.FrameType[] frameTypes) {
            void var1_1;
            this.frameTypes = var1_1;
        }
    }

    public static class Settings {
        public final int numberOfCores;
        public final int width;
        public final int height;
        public final int startBitrate;
        public final int maxFramerate;
        public final int numberOfSimulcastStreams;
        public final boolean automaticResizeOn;
        public final List<SimulcastStream> simulcastStreams;

        /*
         * WARNING - void declaration
         */
        @CalledByNative(value="Settings")
        public Settings(int numberOfCores, int width, int height, int startBitrate, int maxFramerate, int numberOfSimulcastStreams, boolean automaticResizeOn, List<SimulcastStream> simulcastStreams) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.numberOfCores = var1_1;
            this.width = var2_2;
            this.height = var3_3;
            this.startBitrate = startBitrate;
            this.maxFramerate = maxFramerate;
            this.numberOfSimulcastStreams = numberOfSimulcastStreams;
            this.automaticResizeOn = automaticResizeOn;
            this.simulcastStreams = simulcastStreams;
        }
    }

    public static class SimulcastStream {
        public int width;
        public int height;
        public int maxFramerate;
        public int numberOfTemporalLayers;
        public int maxBitrate;
        public int targetBitrate;
        public int minBitrate;
        public int qpMax;
        public boolean active;

        /*
         * WARNING - void declaration
         */
        @CalledByNative(value="SimulcastStream")
        public SimulcastStream(int width, int height, int maxFps, int numberOfTemporalLayers, int maxBitrate, int targetBitrate, int minBitrate, int qpMax, boolean active) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
            this.maxFramerate = var3_3;
            this.numberOfTemporalLayers = numberOfTemporalLayers;
            this.maxBitrate = maxBitrate;
            this.targetBitrate = targetBitrate;
            this.minBitrate = minBitrate;
            this.qpMax = qpMax;
            this.active = active;
        }
    }
}

