/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.os.Handler;
import android.os.HandlerThread;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import org.qnwebrtc.EglBase;
import org.qnwebrtc.Logging;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoSink;
import org.qnwebrtc.YuvConverter;
import org.qnwebrtc.YuvHelper;

public class VideoFileRenderer
implements VideoSink {
    private static final String TAG = "VideoFileRenderer";
    private final HandlerThread renderThread;
    private final Handler renderThreadHandler;
    private final HandlerThread fileThread;
    private final Handler fileThreadHandler;
    private final FileOutputStream videoOutFile;
    private final String outputFileName;
    private final int outputFileWidth;
    private final int outputFileHeight;
    private final int outputFrameSize;
    private final ByteBuffer outputFrameBuffer;
    private EglBase eglBase;
    private YuvConverter yuvConverter;
    private int frameCount;

    /*
     * WARNING - void declaration
     */
    public VideoFileRenderer(String outputFile, int outputFileWidth, int outputFileHeight, EglBase.Context sharedContext) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (outputFileWidth % 2 == 1 || outputFileHeight % 2 == 1) {
            throw new IllegalArgumentException("Does not support uneven width or height");
        }
        this.outputFileName = outputFile;
        this.outputFileWidth = outputFileWidth;
        this.outputFileHeight = outputFileHeight;
        this.outputFrameSize = outputFileWidth * outputFileHeight * 3 / 2;
        this.outputFrameBuffer = ByteBuffer.allocateDirect(this.outputFrameSize);
        this.videoOutFile = new FileOutputStream((String)var1_1);
        this.videoOutFile.write(("YUV4MPEG2 C420 W" + (int)var2_2 + " H" + (int)var3_3 + " Ip F30:1 A1:1\n").getBytes(Charset.forName("US-ASCII")));
        this.renderThread = new HandlerThread("VideoFileRendererRenderThread");
        this.renderThread.start();
        this.renderThreadHandler = new Handler(this.renderThread.getLooper());
        this.fileThread = new HandlerThread("VideoFileRendererFileThread");
        this.fileThread.start();
        this.fileThreadHandler = new Handler(this.fileThread.getLooper());
        ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, new Runnable(this, sharedContext){
            final /* synthetic */ EglBase.Context val$sharedContext;
            final /* synthetic */ VideoFileRenderer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$sharedContext = context;
            }

            @Override
            public void run() {
                VideoFileRenderer.access$002(this.this$0, EglBase.create(this.val$sharedContext, EglBase.CONFIG_PIXEL_BUFFER));
                this.this$0.eglBase.createDummyPbufferSurface();
                this.this$0.eglBase.makeCurrent();
                VideoFileRenderer.access$102(this.this$0, new YuvConverter());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFrame(VideoFrame frame) {
        void var1_1;
        frame.retain();
        this.renderThreadHandler.post(() -> this.lambda$onFrame$0((VideoFrame)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private void renderFrameOnRenderThread(VideoFrame frame) {
        void var1_1;
        VideoFrame.Buffer buffer = frame.getBuffer();
        int n = frame.getRotation() % 180 == 0 ? this.outputFileWidth : this.outputFileHeight;
        int n2 = frame.getRotation() % 180 == 0 ? this.outputFileHeight : this.outputFileWidth;
        float f2 = (float)buffer.getWidth() / (float)buffer.getHeight();
        float f3 = (float)n / (float)n2;
        int n3 = buffer.getWidth();
        int n4 = buffer.getHeight();
        if (f3 > f2) {
            n4 = (int)((float)n4 * (f2 / f3));
        } else {
            n3 = (int)((float)n3 * (f3 / f2));
        }
        int n5 = (buffer.getWidth() - n3) / 2;
        int n6 = (buffer.getHeight() - n4) / 2;
        buffer = buffer.cropAndScale(n5, n6, n3, n4, n, n2);
        frame.release();
        VideoFrame.I420Buffer i420Buffer = buffer.toI420();
        buffer.release();
        this.fileThreadHandler.post(() -> this.lambda$renderFrameOnRenderThread$1(i420Buffer, (VideoFrame)var1_1));
    }

    public void release() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.renderThreadHandler.post(() -> {
            void var1_1;
            this.yuvConverter.release();
            this.eglBase.release();
            this.renderThread.quit();
            var1_1.countDown();
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        this.fileThreadHandler.post(() -> {
            try {
                this.videoOutFile.close();
                Logging.d(TAG, "Video written to disk as " + this.outputFileName + ". The number of frames is " + this.frameCount + " and the dimensions of the frames are " + this.outputFileWidth + "x" + this.outputFileHeight + ".");
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error closing output file", iOException);
            }
            this.fileThread.quit();
        });
        try {
            this.fileThread.join();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            Logging.e(TAG, "Interrupted while waiting for the write to disk to complete.", interruptedException);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$renderFrameOnRenderThread$1(VideoFrame.I420Buffer i420, VideoFrame frame) {
        void var1_1;
        void var2_3;
        YuvHelper.I420Rotate(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), this.outputFrameBuffer, i420.getWidth(), i420.getHeight(), var2_3.getRotation());
        var1_1.release();
        try {
            this.videoOutFile.write("FRAME\n".getBytes(Charset.forName("US-ASCII")));
            this.videoOutFile.write(this.outputFrameBuffer.array(), this.outputFrameBuffer.arrayOffset(), this.outputFrameSize);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error writing video to disk", iOException);
        }
        ++this.frameCount;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$onFrame$0(VideoFrame frame) {
        void var1_1;
        this.renderFrameOnRenderThread((VideoFrame)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ EglBase access$002(VideoFileRenderer x0, EglBase x1) {
        void var1_1;
        x0.eglBase = var1_1;
        return x0.eglBase;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ YuvConverter access$102(VideoFileRenderer x0, YuvConverter x1) {
        void var1_1;
        x0.yuvConverter = var1_1;
        return x0.yuvConverter;
    }
}

