/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc;

import android.graphics.Matrix;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.qnwebrtc.GlGenericDrawer;
import org.qnwebrtc.GlShader;
import org.qnwebrtc.GlTextureFrameBuffer;
import org.qnwebrtc.GlUtil;
import org.qnwebrtc.JavaI420Buffer;
import org.qnwebrtc.JniCommon;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.VideoFrame;
import org.qnwebrtc.VideoFrameDrawer;

public class YuvConverter {
    private static final String FRAGMENT_SHADER = "uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final GlTextureFrameBuffer i420TextureFrameBuffer = new GlTextureFrameBuffer(6408);
    private final ShaderCallbacks shaderCallbacks = new ShaderCallbacks();
    private final GlGenericDrawer drawer = new GlGenericDrawer("uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n", this.shaderCallbacks);
    private final VideoFrameDrawer videoFrameDrawer;

    public YuvConverter() {
        this(new VideoFrameDrawer());
    }

    /*
     * WARNING - void declaration
     */
    public YuvConverter(VideoFrameDrawer videoFrameDrawer) {
        void var1_1;
        this.videoFrameDrawer = var1_1;
        this.threadChecker.detachThread();
    }

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer inputTextureBuffer) {
        VideoFrame.TextureBuffer textureBuffer;
        this.threadChecker.checkIsOnValidThread();
        VideoFrame.TextureBuffer textureBuffer2 = inputTextureBuffer;
        textureBuffer = (VideoFrame.TextureBuffer)this.videoFrameDrawer.prepareBufferForViewportSize(textureBuffer2, textureBuffer2.getWidth(), textureBuffer.getHeight());
        int n = textureBuffer.getWidth();
        int n2 = textureBuffer.getHeight();
        int n3 = (n + 7) / 8 * 8;
        int n4 = (n2 + 1) / 2;
        int n5 = n2 + n4;
        ByteBuffer byteBuffer = JniCommon.nativeAllocateByteBuffer(n3 * n5);
        int n6 = n3 / 4;
        Object object = new Matrix();
        object.preTranslate(0.5f, 0.5f);
        object.preScale(1.0f, -1.0f);
        object.preTranslate(-0.5f, -0.5f);
        this.i420TextureFrameBuffer.setSize(n6, n5);
        GLES20.glBindFramebuffer((int)36160, (int)this.i420TextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        this.shaderCallbacks.setPlaneY();
        VideoFrameDrawer.drawTexture(this.drawer, textureBuffer, object, n, n2, 0, 0, n6, n2);
        this.shaderCallbacks.setPlaneU();
        VideoFrameDrawer.drawTexture(this.drawer, textureBuffer, object, n, n2, 0, n2, n6 / 2, n4);
        this.shaderCallbacks.setPlaneV();
        VideoFrameDrawer.drawTexture(this.drawer, textureBuffer, object, n, n2, n6 / 2, n2, n6 / 2, n4);
        GLES20.glReadPixels((int)0, (int)0, (int)this.i420TextureFrameBuffer.getWidth(), (int)this.i420TextureFrameBuffer.getHeight(), (int)6408, (int)5121, (Buffer)byteBuffer);
        GlUtil.checkNoGLES2Error("YuvConverter.convert");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        n5 = 0 + n3 * n2;
        n6 = n5 + n3 / 2;
        byteBuffer.position(0);
        byteBuffer.limit(n5);
        object = byteBuffer.slice();
        byteBuffer.position(n5);
        n4 = n3 * (n4 - 1) + n3 / 2;
        byteBuffer.limit(n5 + n4);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.position(n6);
        byteBuffer.limit(n6 + n4);
        ByteBuffer byteBuffer3 = byteBuffer.slice();
        textureBuffer.release();
        return JavaI420Buffer.wrap(n, n2, (ByteBuffer)object, n3, byteBuffer2, n3, byteBuffer3, n3, () -> JniCommon.nativeFreeByteBuffer(byteBuffer));
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        this.drawer.release();
        this.i420TextureFrameBuffer.release();
        this.videoFrameDrawer.release();
        this.threadChecker.detachThread();
    }

    static class ShaderCallbacks
    implements GlGenericDrawer.ShaderCallbacks {
        private static final float[] yCoeffs = new float[]{0.256788f, 0.504129f, 0.0979059f, 0.0627451f};
        private static final float[] uCoeffs = new float[]{-0.148223f, -0.290993f, 0.439216f, 0.501961f};
        private static final float[] vCoeffs = new float[]{0.439216f, -0.367788f, -0.0714274f, 0.501961f};
        private int xUnitLoc;
        private int coeffsLoc;
        private float[] coeffs;
        private float stepSize;

        private ShaderCallbacks() {
        }

        public void setPlaneY() {
            this.coeffs = yCoeffs;
            this.stepSize = 1.0f;
        }

        public void setPlaneU() {
            this.coeffs = uCoeffs;
            this.stepSize = 2.0f;
        }

        public void setPlaneV() {
            this.coeffs = vCoeffs;
            this.stepSize = 2.0f;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onNewShader(GlShader shader) {
            void var1_1;
            this.xUnitLoc = shader.getUniformLocation("xUnit");
            this.coeffsLoc = var1_1.getUniformLocation("coeffs");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onPrepareShader(GlShader shader, float[] texMatrix, int frameWidth, int frameHeight, int viewportWidth, int viewportHeight) {
            void var3_3;
            void var2_2;
            GLES20.glUniform4fv((int)this.coeffsLoc, (int)1, (float[])this.coeffs, (int)0);
            GLES20.glUniform2f((int)this.xUnitLoc, (float)(this.stepSize * texMatrix[0] / (float)frameWidth), (float)(this.stepSize * var2_2[1] / (float)var3_3));
        }
    }
}

