/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc.audio;

import android.media.AudioManager;
import android.support.annotation.Nullable;
import java.util.Timer;
import java.util.TimerTask;
import org.qnwebrtc.Logging;
import org.qnwebrtc.audio.WebRtcAudioUtils;

class VolumeLogger {
    private static final String TAG = "VolumeLogger";
    private static final String THREAD_NAME = "WebRtcVolumeLevelLoggerThread";
    private static final int TIMER_PERIOD_IN_SECONDS = 30;
    private final AudioManager audioManager;
    @Nullable
    private Timer timer;

    /*
     * WARNING - void declaration
     */
    public VolumeLogger(AudioManager audioManager) {
        void var1_1;
        this.audioManager = var1_1;
    }

    public void start() {
        Logging.d(TAG, "start" + WebRtcAudioUtils.getThreadInfo());
        if (this.timer != null) {
            return;
        }
        Logging.d(TAG, "audio mode is: " + WebRtcAudioUtils.modeToString(this.audioManager.getMode()));
        this.timer = new Timer(THREAD_NAME);
        VolumeLogger volumeLogger = this;
        this.timer.schedule((TimerTask)volumeLogger.new LogVolumeTask(volumeLogger.audioManager.getStreamMaxVolume(2), this.audioManager.getStreamMaxVolume(0)), 0L, 30000L);
    }

    public void stop() {
        Logging.d(TAG, "stop" + WebRtcAudioUtils.getThreadInfo());
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    class LogVolumeTask
    extends TimerTask {
        private final int maxRingVolume;
        private final int maxVoiceCallVolume;

        /*
         * WARNING - void declaration
         */
        LogVolumeTask(int maxRingVolume, int maxVoiceCallVolume) {
            void var3_3;
            void var2_2;
            this.maxRingVolume = var2_2;
            this.maxVoiceCallVolume = var3_3;
        }

        @Override
        public void run() {
            int n = VolumeLogger.this.audioManager.getMode();
            if (n == 1) {
                Logging.d(VolumeLogger.TAG, "STREAM_RING stream volume: " + VolumeLogger.this.audioManager.getStreamVolume(2) + " (max=" + this.maxRingVolume + ")");
                return;
            }
            if (n == 3) {
                Logging.d(VolumeLogger.TAG, "VOICE_CALL stream volume: " + VolumeLogger.this.audioManager.getStreamVolume(0) + " (max=" + this.maxVoiceCallVolume + ")");
            }
        }
    }
}

